/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.config.values.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.MapData;

public class RenderUtils {
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");

    public static void setupBlend() {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderUtils.mc().func_110434_K().func_110577_a(texture);
    }

    public static void color(float r, float g, float b, float a) {
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableItemLighting() {
        RenderHelper.func_74518_a();
    }

    public static void enableItemLighting() {
        RenderHelper.func_74519_b();
    }

    public static void enableGuiItemLighting() {
        RenderHelper.func_74520_c();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        RenderUtils.setupBlend();
        RenderUtils.color(r, g, b, a);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)x, (double)y, (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, zLevel, buffer);
        tessellator.func_78381_a();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, BufferBuilder buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder buffer) {
        float pixelWidth = 0.00390625f;
        buffer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)u * pixelWidth), (double)((float)v * pixelWidth)).func_181675_d();
    }

    public static void drawHoverText(int x, int y, List<String> textLines) {
        Minecraft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            FontRenderer font = mc.field_71466_p;
            GlStateManager.func_179101_C();
            RenderUtils.disableItemLighting();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().field_146294_l;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\\\n")) {
                    int length = font.func_78256_a(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            int lineHeight = font.field_78288_b + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                font.func_175063_a(str, (float)textStartX, (float)textStartY, -1);
                textStartY += lineHeight;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        float sa = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float sr = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float sg = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float sb = (float)(startColor & 0xFF) / 255.0f;
        float ea = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float er = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float eg = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float eb = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        RenderUtils.setupBlend();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, zLevel).func_181666_a(sr, sg, sb, sa).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, zLevel).func_181666_a(sr, sg, sb, sa).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, zLevel).func_181666_a(er, eg, eb, ea).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(er, eg, eb, ea).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawCenteredString(int x, int y, int color, String text) {
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        textRenderer.func_175063_a(text, (float)(x - textRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, String texture) {
        if (texture != null) {
            GlStateManager.func_179140_f();
            TextureAtlasSprite sprite = RenderUtils.mc().func_147117_R().func_110572_b(texture);
            RenderUtils.mc().field_71456_v.func_175175_a(x, y, sprite, width, height);
        }
    }

    public static void draw9SplicedTexture(int x, int y, int u, int v, int width, int height, int texWidth, int texHeight, int edgeThickness, float zLevel) {
        int doneWidth;
        int tmpW;
        int tmpX;
        int requiredWidth;
        int repeatableWidth;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int e = edgeThickness;
        RenderUtils.drawTexturedRectBatched(x, y, u, v, e, e, zLevel, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + height - e, u, v + texHeight - e, e, e, zLevel, buffer);
        RenderUtils.drawTexturedRectBatched(x + width - e, y, u + texWidth - e, v, e, e, zLevel, buffer);
        RenderUtils.drawTexturedRectBatched(x + width - e, y + height - e, u + texWidth - e, v + texHeight - e, e, e, zLevel, buffer);
        if (texWidth < width) {
            repeatableWidth = texWidth - 2 * e;
            requiredWidth = width - 2 * e;
            tmpX = x + e;
            tmpW = 0;
            for (doneWidth = 0; doneWidth < requiredWidth; doneWidth += tmpW) {
                tmpW = Math.min(repeatableWidth, requiredWidth - doneWidth);
                RenderUtils.drawTexturedRectBatched(tmpX, y, u + e, v, tmpW, e, zLevel, buffer);
                RenderUtils.drawTexturedRectBatched(tmpX, y + height - e, u + e, v + texHeight - e, tmpW, e, zLevel, buffer);
                tmpX += tmpW;
            }
        } else {
            RenderUtils.drawTexturedRectBatched(x + e, y, u + e, v, width - 2 * e, e, zLevel, buffer);
            RenderUtils.drawTexturedRectBatched(x + e, y + height - e, u + e, v + texHeight - e, width - 2 * e, e, zLevel, buffer);
        }
        if (texHeight < height) {
            int repeatableHeight = texHeight - 2 * e;
            int requiredHeight = height - 2 * e;
            int tmpY = y + e;
            int tmpH = 0;
            for (int doneHeight = 0; doneHeight < requiredHeight; doneHeight += tmpH) {
                tmpH = Math.min(repeatableHeight, requiredHeight - doneHeight);
                RenderUtils.drawTexturedRectBatched(x, tmpY, u, v + e, e, tmpH, zLevel, buffer);
                RenderUtils.drawTexturedRectBatched(x + width - e, tmpY, u + texWidth - e, v + e, e, tmpH, zLevel, buffer);
                tmpY += tmpH;
            }
        } else {
            RenderUtils.drawTexturedRectBatched(x, y + e, u, v + e, e, height - 2 * e, zLevel, buffer);
            RenderUtils.drawTexturedRectBatched(x + width - e, y + e, u + texWidth - e, v + e, e, height - 2 * e, zLevel, buffer);
        }
        if (texWidth < width || texHeight < height) {
            repeatableWidth = texWidth - 2 * e;
            requiredWidth = width - 2 * e;
            tmpX = x + e;
            tmpW = 0;
            for (doneWidth = 0; doneWidth < requiredWidth; doneWidth += tmpW) {
                int repeatableHeight = texHeight - 2 * e;
                int requiredHeight = height - 2 * e;
                tmpW = Math.min(repeatableWidth, requiredWidth - doneWidth);
                int tmpY = y + e;
                int tmpH = 0;
                for (int doneHeight = 0; doneHeight < requiredHeight; doneHeight += tmpH) {
                    tmpH = Math.min(repeatableHeight, requiredHeight - doneHeight);
                    RenderUtils.drawTexturedRectBatched(tmpX, tmpY, u + e, v + e, tmpW, tmpH, zLevel, buffer);
                    tmpY += tmpH;
                }
                tmpX += tmpW;
            }
        } else {
            RenderUtils.drawTexturedRectBatched(x + e, y + e, u + e, v + e, width - 2 * e, height - 2 * e, zLevel, buffer);
        }
        tessellator.func_78381_a();
    }

    public static void renderText(int x, int y, int color, String text) {
        String[] parts = text.split("\\\\n");
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        for (String line : parts) {
            textRenderer.func_175063_a(line, (float)x, (float)y, color);
            y += textRenderer.field_78288_b + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines) {
        if (!lines.isEmpty()) {
            FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
            for (String line : lines) {
                textRenderer.func_78276_b(line, x, y, color);
                y += textRenderer.field_78288_b + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines) {
        FontRenderer fontRenderer = RenderUtils.mc().field_71466_p;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        int lineHeight = fontRenderer.field_78288_b + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale == 0.0) {
            return 0;
        }
        if (scale != 1.0) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)0.0);
        }
        double posX = xOff + bgMargin;
        double posY = yOff + bgMargin;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (EntityPlayer)RenderUtils.mc().field_71439_g);
        for (String line : lines) {
            int width = fontRenderer.func_78256_a(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - (double)bgMargin;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                RenderUtils.drawRect(x - bgMargin, y - bgMargin, width + bgMargin, bgMargin + fontRenderer.field_78288_b, bgColor);
            }
            if (useShadow) {
                fontRenderer.func_175063_a(line, (float)x, (float)y, textColor);
                continue;
            }
            fontRenderer.func_78276_b(line, x, y, textColor);
        }
        if (scale != 1.0) {
            GlStateManager.func_179121_F();
        }
        return contentHeight + bgMargin * 2;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, EntityPlayer player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.func_70651_bq();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (PotionEffect effect : effects) {
                    Potion potion = effect.func_188419_a();
                    if (!effect.func_188418_e() || !potion.func_76400_d()) continue;
                    if (potion.func_188408_i()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockSpaceAllSidesBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.func_177958_n() - expand;
        double minY = (double)pos.func_177956_o() - expand;
        double minZ = (double)pos.func_177952_p() - expand;
        double maxX = (double)pos.func_177958_n() + expand + 1.0;
        double maxY = (double)pos.func_177956_o() + expand + 1.0;
        double maxZ = (double)pos.func_177952_p() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockSpaceAllOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.func_177958_n() - expand;
        double minY = (double)pos.func_177956_o() - expand;
        double minZ = (double)pos.func_177952_p() - expand;
        double maxX = (double)pos.func_177958_n() + expand + 1.0;
        double maxY = (double)pos.func_177956_o() + expand + 1.0;
        double maxZ = (double)pos.func_177952_p() + expand + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double x1 = posMin.func_177958_n();
        double y1 = posMin.func_177956_o();
        double z1 = posMin.func_177952_p();
        double x2 = posMax.func_177958_n() + 1;
        double y2 = posMax.func_177956_o() + 1;
        double z2 = posMax.func_177952_p() + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBlockSpaceSideBatchedQuads(BlockPos pos, EnumFacing side, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.func_177958_n() - expand;
        double minY = (double)pos.func_177956_o() - expand;
        double minZ = (double)pos.func_177952_p() - expand;
        double maxX = (double)pos.func_177958_n() + expand + 1.0;
        double maxY = (double)pos.func_177956_o() + expand + 1.0;
        double maxZ = (double)pos.func_177952_p() + expand + 1.0;
        switch (side) {
            case DOWN: {
                buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                break;
            }
            case UP: {
                buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                break;
            }
            case NORTH: {
                buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                break;
            }
            case SOUTH: {
                buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                break;
            }
            case WEST: {
                buffer.func_181662_b(minX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(minX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                break;
            }
            case EAST: {
                buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, minY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
            }
        }
    }

    public static void drawBox(IntBoundingBox bb, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minX = bb.minX;
        double minY = bb.minY;
        double minZ = bb.minZ;
        double maxX = bb.maxX + 1;
        double maxY = bb.maxY + 1;
        double maxZ = bb.maxZ + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawBox(StructureBoundingBox bb, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minX = bb.field_78897_a;
        double minY = bb.field_78895_b;
        double minZ = bb.field_78896_c;
        double maxX = bb.field_78893_d + 1;
        double maxY = bb.field_78894_e + 1;
        double maxZ = bb.field_78892_f + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        Entity entity = RenderUtils.mc().func_175606_aa();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.field_70177_z, entity.field_70125_A, scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        if (disableDepth) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
        }
        RenderUtils.setupBlend();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.func_78256_a(line));
        }
        int strLenHalf = maxLineLen / 2;
        int textHeight = textRenderer.field_78288_b * text.size() - 1;
        float bga = (float)(bgColor >>> 24 & 0xFF) * 255.0f;
        float bgr = (float)(bgColor >>> 16 & 0xFF) * 255.0f;
        float bgg = (float)(bgColor >>> 8 & 0xFF) * 255.0f;
        float bgb = (float)(bgColor & 0xFF) * 255.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(-strLenHalf - 1), -1.0, 0.0).func_181666_a(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_181662_b((double)(-strLenHalf - 1), (double)textHeight, 0.0).func_181666_a(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_181662_b((double)strLenHalf, (double)textHeight, 0.0).func_181666_a(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_181662_b((double)strLenHalf, -1.0, 0.0).func_181666_a(bgr, bgg, bgb, bga).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        int textY = 0;
        if (!disableDepth) {
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-0.6f, (float)-1.2f);
        }
        for (String line : text) {
            if (disableDepth) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
            }
            textRenderer.func_78276_b(line, -strLenHalf, textY, 0x20000000 | textColor & 0xFFFFFF);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            textRenderer.func_78276_b(line, -strLenHalf, textY, textColor);
            textY += textRenderer.field_78288_b;
        }
        if (!disableDepth) {
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void renderBlockTargetingOverlay(Entity entity, BlockPos pos, EnumFacing side, Vec3d hitVec, Color4f color, float partialTicks) {
        EnumFacing playerFacing = entity.func_174811_aO();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        double x = (double)pos.func_177958_n() + 0.5 - dx;
        double y = (double)pos.func_177956_o() + 0.5 - dy;
        double z = (double)pos.func_177952_p() + 0.5 - dz;
        GlStateManager.func_179094_E();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float quadAlpha = 0.18f;
        float ha = color.a;
        float hr = color.r;
        float hg = color.g;
        float hb = color.b;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x - 0.5, y - 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, quadAlpha).func_181675_d();
        buffer.func_181662_b(x + 0.5, y - 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, quadAlpha).func_181675_d();
        buffer.func_181662_b(x + 0.5, y + 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, quadAlpha).func_181675_d();
        buffer.func_181662_b(x - 0.5, y + 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, quadAlpha).func_181675_d();
        switch (part) {
            case CENTER: {
                buffer.func_181662_b(x - 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case LEFT: {
                buffer.func_181662_b(x - 0.5, y - 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.5, y + 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case RIGHT: {
                buffer.func_181662_b(x + 0.5, y - 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.5, y + 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case TOP: {
                buffer.func_181662_b(x - 0.5, y + 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.5, y + 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case BOTTOM: {
                buffer.func_181662_b(x - 0.5, y - 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x - 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y - 0.25, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                buffer.func_181662_b(x + 0.5, y - 0.5, z).func_181666_a(hr, hg, hb, ha).func_181675_d();
                break;
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.6f);
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x - 0.25, y - 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.25, y - 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.25, y + 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x - 0.25, y + 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x - 0.5, y - 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x - 0.25, y - 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x - 0.5, y + 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x - 0.25, y + 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.5, y - 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.25, y - 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.5, y + 0.5, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.25, y + 0.25, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderBlockTargetingOverlaySimple(Entity entity, BlockPos pos, EnumFacing side, Color4f color, float partialTicks) {
        EnumFacing playerFacing = entity.func_174811_aO();
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        double x = (double)pos.func_177958_n() + 0.5 - dx;
        double y = (double)pos.func_177956_o() + 0.5 - dy;
        double z = (double)pos.func_177952_p() + 0.5 - dz;
        GlStateManager.func_179094_E();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float a = color.a;
        float r = color.r;
        float g = color.g;
        float b = color.b;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x - 0.5, y - 0.5, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x + 0.5, y - 0.5, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x + 0.5, y + 0.5, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x - 0.5, y + 0.5, z).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.6f);
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x - 0.375, y - 0.375, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.375, y - 0.375, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + 0.375, y + 0.375, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(x - 0.375, y + 0.375, z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, EnumFacing side, EnumFacing playerFacing) {
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        switch (side) {
            case DOWN: {
                GlStateManager.func_179114_b((float)(180.0f - playerFacing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)(180.0f - playerFacing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z + 0.501));
    }

    public static void renderMapPreview(ItemStack stack, int x, int y, int dimensions) {
        if (stack.func_77973_b() instanceof ItemMap && GuiBase.isShiftDown()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            RenderUtils.bindTexture(TEXTURE_MAP_BACKGROUND);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)x1, (double)y2, (double)z).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)x2, (double)y2, (double)z).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)x2, (double)y1, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)x1, (double)y1, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            MapData mapdata = Items.field_151098_aY.func_77873_a(stack, (World)RenderUtils.mc().field_71441_e);
            if (mapdata != null) {
                z = 310;
                double scale = (double)(dimensions - 16) / 128.0;
                GlStateManager.func_179109_b((float)(x1 += 8), (float)(y1 += 8), (float)z);
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)0.0);
                RenderUtils.mc().field_71460_t.func_147701_i().func_148250_a(mapdata, false);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderShulkerBoxPreview(ItemStack stack, int x, int y, boolean useBgColors) {
        if (stack.func_77942_o()) {
            NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            GlStateManager.func_179094_E();
            RenderUtils.disableItemLighting();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)700.0f);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            x += 8;
            y -= props.height + 18;
            if (stack.func_77973_b() instanceof ItemShulkerBox) {
                RenderUtils.setShulkerboxBackgroundTintColor((BlockShulkerBox)((ItemBlock)stack.func_77973_b()).func_179223_d(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableGuiItemLighting();
            GlStateManager.func_179126_j();
            GlStateManager.func_179091_B();
            IInventory inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable BlockShulkerBox block, boolean useBgColors) {
        if (useBgColors && block != null && block.func_190956_e() != null) {
            EnumDyeColor dye = block.func_190956_e();
            float[] colors = dye.func_193349_f();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, IBakedModel model, IBlockState state, float zLevel) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        GlStateManager.func_179094_E();
        RenderUtils.bindTexture(TextureMap.field_110575_b);
        RenderUtils.mc().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.func_177556_c(), zLevel);
        GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.625, (double)0.625, (double)0.625);
        RenderUtils.renderModel(model, state);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + zLevel));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    private static void renderModel(IBakedModel model, IBlockState state) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int color = -1;
        if (!model.func_188618_c()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                RenderUtils.renderQuads(bufferbuilder, model.func_188616_a(state, enumfacing, 0L), state, color);
            }
            RenderUtils.renderQuads(bufferbuilder, model.func_188616_a(state, null, 0L), state, color);
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, IBlockState state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            BakedQuad quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(BufferBuilder buffer, BakedQuad quad, IBlockState state, int color) {
        buffer.func_178981_a(quad.func_178209_a());
        buffer.func_178968_d(color);
        if (quad.func_178212_b()) {
            BlockColors blockColors = RenderUtils.mc().func_184125_al();
            int m = blockColors.func_186724_a(state, null, null, quad.func_178211_c());
            float r = (float)(m >>> 16 & 0xFF) / 255.0f;
            float g = (float)(m >>> 8 & 0xFF) / 255.0f;
            float b = (float)(m & 0xFF) / 255.0f;
            buffer.func_178978_a(r, g, b, 4);
            buffer.func_178978_a(r, g, b, 3);
            buffer.func_178978_a(r, g, b, 2);
            buffer.func_178978_a(r, g, b, 1);
        }
        RenderUtils.putQuadNormal(buffer, quad);
    }

    private static void putQuadNormal(BufferBuilder renderer, BakedQuad quad) {
        Vec3i direction = quad.func_178210_d().func_176730_m();
        renderer.func_178975_e((float)direction.func_177958_n(), (float)direction.func_177956_o(), (float)direction.func_177952_p());
    }

    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }
}

