/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class InventoryOverlay {
    public static final ResourceLocation TEXTURE_BREWING_STAND = new ResourceLocation("textures/gui/container/brewing_stand.png");
    public static final ResourceLocation TEXTURE_DISPENSER = new ResourceLocation("textures/gui/container/dispenser.png");
    public static final ResourceLocation TEXTURE_DOUBLE_CHEST = new ResourceLocation("textures/gui/container/generic_54.png");
    public static final ResourceLocation TEXTURE_FURNACE = new ResourceLocation("textures/gui/container/furnace.png");
    public static final ResourceLocation TEXTURE_HOPPER = new ResourceLocation("textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_PLAYER_INV = new ResourceLocation("textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_SINGLE_CHEST = new ResourceLocation("textures/gui/container/shulker_box.png");
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public static void renderInventoryBackground(InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, Minecraft mc) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (type == InventoryRenderType.FURNACE) {
            RenderUtils.bindTexture(TEXTURE_FURNACE);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 84, 0, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 64, 0, 162, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 92, y + 4, 172, 102, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 52, 13, 88, 60, buffer);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            RenderUtils.bindTexture(TEXTURE_BREWING_STAND);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 63, 0, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 68, 0, 162, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 113, y + 4, 172, 98, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 13, 13, 109, 64, buffer);
        } else if (type == InventoryRenderType.DISPENSER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.HOPPER) {
            RenderUtils.bindTexture(TEXTURE_HOPPER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 79, 0, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 25, 0, 126, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 97, y + 7, 169, 108, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 43, 19, 90, 18, buffer);
        } else if (type == InventoryRenderType.VILLAGER) {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 133, 0, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 79, 0, 215, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 43, y + 7, 169, 143, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 36, 72, buffer);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, buffer, mc);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, buffer, mc);
        } else {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, bgh, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 176 - bgw, 0, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + bgh, 0, 215, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + bgw, y + 7, 169, 222 - bgh, 7, bgh, buffer);
            for (int row = 0; row < rows; ++row) {
                int rowLen = MathHelper.func_76125_a((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, buffer);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
            }
        }
        tessellator.func_78381_a();
    }

    public static void renderInventoryBackground27(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_SINGLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 105, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 54, buffer);
    }

    public static void renderInventoryBackground54(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 115, 0, 215, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 107, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 108, buffer);
    }

    public static void renderEquipmentOverlayBackground(int x, int y, EntityLivingBase entity) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.bindTexture(TEXTURE_DISPENSER);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 50, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y, 173, 0, 3, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 83, 0, 163, 50, 3, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y + 83, 173, 163, 3, 3, buffer);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(x + xOff, y + yOff, 61, 16, 18, 18, buffer);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(x + 28, y + 36 + 7, 61, 16, 18, 18, buffer);
        RenderUtils.drawTexturedRectBatched(x + 28, y + 54 + 7, 61, 16, 18, 18, buffer);
        tessellator.func_78381_a();
        RenderUtils.bindTexture(TextureMap.field_110575_b);
        if (entity.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
            String texture = "minecraft:items/empty_armor_slot_shield";
            RenderUtils.renderSprite(x + 28 + 1, y + 54 + 7 + 1, 16, 16, texture);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            EntityEquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.func_184582_a(eqSlot).func_190926_b()) {
                String texture = ItemArmor.field_94603_a[eqSlot.func_188454_b()];
                RenderUtils.renderSprite(x + xOff + 1, y + yOff + 1, 16, 16, texture);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(IInventory inv) {
        if (inv instanceof TileEntityShulkerBox) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof InventoryLargeChest) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof TileEntityFurnace) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof TileEntityBrewingStand) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof TileEntityDispenser) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof TileEntityHopper) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof ContainerHorseChest) {
            return InventoryRenderType.HORSE;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            if (block instanceof BlockShulkerBox || block instanceof BlockChest) {
                return InventoryRenderType.FIXED_27;
            }
            if (block instanceof BlockFurnace) {
                return InventoryRenderType.FURNACE;
            }
            if (block instanceof BlockDispenser) {
                return InventoryRenderType.DISPENSER;
            }
            if (block instanceof BlockHopper) {
                return InventoryRenderType.HOPPER;
            }
        } else if (item == Items.field_151067_bt) {
            return InventoryRenderType.BREWING_STAND;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 127;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else {
            if (type == InventoryRenderType.FIXED_27) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, IInventory inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc) {
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(inv.func_70301_a(0), startX + 8, startY + 8, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(1), startX + 8, startY + 44, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(2), startX + 68, startY + 26, 1.0f, mc);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(inv.func_70301_a(0), startX + 47, startY + 42, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(1), startX + 70, startY + 49, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(2), startX + 93, startY + 42, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(3), startX + 70, startY + 8, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.func_70301_a(4), startX + 8, startY + 8, 1.0f, mc);
        } else {
            int slots = inv.func_70302_i_();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ItemStack stack = inv.func_70301_a(slot);
                    if (!stack.func_190926_b()) {
                        InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
    }

    public static void renderEquipmentStacks(EntityLivingBase entity, int x, int y, Minecraft mc) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            EntityEquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            ItemStack stack = entity.func_184582_a(eqSlot);
            if (!stack.func_190926_b()) {
                InventoryOverlay.renderStackAt(stack, x + xOff + 1, y + yOff + 1, 1.0f, mc);
            }
            ++i;
            yOff += 18;
        }
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (!stack.func_190926_b()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 36 + 7 + 1, 1.0f, mc);
        }
        if (!(stack = entity.func_184582_a(EntityEquipmentSlot.OFFHAND)).func_190926_b()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 54 + 7 + 1, 1.0f, mc);
        }
    }

    public static void renderItemStacks(NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                ItemStack stack = (ItemStack)items.get(slot);
                if (!stack.func_190926_b()) {
                    InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(ItemStack stack, float x, float y, float scale, Minecraft mc) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179140_f();
        RenderUtils.enableGuiItemLighting();
        mc.func_175599_af().field_77023_b += 100.0f;
        mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, stack, 0, 0);
        mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
        mc.func_175599_af().field_77023_b -= 100.0f;
        RenderUtils.disableItemLighting();
        GlStateManager.func_179121_F();
    }

    public static void renderStackToolTip(int x, int y, ItemStack stack, Minecraft mc) {
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77973_b().getForgeRarity(stack).getColor() + (String)list.get(i));
                continue;
            }
            list.set(i, GuiBase.TXT_GRAY + (String)list.get(i));
        }
        RenderUtils.drawHoverText(x, y, list);
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        GENERIC;

    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }
}

