/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int MAX_TOTAL_PER_PACKET_C2S = Short.MAX_VALUE;
    public static final int MAX_PAYLOAD_PER_PACKET_C2S = 32762;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x100000;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_S2C = 0x4000000;
    private static final Map<Pair<INetHandler, ResourceLocation>, ReadingSession> READING_SESSIONS = new HashMap<Pair<INetHandler, ResourceLocation>, ReadingSession>();

    public static void send(NetHandlerPlayServer networkHandler, ResourceLocation channel, PacketBuffer packet) {
        PacketSplitter.send(packet, 1048571, (PacketBuffer buf) -> networkHandler.func_147359_a((Packet)new SPacketCustomPayload(channel.toString(), buf)));
    }

    public static void send(NetHandlerPlayClient networkHandler, ResourceLocation channel, PacketBuffer packet) {
        PacketSplitter.send(packet, 32762, (PacketBuffer buf) -> networkHandler.func_147297_a((Packet)new CPacketCustomPayload(channel.toString(), buf)));
    }

    private static void send(PacketBuffer packet, int payloadLimit, Consumer<PacketBuffer> sender) {
        int len = packet.writerIndex();
        packet.resetReaderIndex();
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer((int)thisLen));
            buf.resetWriterIndex();
            if (offset == 0) {
                buf.func_150787_b(len);
            }
            buf.writeBytes((ByteBuf)packet, thisLen);
            sender.accept(buf);
        }
        packet.release();
    }

    @Nullable
    public static PacketBuffer receive(NetHandlerPlayClient networkHandler, SPacketCustomPayload message) {
        return PacketSplitter.receive(networkHandler, message, 0x4000000);
    }

    @Nullable
    private static PacketBuffer receive(NetHandlerPlayClient networkHandler, SPacketCustomPayload message, int maxLength) {
        Pair key = Pair.of((Object)networkHandler, (Object)new ResourceLocation(message.func_149169_c()));
        return PacketSplitter.READING_SESSIONS.computeIfAbsent((Pair<INetHandler, ResourceLocation>)key, x$0 -> new ReadingSession((Pair)x$0)).receive(message.func_180735_b(), maxLength);
    }

    @Nullable
    public static PacketBuffer receive(String channelName, PacketBuffer rawData) {
        return PacketSplitter.receive(channelName, rawData, 0x4000000);
    }

    @Nullable
    private static PacketBuffer receive(String channelName, PacketBuffer rawData, int maxLength) {
        Pair key = Pair.of((Object)Minecraft.func_71410_x().func_147114_u(), (Object)new ResourceLocation(channelName));
        return PacketSplitter.READING_SESSIONS.computeIfAbsent((Pair<INetHandler, ResourceLocation>)key, x$0 -> new ReadingSession((Pair)x$0)).receive(rawData, maxLength);
    }

    private static class ReadingSession {
        private final Pair<INetHandler, ResourceLocation> key;
        private int expectedSize = -1;
        private PacketBuffer received;

        private ReadingSession(Pair<INetHandler, ResourceLocation> key) {
            this.key = key;
        }

        @Nullable
        private PacketBuffer receive(PacketBuffer data, int maxLength) {
            if (this.expectedSize < 0) {
                this.expectedSize = data.func_150792_a();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new PacketBuffer(Unpooled.buffer((int)this.expectedSize));
            }
            this.received.writeBytes(data.readBytes(data.readableBytes()));
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

