/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.hotkeys;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.IMinecraftAccessor;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.values.HudAlignment;
import fi.dy.masa.malilib.config.values.KeybindDisplayMode;
import fi.dy.masa.malilib.gui.widgets.WidgetToast;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeybindMulti
implements IKeybind {
    private static List<Integer> pressedKeys = new ArrayList<Integer>();
    private static int triggeredCount;
    private final String name;
    private final String defaultStorageString;
    private final KeybindSettings defaultSettings;
    private String modName = "";
    private List<Integer> keyCodes = new ArrayList<Integer>(4);
    private KeybindSettings settings;
    private String lastSavedStorageString;
    private KeybindSettings lastSavedSettings;
    private boolean pressed;
    private boolean pressedLast;
    private int heldTime;
    @Nullable
    private IHotkeyCallback callback;

    private KeybindMulti(String name, String defaultStorageString, KeybindSettings settings) {
        this.name = name;
        this.defaultStorageString = defaultStorageString;
        this.defaultSettings = settings;
        this.settings = settings;
        this.cacheSavedValue();
    }

    @Override
    public void setModName(String modName) {
        this.modName = modName;
    }

    @Override
    public KeybindSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(KeybindSettings settings) {
        this.settings = settings;
    }

    @Override
    public void setCallback(@Nullable IHotkeyCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean isValid() {
        return !this.keyCodes.isEmpty() || this.settings.getAllowEmpty();
    }

    @Override
    public boolean isPressed() {
        return this.pressed && !this.pressedLast && this.heldTime == 0;
    }

    @Override
    public boolean isKeybindHeld() {
        return this.pressed || this.settings.getAllowEmpty() && this.keyCodes.isEmpty();
    }

    @Override
    public boolean updateIsPressed() {
        int sizeRequired;
        if (this.keyCodes.isEmpty() || this.settings.getContext() != KeybindSettings.Context.ANY && this.settings.getContext() == KeybindSettings.Context.INGAME != (GuiUtils.getCurrentScreen() == null)) {
            this.pressed = false;
            return false;
        }
        boolean allowExtraKeys = this.settings.getAllowExtraKeys();
        boolean allowOutOfOrder = !this.settings.isOrderSensitive();
        boolean pressedLast = this.pressed;
        int sizePressed = pressedKeys.size();
        if (sizePressed >= (sizeRequired = this.keyCodes.size()) && (allowExtraKeys || sizePressed == sizeRequired)) {
            int keyCodeIndex = 0;
            this.pressed = pressedKeys.containsAll(this.keyCodes);
            for (int i = 0; i < sizePressed; ++i) {
                Integer keyCodeObj = pressedKeys.get(i);
                if (this.keyCodes.get(keyCodeIndex).equals(keyCodeObj)) {
                    if (++keyCodeIndex < sizeRequired) continue;
                } else {
                    if ((allowOutOfOrder || keyCodeIndex <= 0 && sizePressed != sizeRequired) && (this.keyCodes.contains(keyCodeObj) || allowExtraKeys)) continue;
                    this.pressed = false;
                }
                break;
            }
        } else {
            this.pressed = false;
        }
        KeyAction activateOn = this.settings.getActivateOn();
        if (!(this.pressed == pressedLast || triggeredCount != 0 && this.settings.isExclusive() || activateOn != KeyAction.BOTH && this.pressed != (activateOn == KeyAction.PRESS))) {
            boolean cancel;
            boolean bl = cancel = this.triggerKeyAction(pressedLast) && this.settings.shouldCancel();
            if (cancel) {
                ++triggeredCount;
            }
            return cancel;
        }
        return false;
    }

    private boolean triggerKeyAction(boolean pressedLast) {
        if (!this.pressed) {
            this.heldTime = 0;
            KeyAction activateOn = this.settings.getActivateOn();
            if (pressedLast && (activateOn == KeyAction.RELEASE || activateOn == KeyAction.BOTH)) {
                return this.triggerKeyCallback(KeyAction.RELEASE);
            }
        } else if (!pressedLast && this.heldTime == 0) {
            KeyAction activateOn;
            if (this.keyCodes.contains(61)) {
                ((IMinecraftAccessor)Minecraft.func_71410_x()).setActionKeyF3(true);
            }
            if ((activateOn = this.settings.getActivateOn()) == KeyAction.PRESS || activateOn == KeyAction.BOTH) {
                return this.triggerKeyCallback(KeyAction.PRESS);
            }
        }
        return false;
    }

    private boolean triggerKeyCallback(KeyAction action) {
        if (this.callback == null) {
            return this.settings.shouldCancel() && action == KeyAction.PRESS;
        }
        boolean cancel = this.callback.onKeyAction(action, this);
        KeybindDisplayMode val = (KeybindDisplayMode)MaLiLibConfigs.Generic.KEYBIND_DISPLAY.getOptionListValue();
        if (val != KeybindDisplayMode.NONE && (!MaLiLibConfigs.Generic.KEYBIND_DISPLAY_CANCEL_ONLY.getBooleanValue() || cancel && this.settings.shouldCancel())) {
            ArrayList<String> lines = new ArrayList<String>();
            if (val == KeybindDisplayMode.KEYS || val == KeybindDisplayMode.KEYS_ACTIONS) {
                lines.add(StringUtils.translate("malilib.toast.keybind_display.keys", this.getKeysDisplayString()));
            }
            if (val == KeybindDisplayMode.ACTIONS || val == KeybindDisplayMode.KEYS_ACTIONS) {
                lines.add(StringUtils.translate("malilib.toast.keybind_display.action", this.modName, this.name));
            }
            HudAlignment align = (HudAlignment)MaLiLibConfigs.Generic.KEYBIND_DISPLAY_ALIGNMENT.getOptionListValue();
            WidgetToast.updateOrAddToast(align, lines, MaLiLibConfigs.Generic.KEYBIND_DISPLAY_DURATION.getIntegerValue());
        }
        return cancel;
    }

    @Override
    public void clearKeys() {
        this.keyCodes.clear();
        this.pressed = false;
        this.heldTime = 0;
    }

    @Override
    public void addKey(int keyCode) {
        if (!this.keyCodes.contains(keyCode)) {
            this.keyCodes.add(keyCode);
        }
    }

    @Override
    public void tick() {
        if (this.pressed) {
            ++this.heldTime;
        }
        this.pressedLast = this.pressed;
    }

    @Override
    public void removeKey(int keyCode) {
        this.keyCodes.remove(keyCode);
    }

    @Override
    public List<Integer> getKeys() {
        return this.keyCodes;
    }

    @Override
    public String getKeysDisplayString() {
        return this.getStringValue().replaceAll(",", " + ");
    }

    @Override
    public boolean isModified() {
        return !this.getStringValue().equals(this.defaultStorageString);
    }

    @Override
    public boolean isModified(String newValue) {
        return !this.defaultStorageString.equals(newValue);
    }

    @Override
    public boolean isDirty() {
        return !this.lastSavedStorageString.equals(this.getStringValue()) || !this.lastSavedSettings.equals(this.settings);
    }

    @Override
    public void cacheSavedValue() {
        this.lastSavedStorageString = this.getStringValue();
        this.lastSavedSettings = this.settings;
    }

    @Override
    public void resetToDefault() {
        this.setValueFromString(this.defaultStorageString);
    }

    @Override
    public boolean areSettingsModified() {
        return !this.settings.equals(this.defaultSettings);
    }

    @Override
    public void resetSettingsToDefaults() {
        this.settings = this.defaultSettings;
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < this.keyCodes.size(); ++i) {
            int keyCode;
            String name;
            if (i > 0) {
                sb.append(",");
            }
            if ((name = KeybindMulti.getStorageStringForKeyCode(keyCode = this.keyCodes.get(i).intValue())) == null) continue;
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultStorageString;
    }

    @Override
    public void setValueFromString(String str) {
        String[] keys;
        this.clearKeys();
        for (String key : keys = str.split(",")) {
            if ((key = key.trim()).isEmpty()) continue;
            int keyCode = Keyboard.getKeyIndex((String)key);
            if (keyCode != 0) {
                this.addKey(keyCode);
                continue;
            }
            keyCode = Mouse.getButtonIndex((String)key);
            if (keyCode < 0 || keyCode >= Mouse.getButtonCount()) continue;
            this.addKey(keyCode - 100);
        }
    }

    @Override
    public boolean matches(int keyCode) {
        return this.keyCodes.size() == 1 && this.keyCodes.get(0) == keyCode;
    }

    public static boolean hotkeyMatchesKeybind(IHotkey hotkey, KeyBinding keybind) {
        return hotkey.getKeybind().matches(keybind.func_151463_i());
    }

    @Override
    public boolean overlaps(IKeybind other) {
        if (other == this || other.getKeys().size() > this.getKeys().size()) {
            return false;
        }
        if (this.contextOverlaps(other)) {
            KeybindSettings settingsOther = other.getSettings();
            boolean o1 = this.settings.isOrderSensitive();
            boolean o2 = settingsOther.isOrderSensitive();
            List<Integer> keys1 = this.getKeys();
            List<Integer> keys2 = other.getKeys();
            int l1 = keys1.size();
            int l2 = keys2.size();
            if (l1 == 0 || l2 == 0) {
                return false;
            }
            if (!this.settings.getAllowExtraKeys() && l1 < l2 && keys1.get(0) != keys2.get(0) || !settingsOther.getAllowExtraKeys() && l2 < l1 && keys1.get(0) != keys2.get(0)) {
                return false;
            }
            if (o1 && o2) {
                return l1 < l2 ? Collections.indexOfSubList(keys2, keys1) != -1 : Collections.indexOfSubList(keys1, keys2) != -1;
            }
            return l1 <= l2 ? keys2.containsAll(keys1) : keys1.containsAll(keys2);
        }
        return false;
    }

    public boolean contextOverlaps(IKeybind other) {
        KeybindSettings settingsOther = other.getSettings();
        KeybindSettings.Context c1 = this.settings.getContext();
        KeybindSettings.Context c2 = settingsOther.getContext();
        if (c1 == KeybindSettings.Context.ANY || c2 == KeybindSettings.Context.ANY || c1 == c2) {
            KeyAction a1 = this.settings.getActivateOn();
            KeyAction a2 = settingsOther.getActivateOn();
            if (a1 == KeyAction.BOTH || a2 == KeyAction.BOTH || a1 == a2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueFromJsonElement(JsonElement element, String hotkeyName) {
        try {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (JsonUtils.hasString(obj, "keys")) {
                    this.setValueFromString(obj.get("keys").getAsString());
                }
                if (JsonUtils.hasObject(obj, "settings")) {
                    this.setSettings(KeybindSettings.fromJson(obj.getAsJsonObject("settings")));
                }
            } else if (element.isJsonPrimitive()) {
                this.setValueFromString(element.getAsString());
            } else {
                MaLiLib.logger.warn("Failed to set the hotkey '{}' from the JSON element '{}'", (Object)hotkeyName, (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set the hotkey '{}' from the JSON element '{}'", (Object)hotkeyName, (Object)element, (Object)e);
        }
        this.cacheSavedValue();
    }

    @Override
    public JsonElement getAsJsonElement() {
        String str = this.getStringValue();
        JsonObject obj = new JsonObject();
        obj.add("keys", (JsonElement)new JsonPrimitive(str));
        obj.add("settings", (JsonElement)this.getSettings().toJson());
        return obj;
    }

    public static KeybindMulti fromStorageString(String name, String storageString, KeybindSettings settings) {
        KeybindMulti keybind = new KeybindMulti(name, storageString, settings);
        keybind.setValueFromString(storageString);
        return keybind;
    }

    public static boolean isKeyDown(int keyCode) {
        if (keyCode > 0) {
            return keyCode < Keyboard.getKeyCount() && Keyboard.isKeyDown((int)keyCode);
        }
        return (keyCode += 100) >= 0 && keyCode < Mouse.getButtonCount() && Mouse.isButtonDown((int)keyCode);
    }

    public static void onKeyInputPre(int keyCode, boolean state) {
        Integer valObj = keyCode;
        if (state) {
            List<Integer> ignored;
            if (!(pressedKeys.contains(valObj) || (ignored = MaLiLibConfigs.Generic.IGNORED_KEYS.getKeybind().getKeys()).size() != 0 && ignored.contains(valObj))) {
                pressedKeys.add(valObj);
            }
        } else {
            pressedKeys.remove(valObj);
        }
        if (MaLiLibConfigs.Debug.KEYBIND_DEBUG.getBooleanValue()) {
            KeybindMulti.printKeybindDebugMessage(keyCode, state);
        }
    }

    public static void reCheckPressedKeys() {
        Iterator<Integer> iter = pressedKeys.iterator();
        while (iter.hasNext()) {
            int keyCode = iter.next();
            if (KeybindMulti.isKeyDown(keyCode)) continue;
            iter.remove();
        }
        if (pressedKeys.size() == 0) {
            triggeredCount = 0;
        }
    }

    private static void printKeybindDebugMessage(int eventKey, boolean eventKeyState) {
        String keyName = eventKey > 0 ? Keyboard.getKeyName((int)eventKey) : Mouse.getButtonName((int)(eventKey + 100));
        String type = eventKeyState ? "PRESS" : "RELEASE";
        String held = KeybindMulti.getActiveKeysString();
        String msg = String.format("%s %s (%d), held keys: %s", type, keyName, eventKey, held);
        MaLiLib.logger.info(msg);
        if (MaLiLibConfigs.Debug.KEYBIND_DEBUG_ACTIONBAR.getBooleanValue()) {
            InfoUtils.printActionbarMessage(msg, new Object[0]);
        }
    }

    public static String getActiveKeysString() {
        if (!pressedKeys.isEmpty()) {
            StringBuilder sb = new StringBuilder(128);
            int i = 0;
            for (int key : pressedKeys) {
                String name;
                if (i > 0) {
                    sb.append(" + ");
                }
                if ((name = KeybindMulti.getStorageStringForKeyCode(key)) != null) {
                    sb.append(String.format("%s (%d)", name, key));
                }
                ++i;
            }
            return sb.toString();
        }
        return "<none>";
    }

    @Nullable
    public static String getStorageStringForKeyCode(int keyCode) {
        if (keyCode > 0) {
            return Keyboard.getKeyName((int)keyCode);
        }
        if (keyCode < 0 && (keyCode += 100) >= 0 && keyCode < Mouse.getButtonCount()) {
            return Mouse.getButtonName((int)keyCode);
        }
        return null;
    }

    public static int getTriggeredCount() {
        return triggeredCount;
    }
}

