/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.config.values.HudAlignment;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.ToastRenderer;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class WidgetToast
extends WidgetBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("malilib", "textures/gui/toasts.png");
    protected final List<String> text = new ArrayList<String>();
    protected long expireTime;
    protected int lifeTime;
    protected boolean active;

    public WidgetToast(int x, int y, int width, int height, List<String> text, int lifeTime) {
        super(x, y, width, height);
        this.setText(text, lifeTime);
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.expireTime;
    }

    public void setText(List<String> text, int lifeTime) {
        this.text.clear();
        this.text.addAll(text);
        this.lifeTime = lifeTime;
        this.width = StringUtils.getMaxStringRenderWidth(text) + 20;
        this.height = text.size() * (StringUtils.getFontHeight() + 2) + 12;
        this.resetLifeTime();
    }

    public void resetLifeTime() {
        this.expireTime = System.currentTimeMillis() + (long)this.lifeTime;
    }

    public void render(int x, int y) {
        if (!this.active) {
            this.resetLifeTime();
            this.active = true;
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.bindTexture(TEXTURE);
        RenderUtils.draw9SplicedTexture(x, y, 0, 0, this.width, this.height, 256, 32, 6, this.zLevel);
        RenderUtils.renderText(x + 10, y + 8, -1, this.text);
    }

    public static void updateOrAddToast(HudAlignment alignment, List<String> text, int lifeTime) {
        WidgetToast toast = ToastRenderer.INSTANCE.getToast(alignment, WidgetToast.class);
        if (toast != null) {
            toast.setText(text, lifeTime);
        } else {
            WidgetToast.addToast(alignment, text, lifeTime);
        }
    }

    public static void addToast(HudAlignment alignment, List<String> text, int lifeTime) {
        ToastRenderer.INSTANCE.addToast(alignment, new WidgetToast(0, 0, 32, 32, text, lifeTime));
    }
}

