/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetIcon;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.HorizontalAlignment;
import net.minecraft.util.ChatAllowedCharacters;

public class WidgetSearchBar
extends WidgetBase {
    protected final WidgetIcon iconSearch;
    protected final HorizontalAlignment iconAlignment;
    protected final GuiTextFieldGeneric searchBox;
    protected boolean searchOpen;

    public WidgetSearchBar(int x, int y, int width, int height, int searchBarOffsetX, IGuiIcon iconSearch, HorizontalAlignment iconAlignment) {
        super(x, y, width, height);
        int iw = iconSearch.getWidth();
        int ix = iconAlignment == HorizontalAlignment.RIGHT ? x + width - iw - 1 : x + 2;
        int tx = iconAlignment == HorizontalAlignment.RIGHT ? x - searchBarOffsetX + 1 : x + iw + 6 + searchBarOffsetX;
        this.iconSearch = new WidgetIcon(ix, y + 1, iconSearch);
        this.iconAlignment = iconAlignment;
        this.searchBox = new GuiTextFieldGeneric(tx, y, width - iw - 7 - Math.abs(searchBarOffsetX), height, this.textRenderer);
        this.searchBox.setZLevel(this.zLevel);
    }

    public String getFilter() {
        return this.searchOpen ? this.searchBox.func_146179_b() : "";
    }

    public boolean hasFilter() {
        return this.searchOpen && !this.searchBox.func_146179_b().isEmpty();
    }

    public boolean isSearchOpen() {
        return this.searchOpen;
    }

    public void setSearchOpen(boolean isOpen) {
        this.searchOpen = isOpen;
        if (this.searchOpen) {
            this.searchBox.func_146195_b(true);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.searchOpen && this.searchBox.func_146192_a(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.iconSearch.isMouseOver(mouseX, mouseY)) {
            this.setSearchOpen(!this.searchOpen);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onKeyTypedImpl(char typedChar, int keyCode) {
        if (this.searchOpen) {
            if (this.searchBox.func_146201_a(typedChar, keyCode)) {
                return true;
            }
            if (keyCode == 1) {
                if (GuiBase.isShiftDown()) {
                    GuiBase.openGui(null);
                }
                this.searchOpen = false;
                return true;
            }
        } else if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.searchOpen = true;
            this.searchBox.func_146195_b(true);
            this.searchBox.func_146180_a("");
            this.searchBox.func_146202_e();
            this.searchBox.func_146201_a(typedChar, keyCode);
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.iconSearch.render(false, this.iconSearch.isMouseOver(mouseX, mouseY));
        if (this.searchOpen) {
            this.searchBox.func_146194_f();
        }
    }
}

