/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;

public abstract class WidgetListConfigOptionsBase<TYPE, WIDGET extends WidgetConfigOptionBase<TYPE>>
extends WidgetListBase<TYPE, WIDGET> {
    protected final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
    protected boolean configsModified;
    protected int maxLabelWidth;
    protected int configWidth;

    public WidgetListConfigOptionsBase(int x, int y, int width, int height, int configWidth) {
        super(x, y, width, height, null);
        this.configWidth = configWidth;
        this.browserEntryHeight = 22;
    }

    @Override
    protected void reCreateListEntryWidgets() {
        this.applyPendingModifications();
        if (!this.configsModified) {
            this.wereConfigsModified();
        }
        this.textFields.clear();
        super.reCreateListEntryWidgets();
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.clearTextFieldFocus();
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (keyCode == 15) {
            return this.changeTextFieldFocus(GuiScreen.func_146272_n());
        }
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.onKeyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return super.onKeyTyped(typedChar, keyCode);
    }

    public void addTextField(TextFieldWrapper<? extends GuiTextFieldGeneric> wrapper) {
        this.textFields.add(wrapper);
    }

    protected boolean changeTextFieldFocus(boolean reverse) {
        int size = this.textFields.size();
        if (size > 1) {
            int currentIndex = -1;
            for (int i = 0; i < size; ++i) {
                GuiTextFieldGeneric textField = this.textFields.get(i).getTextField();
                if (!textField.func_146206_l()) continue;
                currentIndex = i;
                textField.func_146195_b(false);
                break;
            }
            if (currentIndex != -1) {
                int newIndex = currentIndex + (reverse ? -1 : 1);
                if (newIndex >= size) {
                    newIndex = 0;
                } else if (newIndex < 0) {
                    newIndex = size - 1;
                }
                this.textFields.get(newIndex).getTextField().func_146195_b(true);
                this.applyPendingModifications();
                return true;
            }
        }
        return false;
    }

    protected void clearTextFieldFocus() {
        this.applyPendingModifications();
        for (int i = 0; i < this.textFields.size(); ++i) {
            GuiTextFieldGeneric textField = this.textFields.get(i).getTextField();
            if (!textField.func_146206_l()) continue;
            textField.func_146195_b(false);
            break;
        }
    }

    public void markConfigsModified() {
        this.configsModified = true;
    }

    public boolean wereConfigsModified() {
        if (this.configsModified) {
            return true;
        }
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.wasConfigModified()) continue;
            this.configsModified = true;
            return true;
        }
        return false;
    }

    public void clearConfigsModifiedFlag() {
        this.configsModified = false;
    }

    public void applyPendingModifications() {
        for (WidgetConfigOptionBase widget : this.listWidgets) {
            if (!widget.hasPendingModifications()) continue;
            widget.applyNewValueToConfig();
            this.configsModified = true;
        }
    }
}

