/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.config.options.IConfigResettable;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.listener.ConfigOptionChangeListenerTextField;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;

public abstract class WidgetConfigOptionBase<TYPE>
extends WidgetListEntryBase<TYPE> {
    protected final WidgetListConfigOptionsBase<?, ?> parent;
    @Nullable
    protected TextFieldWrapper<? extends GuiTextFieldGeneric> textField = null;
    @Nullable
    protected String initialStringValue;
    protected int maxTextfieldTextLength = 256;
    protected String lastAppliedValue;

    public WidgetConfigOptionBase(int x, int y, int width, int height, WidgetListConfigOptionsBase<?, ?> parent, TYPE entry, int listIndex) {
        super(x, y, width, height, entry, listIndex);
        this.parent = parent;
    }

    public abstract boolean wasConfigModified();

    public boolean hasPendingModifications() {
        if (this.textField != null) {
            return !this.textField.getTextField().func_146179_b().equals(this.lastAppliedValue);
        }
        return false;
    }

    public abstract void applyNewValueToConfig();

    protected GuiTextFieldGeneric createTextField(int x, int y, int width, int height) {
        return new GuiTextFieldGeneric(x + 2, y, width, height, this.textRenderer);
    }

    protected void addTextField(GuiTextFieldGeneric field, ConfigOptionChangeListenerTextField listener) {
        TextFieldWrapper<GuiTextFieldGeneric> wrapper = new TextFieldWrapper<GuiTextFieldGeneric>(field, listener);
        this.textField = wrapper;
        this.parent.addTextField(wrapper);
    }

    protected ButtonGeneric createResetButton(int x, int y, IConfigResettable config) {
        String labelReset = StringUtils.translate("malilib.gui.button.reset.caps", new Object[0]);
        ButtonGeneric resetButton = new ButtonGeneric(x, y, -1, 20, labelReset, new String[0]);
        resetButton.setEnabled(config.isModified());
        return resetButton;
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        boolean ret = false;
        if (this.textField != null) {
            ret |= this.textField.getTextField().func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                ret |= widget.isMouseOver(mouseX, mouseY) && widget.onMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        return ret;
    }

    @Override
    public boolean onKeyTypedImpl(char typedChar, int keyCode) {
        if (this.textField != null && this.textField.isFocused()) {
            if (keyCode == 28) {
                this.applyNewValueToConfig();
                return true;
            }
            return this.textField.keyTyped(typedChar, keyCode);
        }
        return false;
    }

    @Override
    public boolean canSelectAt(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    protected void drawTextFields(int mouseX, int mouseY) {
        if (this.textField != null) {
            this.textField.getTextField().func_146194_f();
        }
    }
}

