/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;

public abstract class GuiTextInputBase
extends GuiDialogBase {
    protected final GuiTextField textField;
    protected final String originalText;

    public GuiTextInputBase(int maxTextLength, String titleKey, String defaultText, @Nullable GuiScreen parent) {
        this.setParent(parent);
        this.title = StringUtils.translate(titleKey, new Object[0]);
        this.useTitleHierarchy = false;
        this.originalText = defaultText;
        this.setWidthAndHeight(260, 100);
        this.centerOnScreen();
        int width = Math.min(maxTextLength * 10, 240);
        this.textField = new GuiTextFieldGeneric(this.dialogLeft + 12, this.dialogTop + 40, width, 20, this.textRenderer);
        this.textField.func_146203_f(maxTextLength);
        this.textField.func_146195_b(true);
        this.textField.func_146180_a(this.originalText);
        this.textField.func_146202_e();
        this.field_73735_i = 1.0f;
    }

    @Override
    public void func_73866_w_() {
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + 70;
        x += this.createButton(x, y, ButtonType.OK) + 2;
        x += this.createButton(x, y, ButtonType.RESET) + 2;
        x += this.createButton(x, y, ButtonType.CANCEL) + 2;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, type.getDisplayName(), new String[0]);
        button.setWidth(Math.max(40, button.getWidth()));
        return this.addButton(button, this.createActionListener(type)).getWidth();
    }

    @Override
    public boolean func_73868_f() {
        return this.getParent() != null && this.getParent().func_73868_f();
    }

    @Override
    public void drawContents(int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().func_73863_a(mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.field_73735_i);
        RenderUtils.drawOutlinedBox(this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -536870912, -6710887);
        this.drawStringWithShadow(this.getTitle(), this.dialogLeft + 10, this.dialogTop + 4, -1);
        this.textField.func_146194_f();
        this.drawButtons(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (keyCode == 28) {
            if (this.applyValue(this.textField.func_146179_b())) {
                GuiBase.openGui(this.getParent());
            }
            return true;
        }
        if (keyCode == 1) {
            GuiBase.openGui(this.getParent());
            return true;
        }
        if (this.textField.func_146206_l()) {
            return this.textField.func_146201_a(typedChar, keyCode);
        }
        return super.onKeyTyped(typedChar, keyCode);
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int button) {
        if (this.textField.func_146192_a(mouseX, mouseY, button)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected abstract boolean applyValue(String var1);

    protected static enum ButtonType {
        OK("malilib.gui.button.ok"),
        CANCEL("malilib.gui.button.cancel"),
        RESET("malilib.gui.button.reset");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected static class ButtonListener
    implements IButtonActionListener {
        private final GuiTextInputBase gui;
        private final ButtonType type;

        public ButtonListener(ButtonType type, GuiTextInputBase gui) {
            this.type = type;
            this.gui = gui;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.OK) {
                if (this.gui.applyValue(this.gui.textField.func_146179_b())) {
                    GuiBase.openGui(this.gui.getParent());
                }
            } else if (this.type == ButtonType.CANCEL) {
                GuiBase.openGui(this.gui.getParent());
            } else if (this.type == ButtonType.RESET) {
                this.gui.textField.func_146180_a(this.gui.originalText);
                this.gui.textField.func_146190_e(0);
                this.gui.textField.func_146195_b(true);
            }
        }
    }
}

