/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.options.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends GuiScreen
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = TextFormatting.AQUA.toString();
    public static final String TXT_BLACK = TextFormatting.BLACK.toString();
    public static final String TXT_BLUE = TextFormatting.BLUE.toString();
    public static final String TXT_GOLD = TextFormatting.GOLD.toString();
    public static final String TXT_GRAY = TextFormatting.GRAY.toString();
    public static final String TXT_GREEN = TextFormatting.GREEN.toString();
    public static final String TXT_RED = TextFormatting.RED.toString();
    public static final String TXT_WHITE = TextFormatting.WHITE.toString();
    public static final String TXT_YELLOW = TextFormatting.YELLOW.toString();
    public static final String TXT_BOLD = TextFormatting.BOLD.toString();
    public static final String TXT_ITALIC = TextFormatting.ITALIC.toString();
    public static final String TXT_RST = TextFormatting.RESET.toString();
    public static final String TXT_STRIKETHROUGH = TextFormatting.STRIKETHROUGH.toString();
    public static final String TXT_UNDERLINE = TextFormatting.UNDERLINE.toString();
    public static final String TXT_DARK_AQUA = TextFormatting.DARK_AQUA.toString();
    public static final String TXT_DARK_BLUE = TextFormatting.DARK_BLUE.toString();
    public static final String TXT_DARK_GRAY = TextFormatting.DARK_GRAY.toString();
    public static final String TXT_DARK_GREEN = TextFormatting.DARK_GREEN.toString();
    public static final String TXT_DARK_PURPLE = TextFormatting.DARK_PURPLE.toString();
    public static final String TXT_DARK_RED = TextFormatting.DARK_RED.toString();
    public static final String TXT_LIGHT_PURPLE = TextFormatting.LIGHT_PURPLE.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final Minecraft field_146297_k = Minecraft.func_71410_x();
    public final FontRenderer textRenderer;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final MessageRenderer messageRenderer;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    @Nullable
    private GuiScreen parent;

    public GuiBase() {
        this.textRenderer = this.field_146297_k.field_71466_p;
        this.fontHeight = this.textRenderer.field_78288_b;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable GuiScreen parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public GuiScreen getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitle() + " => " + this.title : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY);
        this.drawTitle(mouseX, mouseY, partialTicks);
        this.drawWidgets(mouseX, mouseY);
        this.drawTextFields();
        this.drawButtons(mouseX, mouseY, partialTicks);
        this.drawContents(mouseX, mouseY, partialTicks);
        this.drawButtonHoverTexts(mouseX, mouseY, partialTicks);
        this.drawHoveredWidget(mouseX, mouseY);
        this.drawGuiMessages();
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseWheelDelta = Mouse.getEventDWheel();
        if (mouseWheelDelta == 0 || !this.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) {
            super.func_146274_d();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.onMouseClicked(mouseX, mouseY, mouseButton)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (!this.onMouseReleased(mouseX, mouseY, mouseButton)) {
            super.func_146286_b(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.onKeyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        return handled;
    }

    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double mouseWheelDelta) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        for (WidgetBase widget : this.widgets) {
            if (!widget.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        boolean handled = false;
        int selected = -1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> entry = this.textFields.get(i);
            if (!entry.isFocused()) continue;
            if (keyCode == 15) {
                entry.setFocused(false);
                selected = i;
            } else {
                entry.keyTyped(typedChar, keyCode);
            }
            handled = keyCode != 1;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(typedChar, keyCode)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && keyCode == 1) {
            this.closeGui(!GuiBase.isShiftDown());
            return true;
        }
        if (selected >= 0) {
            selected = GuiBase.isShiftDown() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages() {
        this.messageRenderer.drawMessages(this.field_146294_l / 2, this.field_146295_m / 2);
    }

    public void bindTexture(ResourceLocation texture) {
        this.field_146297_k.func_110434_K().func_110577_a(texture);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(StringUtils.translate(line, new Object[0])));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.clearWidgets();
        this.clearButtons();
        this.clearTextFields();
    }

    protected void clearWidgets() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
        GuiBase.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1342177280);
    }

    protected void drawTitle(int mouseX, int mouseY, float partialTicks) {
        this.drawString(this.getTitle(), 20, 10, -1);
    }

    protected void drawContents(int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            button.render(mouseX, mouseY, button.isMouseOver());
        }
    }

    protected void drawTextFields() {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw();
        }
    }

    protected void drawWidgets(int mouseX, int mouseY) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(mouseX, mouseY, false);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(mouseX, mouseY, button.getHoverStrings());
        }
        RenderUtils.disableItemLighting();
    }

    protected void drawHoveredWidget(int mouseX, int mouseY) {
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(mouseX, mouseY, false);
            RenderUtils.disableItemLighting();
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.func_78256_a(text);
    }

    public void drawString(String text, int x, int y, int color) {
        this.textRenderer.func_78276_b(text, x, y, color);
    }

    public void drawStringWithShadow(String text, int x, int y, int color) {
        this.textRenderer.func_175063_a(text, (float)x, (float)y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getPrettyName()));
        }
        return width;
    }

    public static void openGui(GuiScreen gui) {
        Minecraft.func_71410_x().func_147108_a(gui);
    }

    public static boolean isShiftDown() {
        return GuiBase.func_146272_n();
    }

    public static boolean isCtrlDown() {
        return GuiBase.func_146271_m();
    }

    public static boolean isAltDown() {
        return GuiBase.func_175283_s();
    }
}

