/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.event.IWorldLoadManager;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;

public class WorldLoadHandler
implements IWorldLoadManager {
    private static final WorldLoadHandler INSTANCE = new WorldLoadHandler();
    private final List<IWorldLoadListener> worldLoadPreHandlers = new ArrayList<IWorldLoadListener>();
    private final List<IWorldLoadListener> worldLoadPostHandlers = new ArrayList<IWorldLoadListener>();

    public static IWorldLoadManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerWorldLoadPreHandler(IWorldLoadListener listener) {
        if (!this.worldLoadPreHandlers.contains(listener)) {
            this.worldLoadPreHandlers.add(listener);
        }
    }

    @Override
    public void unregisterWorldLoadPreHandler(IWorldLoadListener listener) {
        this.worldLoadPreHandlers.remove(listener);
    }

    @Override
    public void registerWorldLoadPostHandler(IWorldLoadListener listener) {
        if (!this.worldLoadPostHandlers.contains(listener)) {
            this.worldLoadPostHandlers.add(listener);
        }
    }

    @Override
    public void unregisterWorldLoadPostHandler(IWorldLoadListener listener) {
        this.worldLoadPostHandlers.remove(listener);
    }

    public void onWorldLoadPre(@Nullable WorldClient worldBefore, @Nullable WorldClient worldAfter, Minecraft mc) {
        if (!this.worldLoadPreHandlers.isEmpty()) {
            for (IWorldLoadListener listener : this.worldLoadPreHandlers) {
                listener.onWorldLoadPre(worldBefore, worldAfter, mc);
            }
        }
    }

    public void onWorldLoadPost(@Nullable WorldClient worldBefore, @Nullable WorldClient worldAfter, Minecraft mc) {
        if (worldAfter == null) {
            ((ConfigManager)ConfigManager.getInstance()).saveAllConfigs();
        } else if (worldBefore == null) {
            ((ConfigManager)ConfigManager.getInstance()).loadAllConfigs();
            InputEventHandler.getKeybindManager().updateUsedKeys();
        }
        if (!this.worldLoadPostHandlers.isEmpty()) {
            for (IWorldLoadListener listener : this.worldLoadPostHandlers) {
                listener.onWorldLoadPost(worldBefore, worldAfter, mc);
            }
        }
    }
}

