/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IInputManager;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputEventHandler
implements IKeybindManager,
IInputManager {
    private static final InputEventHandler INSTANCE = new InputEventHandler();
    private final Multimap<Integer, IKeybind> hotkeyMap = ArrayListMultimap.create();
    private final List<KeybindCategory> allKeybinds = new ArrayList<KeybindCategory>();
    private final IntOpenHashSet modifierKeys = new IntOpenHashSet();
    private final List<IKeybindProvider> keybindProviders = new ArrayList<IKeybindProvider>();
    private final List<IKeyboardInputHandler> keyboardHandlers = new ArrayList<IKeyboardInputHandler>();
    private final List<IMouseInputHandler> mouseHandlers = new ArrayList<IMouseInputHandler>();

    private InputEventHandler() {
        this.modifierKeys.add(42);
        this.modifierKeys.add(54);
        this.modifierKeys.add(29);
        this.modifierKeys.add(157);
        this.modifierKeys.add(56);
        this.modifierKeys.add(184);
    }

    public static IKeybindManager getKeybindManager() {
        return INSTANCE;
    }

    public static IInputManager getInputManager() {
        return INSTANCE;
    }

    @Override
    public void registerKeybindProvider(IKeybindProvider provider) {
        if (!this.keybindProviders.contains(provider)) {
            this.keybindProviders.add(provider);
        }
        for (KeybindCategory category : provider.getHotkeyCategoriesForCombinedView()) {
            this.addHotkeysForCategory(category);
        }
    }

    @Override
    public void unregisterKeybindProvider(IKeybindProvider provider) {
        this.keybindProviders.remove(provider);
    }

    @Override
    public List<KeybindCategory> getKeybindCategories() {
        return this.allKeybinds;
    }

    @Override
    public void updateUsedKeys() {
        this.hotkeyMap.clear();
        for (IKeybindProvider handler : this.keybindProviders) {
            for (IHotkey iHotkey : handler.getAllHotkeys()) {
                this.addKeybindToMap(iHotkey.getKeybind());
            }
        }
    }

    private void addKeybindToMap(IKeybind keybind) {
        List<Integer> keys = keybind.getKeys();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.hotkeyMap.put((Object)key, (Object)keybind);
        }
    }

    private void addHotkeysForCategory(KeybindCategory category) {
        this.allKeybinds.remove(category);
        this.allKeybinds.add(category);
    }

    @Override
    public void registerKeyboardInputHandler(IKeyboardInputHandler handler) {
        if (!this.keyboardHandlers.contains(handler)) {
            this.keyboardHandlers.add(handler);
        }
    }

    @Override
    public void unregisterKeyboardInputHandler(IKeyboardInputHandler handler) {
        this.keyboardHandlers.remove(handler);
    }

    @Override
    public void registerMouseInputHandler(IMouseInputHandler handler) {
        if (!this.mouseHandlers.contains(handler)) {
            this.mouseHandlers.add(handler);
        }
    }

    @Override
    public void unregisterMouseInputHandler(IMouseInputHandler handler) {
        this.mouseHandlers.remove(handler);
    }

    public boolean onKeyInput() {
        int eventKey = Keyboard.getEventKey();
        boolean eventKeyState = Keyboard.getEventKeyState();
        KeybindMulti.onKeyInputPre(eventKey, eventKeyState);
        boolean cancel = this.checkKeyBindsForChanges(eventKey);
        if (!this.keyboardHandlers.isEmpty()) {
            for (IKeyboardInputHandler handler : this.keyboardHandlers) {
                if (!handler.onKeyInput(eventKey, eventKeyState)) continue;
                return true;
            }
        }
        return !this.isModifierKey(eventKey) && cancel;
    }

    public boolean onMouseInput() {
        boolean cancel;
        block5: {
            block4: {
                int eventButton = Mouse.getEventButton();
                int dWheel = Mouse.getEventDWheel();
                boolean eventButtonState = Mouse.getEventButtonState();
                cancel = false;
                if (eventButton == -1 && dWheel == 0) break block4;
                if (eventButton != -1) {
                    KeybindMulti.onKeyInputPre(eventButton - 100, eventButtonState);
                    cancel = this.checkKeyBindsForChanges(eventButton - 100);
                }
                if (this.mouseHandlers.isEmpty()) break block5;
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseInput(eventButton, dWheel, eventButtonState)) continue;
                    return true;
                }
                break block5;
            }
            if (!this.mouseHandlers.isEmpty()) {
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    handler.onMouseMoved();
                }
            }
        }
        return cancel;
    }

    private boolean isModifierKey(int eventKey) {
        return this.modifierKeys.contains(eventKey);
    }

    private boolean checkKeyBindsForChanges(int eventKey) {
        boolean cancel = false;
        Collection keybinds = this.hotkeyMap.get((Object)eventKey);
        if (!keybinds.isEmpty()) {
            for (IKeybind keybind : keybinds) {
                cancel |= keybind.updateIsPressed();
            }
        }
        return cancel;
    }
}

