/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.values;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ConfigOptionListEntryBase<T extends ConfigOptionListEntryBase<T>>
implements IConfigOptionListEntry {
    protected final List<T> values = new ArrayList<T>();
    protected final String configString;
    protected final String translationKey;
    protected int index;

    public ConfigOptionListEntryBase(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
        this.index = -1;
    }

    public void init(List<T> values) {
        this.values.clear();
        for (int i = 0; i < values.size(); ++i) {
            ConfigOptionListEntryBase entry = (ConfigOptionListEntryBase)values.get(i);
            this.values.add(entry);
            if (entry != this) continue;
            this.index = i;
        }
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public T cycle(boolean forward) {
        int index = this.index;
        int size = this.values.size();
        if (index < 0) {
            throw new RuntimeException(String.format("Entry %s (%s) not found on list of all values (size: %d)!", this.getDisplayName(), this.getStringValue(), this.values.size()));
        }
        if (forward) {
            if (++index >= size) {
                index = 0;
            }
        } else if (--index < 0) {
            index = size - 1;
        }
        return (T)((ConfigOptionListEntryBase)this.values.get(index % size));
    }

    public T fromString(String name) {
        return ConfigOptionListEntryBase.fromStringStatic(this.values, name);
    }

    public List<T> getValues() {
        return this.values;
    }

    public static <T extends ConfigOptionListEntryBase<T>> T fromStringStatic(List<T> values, String name) {
        for (ConfigOptionListEntryBase val : values) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return (T)val;
        }
        return (T)((ConfigOptionListEntryBase)values.get(0));
    }

    public static <T extends ConfigOptionListEntryBase<T>> void initValues(List<T> values) {
        for (ConfigOptionListEntryBase val : values) {
            val.init(values);
        }
    }
}

