/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.values;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum ActiveMode implements IConfigOptionListEntry
{
    NEVER("never", "malilib.label.active_mode.never"),
    WITH_KEY("with_key", "malilib.label.active_mode.with_key"),
    ALWAYS("always", "malilib.label.active_mode.always");

    private final String configString;
    private final String translationKey;

    private ActiveMode(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= ActiveMode.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = ActiveMode.values().length - 1;
        }
        return ActiveMode.values()[id % ActiveMode.values().length];
    }

    @Override
    public ActiveMode fromString(String name) {
        return ActiveMode.fromStringStatic(name);
    }

    public static ActiveMode fromStringStatic(String name) {
        for (ActiveMode mode : ActiveMode.values()) {
            if (!mode.configString.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return NEVER;
    }
}

