/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.IConfigOptionList;
import fi.dy.masa.malilib.config.options.IStringRepresentable;

public class ConfigOptionList
extends ConfigBase<ConfigOptionList>
implements IConfigOptionList,
IStringRepresentable {
    private final IConfigOptionListEntry defaultValue;
    private IConfigOptionListEntry value;
    private IConfigOptionListEntry lastSavedValue;

    public ConfigOptionList(String name, IConfigOptionListEntry defaultValue, String comment) {
        this(name, defaultValue, comment, name);
    }

    public ConfigOptionList(String name, IConfigOptionListEntry defaultValue, String comment, String prettyName) {
        super(ConfigType.OPTION_LIST, name, comment, prettyName);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.cacheSavedValue();
    }

    @Override
    public IConfigOptionListEntry getOptionListValue() {
        return this.value;
    }

    @Override
    public IConfigOptionListEntry getDefaultOptionListValue() {
        return this.defaultValue;
    }

    @Override
    public void setOptionListValue(IConfigOptionListEntry value) {
        IConfigOptionListEntry oldValue = this.value;
        this.value = value;
        if (oldValue != this.value) {
            this.onValueChanged();
        }
    }

    @Override
    public boolean isModified() {
        return this.value != this.defaultValue;
    }

    @Override
    public boolean isModified(String newValue) {
        try {
            return this.value.fromString(newValue) != this.defaultValue;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.lastSavedValue != this.value;
    }

    @Override
    public void cacheSavedValue() {
        this.lastSavedValue = this.value;
    }

    @Override
    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public String getStringValue() {
        return this.value.getStringValue();
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultValue.getStringValue();
    }

    @Override
    public void setValueFromString(String value) {
        this.value = this.value.fromString(value);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element, String configName) {
        try {
            if (element.isJsonPrimitive()) {
                this.setValueFromString(element.getAsString());
            } else {
                MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)configName, (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)configName, (Object)element, (Object)e);
        }
        this.cacheSavedValue();
    }

    @Override
    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(this.getStringValue());
    }
}

