/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.options.IConfigBase;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.List;
import java.util.Map;

public interface IConfigHandler {
    default public File getConfigDirectory() {
        return FileUtils.getConfigDirectory();
    }

    public String getModName();

    public String getConfigFileName();

    public Map<String, List<? extends IConfigBase>> getConfigsPerCategories();

    default public boolean shouldShowCategoryOnConfigGuis(String category) {
        return true;
    }

    default public boolean shouldSaveCategoryToFile(String category) {
        return true;
    }

    default public boolean areConfigsDirty() {
        for (List<? extends IConfigBase> list : this.getConfigsPerCategories().values()) {
            for (IConfigBase iConfigBase : list) {
                if (!iConfigBase.isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    default public void onConfigsChanged() {
        this.saveIfDirty();
    }

    default public void load() {
        JsonElement element;
        File configFile = new File(this.getConfigDirectory(), this.getConfigFileName());
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile(configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            for (Map.Entry<String, List<? extends IConfigBase>> entry : this.getConfigsPerCategories().entrySet()) {
                ConfigUtils.readConfigBase(root, entry.getKey(), entry.getValue());
            }
        }
        this.onPostLoad();
    }

    default public void onPostLoad() {
    }

    default public void save() {
        File dir = this.getConfigDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            MaLiLib.logger.error("Failed to create config directory '{}'", (Object)dir.getName());
        }
        if (dir.exists() && dir.isDirectory()) {
            JsonObject root = new JsonObject();
            for (Map.Entry<String, List<? extends IConfigBase>> entry : this.getConfigsPerCategories().entrySet()) {
                ConfigUtils.writeConfigBase(root, entry.getKey(), entry.getValue());
            }
            JsonUtils.writeJsonToFile((JsonElement)root, new File(dir, this.getConfigFileName()));
        }
    }

    default public void saveIfDirty() {
        if (this.areConfigsDirty()) {
            this.save();
        }
    }
}

