/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.options.ConfigTypeWrapper;
import fi.dy.masa.malilib.config.options.IConfigBase;
import fi.dy.masa.malilib.config.options.IConfigValue;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;

public class ConfigUtils {
    public static void readConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, false);
        if (obj != null) {
            for (IConfigBase iConfigBase : options) {
                String name = iConfigBase.getName();
                if (!obj.has(name)) continue;
                iConfigBase.setValueFromJsonElement(obj.get(name), name);
            }
        }
    }

    public static void readHotkeys(JsonObject root, String keyHotkey, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, keyHotkey, false);
        if (objHotkeys != null) {
            for (IHotkey iHotkey : hotkeys) {
                String name = iHotkey.getName();
                if (!objHotkeys.has(name)) continue;
                iHotkey.getKeybind().setValueFromJsonElement(objHotkeys.get(name), name);
            }
        }
    }

    public static void writeConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, true);
        for (IConfigBase iConfigBase : options) {
            obj.add(iConfigBase.getName(), iConfigBase.getAsJsonElement());
            iConfigBase.cacheSavedValue();
        }
    }

    public static void writeHotkeys(JsonObject root, String keyHotkey, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, keyHotkey, true);
        for (IHotkey iHotkey : hotkeys) {
            objHotkeys.add(iHotkey.getName(), iHotkey.getKeybind().getAsJsonElement());
        }
    }

    public static List<ConfigTypeWrapper> createConfigWrapperForType(ConfigType wrappedType, List<? extends IConfigValue> toWrap) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < toWrap.size(); ++i) {
            builder.add((Object)new ConfigTypeWrapper(wrappedType, toWrap.get(i)));
        }
        return builder.build();
    }
}

