/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ConfigManager
implements IConfigManager {
    private static final ConfigManager INSTANCE = new ConfigManager();
    private final Map<String, IConfigHandler> configHandlers = new HashMap<String, IConfigHandler>();

    public static IConfigManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerConfigHandler(String modId, IConfigHandler handler) {
        String modName = handler.getModName();
        handler.getConfigsPerCategories().values().forEach(list -> list.forEach(config -> config.setModName(modName)));
        this.configHandlers.put(modId, handler);
    }

    @Override
    @Nullable
    public IConfigHandler getConfigHandler(String modId) {
        return this.configHandlers.get(modId);
    }

    @Override
    public void onConfigsChanged(String modId) {
        IConfigHandler handler = this.configHandlers.get(modId);
        if (handler != null) {
            handler.onConfigsChanged();
        }
    }

    public void loadAllConfigs() {
        for (IConfigHandler handler : this.configHandlers.values()) {
            handler.load();
        }
    }

    public void saveAllConfigs() {
        for (IConfigHandler handler : this.configHandlers.values()) {
            handler.saveIfDirty();
        }
    }
}

