/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.gui.GuiModConfigs;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import java.util.List;

public class ConfigPanelAllHotkeys
extends GuiModConfigs {
    public ConfigPanelAllHotkeys() {
        super("malilib", ConfigPanelAllHotkeys.createWrappers(), false, "malilib.gui.title.all_hotkeys", new Object[0]);
        this.setHoverInfoProvider(new HoverInfoProvider(this));
    }

    public static List<GuiConfigsBase.ConfigOptionWrapper> createWrappers() {
        List<KeybindCategory> categories = InputEventHandler.getKeybindManager().getKeybindCategories();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean first = true;
        for (KeybindCategory category : categories) {
            String header = category.getModName() + " - " + category.getCategory();
            if (!first) {
                builder.add((Object)new GuiConfigsBase.ConfigOptionWrapper(""));
            }
            builder.add((Object)new GuiConfigsBase.ConfigOptionWrapper(header));
            builder.add((Object)new GuiConfigsBase.ConfigOptionWrapper("-------------------------------------------------------------------"));
            first = false;
            for (IHotkey iHotkey : category.getHotkeys()) {
                String prefix = GuiBase.TXT_YELLOW + category.getModName() + " -> " + category.getCategory() + " -> " + iHotkey.getName() + "\n";
                builder.add((Object)new GuiConfigsBase.ConfigOptionWrapper(prefix, iHotkey));
            }
        }
        return builder.build();
    }

    @Override
    protected void onSettingsChanged() {
        ((ConfigManager)ConfigManager.getInstance()).saveAllConfigs();
        InputEventHandler.getKeybindManager().updateUsedKeys();
    }

    @Override
    protected boolean useKeybindSearch() {
        return true;
    }

    public static class HoverInfoProvider
    implements IConfigInfoProvider {
        protected final GuiListBase<?, ?, ?> gui;

        public HoverInfoProvider(GuiListBase<?, ?, ?> gui) {
            this.gui = gui;
        }

        @Override
        public String getHoverInfo(GuiConfigsBase.ConfigOptionWrapper wrapper) {
            String prefix;
            String comment = wrapper.getConfig().getComment();
            if (this.gui.isSearchOpen() && (prefix = wrapper.getLabelPrefix()) != null) {
                return prefix + comment;
            }
            return comment;
        }
    }
}

