/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.GlassesInstance;
import com.bymarcin.openglasses.utils.OpenGlassesHostClient;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GlassesInitSequence {
    static ArrayList<String> initSequenceLines = new ArrayList();
    static int initSequenceChars = 0;

    static boolean renderInitSequence(ItemStack glasses) {
        if (glasses.func_190926_b()) {
            return false;
        }
        long wornTicks = OCClientSurface.instance().wornTicks;
        if (OCClientSurface.glasses.energyStored == 0.0 || wornTicks > (long)(initSequenceChars + 80)) {
            return false;
        }
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        int i = 0;
        int charsPrinted = 0;
        for (String line : initSequenceLines) {
            if (wornTicks < (long)(charsPrinted + line.length())) {
                int chars = (int)wornTicks - charsPrinted;
                fontRenderer.func_78276_b(line.substring(0, chars) + " #", 10, ++i * 10, -855638017);
                break;
            }
            fontRenderer.func_78276_b(line, 10, ++i * 10, -855638017);
            charsPrinted += line.length();
        }
        GlStateManager.func_179121_F();
        return true;
    }

    static void initialize() {
        initSequenceLines.clear();
        initSequenceChars = 0;
        initSequenceLines.add("");
        initSequenceLines.add("# initializing upgrades");
        for (UpgradeItem upgrade : OpenGlassesItem.upgrades) {
            initSequenceLines.addAll(upgrade.getTooltip(OCClientSurface.glasses.get()));
        }
        initSequenceLines.add("");
        NBTTagCompound tag = OCClientSurface.glasses.get().func_77978_p();
        int energyUsage = tag.func_74762_e("upkeepCost");
        IEnergyStorage storage = (IEnergyStorage)OCClientSurface.glasses.get().getCapability(CapabilityEnergy.ENERGY, null);
        initSequenceLines.add("# Energy Buffer");
        initSequenceLines.add(String.format("%s/%s FE", storage.getEnergyStored(), storage.getMaxEnergyStored()));
        initSequenceLines.add("usage " + energyUsage + " FE/tick");
        initSequenceLines.add("");
        initSequenceLines.add("# initializing " + OCClientSurface.glasses.getHosts().size() + " hosts");
        for (GlassesInstance.HostClient host : OCClientSurface.glasses.getHosts().values()) {
            OpenGlassesHostClient hc = OCClientSurface.instance().getHost(host.uuid);
            if (hc.terminalName.length() > 0) {
                initSequenceLines.add(":: " + hc.terminalName);
            }
            initSequenceLines.add(":: uuid " + host.uuid.toString());
            initSequenceLines.add(":: type: " + (Object)((Object)hc.hostType));
        }
        for (String line : initSequenceLines) {
            initSequenceChars += line.length();
        }
    }
}

