/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.network.Utils;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class Packet<T extends Packet<T, RES>, RES extends IMessage>
implements IMessage,
IMessageHandler<T, RES> {
    protected final ByteBuf write;
    protected ByteBuf read;
    private final Gson gson = new Gson();

    protected abstract void read() throws IOException;

    protected abstract void write() throws IOException;

    protected abstract RES executeOnClient();

    protected abstract RES executeOnServer(EntityPlayerMP var1);

    public Packet() {
        this.write = Unpooled.buffer();
    }

    public TileEntity readClientTileEntity() throws IOException {
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        return Utils.getTileEntity(dimensionId, new BlockPos(x, y, z));
    }

    public TileEntity readServerTileEntity() throws IOException {
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimensionId);
        return world != null ? world.func_175625_s(new BlockPos(x, y, z)) : null;
    }

    public byte[] readByteArray() throws IOException {
        return this.readByteArrayData(this.read.readUnsignedShort());
    }

    public byte[] readByteArrayData(int size) throws IOException {
        byte[] data = new byte[size];
        this.read.readBytes(data, 0, size);
        return data;
    }

    public Object readJSON(Type t) throws IOException {
        return this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public <U> U readJSON(Class<U> t) throws IOException {
        return (U)this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public byte readByte() throws IOException {
        return this.read.readByte();
    }

    public short readShort() throws IOException {
        return this.read.readShort();
    }

    public byte readSignedByte() throws IOException {
        return this.read.readByte();
    }

    public short readSignedShort() throws IOException {
        return this.read.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.read.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.read.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.read.readInt();
    }

    public long readLong() throws IOException {
        return this.read.readLong();
    }

    public double readDouble() throws IOException {
        return this.read.readDouble();
    }

    public float readFloat() throws IOException {
        return this.read.readFloat();
    }

    public String readString() throws IOException {
        return ByteBufUtils.readUTF8String((ByteBuf)this.read);
    }

    public boolean readBoolean() throws IOException {
        return this.read.readBoolean();
    }

    public UUID readUUID() throws IOException {
        return new UUID(this.read.readLong(), this.read.readLong());
    }

    public NBTTagCompound readNBT() throws IOException {
        return ByteBufUtils.readTag((ByteBuf)this.read);
    }

    public Vec3d readVec3d() throws IOException {
        return new Vec3d(this.readDouble(), this.readDouble(), this.readDouble());
    }

    public Vec3i readVec3i() throws IOException {
        return new Vec3i(this.readInt(), this.readInt(), this.readInt());
    }

    public Packet<T, RES> writeVec3d(Vec3d vector) throws IOException, RuntimeException {
        this.write.writeDouble(vector.field_72450_a);
        this.write.writeDouble(vector.field_72448_b);
        this.write.writeDouble(vector.field_72449_c);
        return this;
    }

    public Packet<T, RES> writeVec3i(Vec3i vector) throws IOException, RuntimeException {
        this.write.writeInt(vector.func_177958_n());
        this.write.writeInt(vector.func_177956_o());
        this.write.writeInt(vector.func_177952_p());
        return this;
    }

    public Packet<T, RES> writeNBT(NBTTagCompound tag) throws IOException, RuntimeException {
        ByteBufUtils.writeTag((ByteBuf)this.write, (NBTTagCompound)tag);
        return this;
    }

    public Packet<T, RES> writeUUID(UUID uuid) throws IOException, RuntimeException {
        this.write.writeLong(uuid.getMostSignificantBits());
        this.write.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    public Packet<T, RES> writeTileLocation(TileEntity te) throws IOException, RuntimeException {
        if (te.func_145831_w() == null) {
            throw new RuntimeException("World does not exist!");
        }
        if (te.func_145837_r()) {
            throw new RuntimeException("TileEntity is invalid!");
        }
        this.write.writeInt(te.func_145831_w().field_73011_w.getDimension());
        this.write.writeInt(te.func_174877_v().func_177958_n());
        this.write.writeInt(te.func_174877_v().func_177956_o());
        this.write.writeInt(te.func_174877_v().func_177952_p());
        return this;
    }

    public Packet<T, RES> writeByteArray(byte[] array) throws IOException, RuntimeException {
        if (array.length > 65535) {
            throw new RuntimeException("Invalid array size!");
        }
        this.write.writeShort(array.length);
        this.write.writeBytes(array);
        return this;
    }

    public Packet<T, RES> writeByteArrayData(byte[] array) throws IOException {
        this.write.writeBytes(array);
        return this;
    }

    public Packet<T, RES> writeByte(byte v) throws IOException {
        this.write.writeByte((int)v);
        return this;
    }

    public Packet<T, RES> writeBoolean(boolean v) throws IOException {
        this.write.writeBoolean(v);
        return this;
    }

    public Packet<T, RES> writeString(String s) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)this.write, (String)s);
        return this;
    }

    public Packet<T, RES> writeShort(short v) throws IOException {
        this.write.writeShort((int)v);
        return this;
    }

    public Packet<T, RES> writeInt(int v) throws IOException {
        this.write.writeInt(v);
        return this;
    }

    public Packet<T, RES> writeDouble(double v) throws IOException {
        this.write.writeDouble(v);
        return this;
    }

    public Packet<T, RES> writeFloat(float v) throws IOException {
        this.write.writeFloat(v);
        return this;
    }

    public Packet<T, RES> writeLong(long v) throws IOException {
        this.write.writeLong(v);
        return this;
    }

    public final void fromBytes(ByteBuf buf) {
        this.read = buf;
        try {
            this.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            this.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buf.writeBytes(this.write);
    }

    public final RES onMessage(T message, MessageContext ctx) {
        IThreadListener listener = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
        if (listener == null) {
            listener = OpenGlasses.proxy;
        }
        if (listener.func_152345_ab()) {
            return this.executePacket(message, ctx);
        }
        listener.func_152344_a(() -> this.executePacket(message, ctx));
        return null;
    }

    private RES executePacket(T message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ((Packet)message).executeOnServer(ctx.getServerHandler().field_147369_b);
        }
        return ((Packet)message).executeOnClient();
    }
}

