/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.upgrades;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.event.minecraft.client.ClientKeyboardEvents;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.surface.OCServerSurface;
import com.bymarcin.openglasses.utils.PlayerStatsOC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.capabilities.TGExtendedPlayer;

public class UpgradeNightvision
extends UpgradeItem {
    public static Potion potionNightvision = Potion.func_180142_b((String)"night_vision");

    @Override
    public ItemStack install(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74767_n("nightvision")) {
            tag.func_74757_a("nightvision", true);
        }
        return stack;
    }

    @Override
    public int getUpgradeExperienceCost() {
        return 20;
    }

    @Override
    public int getEnergyUsage() {
        return 5;
    }

    @Override
    public int getEnergyUsageCurrent(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("nightVisionActive") ? this.getEnergyUsage() : 1;
    }

    @Override
    public boolean isInstalled(ItemStack stack) {
        return UpgradeNightvision.hasUpgrade(stack);
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().equals(Items.field_151068_bn) && (stack.func_77978_p().func_74779_i("Potion").equals("minecraft:night_vision") || stack.func_77978_p().func_74779_i("Potion").equals("minecraft:long_night_vision"));
    }

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("nightvision");
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (UpgradeNightvision.hasUpgrade(stack)) {
            tooltip.add("nightvision: installed (mode: " + UpgradeNightvision.getMode(stack).name() + ")");
        } else {
            tooltip.add("nightvision not installed");
            tooltip.add("\u00a78requires any potion of nightvision\u00a77");
        }
        return tooltip;
    }

    private static int toggle(ItemStack glassesStack) {
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return -1;
        }
        int mode = UpgradeNightvision.getMode(glassesStack).ordinal() + 1;
        if (mode >= nightVisionModes.values().length) {
            mode = 0;
        }
        UpgradeNightvision.setMode(glassesStack, mode);
        return mode;
    }

    private static void setMode(ItemStack glassesStack, int mode) {
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return;
        }
        glassesStack.func_77978_p().func_74768_a("nightvisionMode", mode);
    }

    private static boolean shouldEnableNightvision(EntityPlayer player, ItemStack glassesStack) {
        if (!UpgradeNightvision.hasUpgrade(glassesStack)) {
            return false;
        }
        if (OpenGlassesItem.getEnergyStored(glassesStack) == 0.0) {
            return false;
        }
        switch (UpgradeNightvision.getMode(glassesStack)) {
            case ON: {
                return true;
            }
            case AUTO: {
                return player.func_70013_c() < 0.3f;
            }
        }
        if (OpenGlasses.techguns) {
            return UpgradeNightvision.shouldEnableNightVisionTG(player);
        }
        return false;
    }

    @Optional.Method(modid="techguns")
    private static boolean shouldEnableNightVisionTG(EntityPlayer player) {
        return !OpenGlasses.getGlassesStackTechguns(player).func_190926_b() && TGExtendedPlayer.get((EntityPlayer)player).enableNightVision;
    }

    private static nightVisionModes getMode(ItemStack glassesStack) {
        return nightVisionModes.values()[glassesStack.func_77978_p().func_74762_e("nightvisionMode")];
    }

    public static void toggleMode(EntityPlayer player) {
        ItemStack stack = OpenGlasses.getGlassesStack(player);
        if (OpenGlasses.isGlassesStack(stack)) {
            int mode = UpgradeNightvision.toggle(stack);
            player.func_146105_b((ITextComponent)new TextComponentString("nightvision mode: " + nightVisionModes.values()[mode].name()), true);
        }
    }

    @Override
    public void updateServer(EntityPlayer player, ItemStack glassesStack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return;
        }
        PlayerStatsOC stats = OCServerSurface.getStats((EntityPlayerMP)player);
        boolean wasActive = glassesStack.func_77978_p().func_74767_n("nightVisionActive");
        if (UpgradeNightvision.shouldEnableNightvision(player, glassesStack)) {
            player.func_70690_d(new PotionEffect(potionNightvision, 500, 0, false, false));
            glassesStack.func_77978_p().func_74757_a("nightVisionActive", true);
            if (!wasActive) {
                OpenGlassesItem.upgradeUpkeepCost(glassesStack);
                GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
            }
            stats.nightVisionActive = true;
        } else if (stats.nightVisionActive) {
            player.func_184589_d(potionNightvision);
            glassesStack.func_77978_p().func_74757_a("nightVisionActive", false);
            if (wasActive) {
                OpenGlassesItem.upgradeUpkeepCost(glassesStack);
                GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
            }
            stats.nightVisionActive = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput() {
        if (!ClientKeyboardEvents.nightvisionModeKey.func_151468_f()) {
            return;
        }
        if (!UpgradeNightvision.hasUpgrade(OCClientSurface.glasses.get())) {
            return;
        }
        NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(null, GlassesEventPacket.EventType.TOGGLE_NIGHTVISION));
    }

    public static enum nightVisionModes {
        OFF,
        AUTO,
        ON;

    }
}

