/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.component;

import ben_mkiv.commons0815.utils.utilsCommon;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.common.widgets.component.face.Box2D;
import ben_mkiv.rendertoolkit.common.widgets.component.face.Custom2D;
import ben_mkiv.rendertoolkit.common.widgets.component.face.Item2D;
import ben_mkiv.rendertoolkit.common.widgets.component.face.OBJModel2D;
import ben_mkiv.rendertoolkit.common.widgets.component.face.Text2D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.Cube3D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.Custom3D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.EntityTracker3D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.Item3D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.OBJModel3D;
import ben_mkiv.rendertoolkit.common.widgets.component.world.Text3D;
import ben_mkiv.rendertoolkit.network.messages.WidgetUpdatePacket;
import ben_mkiv.rendertoolkit.network.rTkNetwork;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.component.WidgetServer;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesNotificationsNBT;
import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.item.upgrades.UpgradeNavigation;
import com.bymarcin.openglasses.lib.McJty.font.TrueTypeFont;
import com.bymarcin.openglasses.lua.LuaObject;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.HostInfoPacket;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.surface.OCServerSurface;
import com.bymarcin.openglasses.utils.PlayerStatsOC;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import li.cil.oc.api.API;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OpenGlassesHostComponent
implements ManagedEnvironment {
    private UUID uuid = UUID.randomUUID();
    private Node node;
    private String terminalName = "";
    private boolean absoluteRenderPosition = false;
    private boolean addedToServerSurface = false;
    private WidgetServer widgets = new WidgetServer(this);
    private EnvironmentHost environmentHost;
    public static HashMap<EntityPlayer, UUID> linkRequests = new HashMap();

    public EnvironmentHost getHost() {
        return this.environmentHost;
    }

    public OpenGlassesHostComponent(EnvironmentHost container) {
        this.environmentHost = container;
        this.setupNode();
    }

    public Vec3d getRenderPosition() {
        return new Vec3d(this.environmentHost.xPosition(), this.environmentHost.yPosition(), this.environmentHost.zPosition());
    }

    void setupNode() {
        if (this.node() == null || this.node().network() == null) {
            this.node = API.network.newNode((Environment)this, Visibility.Network).withComponent(this.getComponentName()).withConnector().create();
        }
    }

    public void sendInteractEventWorldBlock(String eventType, String name, Vec3d playerPos, Vec3d look, double eyeh, BlockPos pos, EnumFacing face, double playerRotation, double playerPitch) {
        if (this.node() == null) {
            return;
        }
        BlockPos interactOffset = this.renderAbsolute() ? new BlockPos(0, 0, 0) : new BlockPos(this.environmentHost.xPosition(), this.environmentHost.yPosition(), this.environmentHost.zPosition());
        this.node().sendToReachable("computer.signal", new Object[]{eventType.toLowerCase(), name, (double)Math.round((playerPos.field_72450_a - (double)interactOffset.func_177958_n()) * 1000.0) / 1000.0, (double)Math.round((playerPos.field_72448_b - (double)interactOffset.func_177956_o()) * 1000.0) / 1000.0, (double)Math.round((playerPos.field_72449_c - (double)interactOffset.func_177952_p()) * 1000.0) / 1000.0, look.field_72450_a, look.field_72448_b, look.field_72449_c, eyeh, pos.func_177958_n() - interactOffset.func_177958_n(), pos.func_177956_o() - interactOffset.func_177956_o(), pos.func_177952_p() - interactOffset.func_177952_p(), face.func_176610_l(), playerRotation, playerPitch, EnumFacing.func_176733_a((double)playerRotation).func_176610_l()});
    }

    public void sendInteractEventWorld(String eventType, String name, Vec3d playerPos, Vec3d look, double eyeh, double playerRotation, double playerPitch) {
        if (this.node() == null) {
            return;
        }
        BlockPos interactOffset = this.renderAbsolute() ? new BlockPos(0, 0, 0) : new BlockPos(this.environmentHost.xPosition(), this.environmentHost.yPosition(), this.environmentHost.zPosition());
        this.node().sendToReachable("computer.signal", new Object[]{eventType.toLowerCase(), name, (double)Math.round((playerPos.field_72450_a - (double)interactOffset.func_177958_n()) * 1000.0) / 1000.0, (double)Math.round((playerPos.field_72448_b - (double)interactOffset.func_177956_o()) * 1000.0) / 1000.0, (double)Math.round((playerPos.field_72449_c - (double)interactOffset.func_177952_p()) * 1000.0) / 1000.0, look.field_72450_a, look.field_72448_b, look.field_72449_c, eyeh, playerRotation, playerPitch, EnumFacing.func_176733_a((double)playerRotation).func_176610_l()});
    }

    public void sendInteractEventOverlay(String eventType, String name, double button, double x, double y, Vec3d look, double eyeh, double playerRotation, double playerPitch) {
        if (this.node() == null) {
            return;
        }
        this.node().sendToReachable("computer.signal", new Object[]{eventType.toLowerCase(), name, x, y, button, look.field_72450_a, look.field_72448_b, look.field_72449_c, eyeh, playerRotation, playerPitch, EnumFacing.func_176733_a((double)playerRotation).func_176610_l()});
    }

    public void sendKeyboardInteractEventOverlay(String eventType, String name, int key, char symbol, Vec3d look, double eyeh, double playerRotation, double playerPitch) {
        if (this.node() == null) {
            return;
        }
        this.node().sendToReachable("computer.signal", new Object[]{eventType.toLowerCase(), name, key, "" + symbol, look.field_72450_a, look.field_72448_b, look.field_72449_c, eyeh, playerRotation, playerPitch, EnumFacing.func_176733_a((double)playerRotation).func_176610_l()});
    }

    public void sendChangeSizeEvent(String eventType, String player, int width, int height, double scaleFactor) {
        if (this.node() == null) {
            return;
        }
        this.node().sendToReachable("computer.signal", new Object[]{eventType.toLowerCase(), player, width, height, scaleFactor});
    }

    public Node node() {
        return this.node;
    }

    private void addToSurface() {
        if (!this.addedToServerSurface) {
            OCServerSurface.addHost(this);
            this.addedToServerSurface = true;
        }
    }

    private void removeFromSurface() {
        OCServerSurface.removeHost(this.uuid);
        this.addedToServerSurface = false;
    }

    public void onConnect(Node connectingNode) {
        if (connectingNode.equals(this.node())) {
            this.addToSurface();
        }
    }

    public void onDisconnect(Node disconnectingNode) {
        if (disconnectingNode.equals(this.node())) {
            this.removeFromSurface();
        }
    }

    public void onMessage(Message nodeSender) {
    }

    public boolean canUpdate() {
        return true;
    }

    public String getComponentName() {
        return "glasses";
    }

    public void onGlassesPutOn(EntityPlayerMP player) {
        if (this.node() == null) {
            return;
        }
        this.sync(player);
        this.node().sendToReachable("computer.signal", new Object[]{"glasses_on", player.getDisplayNameString()});
    }

    public void onGlassesPutOff(EntityPlayerMP player) {
        if (this.node() == null) {
            return;
        }
        rTkNetwork.sendTo((IMessage)new WidgetUpdatePacket(this.getUUID()), (EntityPlayer)player);
        this.node().sendToReachable("computer.signal", new Object[]{"glasses_off", player.getDisplayNameString()});
    }

    public void onPlayerLoggedOut(String playerName) {
        if (this.node() == null) {
            return;
        }
        this.node().sendToReachable("computer.signal", new Object[]{"glasses_off", playerName});
    }

    @Callback
    public Object[] startLinking(Context context, Arguments args) {
        String playerName = args.optString(0, "");
        HashSet<String> players = new HashSet<String>();
        if (playerName.length() > 0) {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            if (this.requestLink(player)) {
                players.add(player.func_145748_c_().func_150260_c());
            }
            return new Object[]{players.size() > 0, players.toArray()};
        }
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!this.requestLink(player)) continue;
            players.add(player.func_145748_c_().func_150260_c());
        }
        return new Object[]{true, players.toArray()};
    }

    private boolean requestLink(EntityPlayerMP player) {
        if (this.getRenderPosition().func_72438_d(player.func_174791_d()) > 64.0) {
            return false;
        }
        ItemStack glasses = OpenGlasses.getGlassesStack((EntityPlayer)player);
        if (glasses.func_190926_b()) {
            return false;
        }
        if (OpenGlassesHostsNBT.getHostFromNBT(this.getUUID(), glasses) != null) {
            return false;
        }
        if (OpenGlassesNotificationsNBT.getLinkRequest(glasses, this.getUUID()) != null) {
            return false;
        }
        OpenGlassesNotificationsNBT.addLinkRequest(glasses, this.getUUID());
        GlassesNBT.syncStackNBT(glasses, player);
        NetworkRegistry.packetHandler.sendTo((IMessage)new TerminalStatusPacket(TerminalStatusPacket.TerminalEvent.NOTIFICATION, this.getUUID()), player);
        return true;
    }

    @Callback(direct=true)
    public Object[] getConnectedPlayers(Context context, Arguments args) {
        Object[] ret = new Object[OCServerSurface.instances.playerStats.size()];
        int i = 0;
        for (Map.Entry e : OCServerSurface.instances.playerStats.entrySet()) {
            PlayerStatsOC s = (PlayerStatsOC)((Object)e.getValue());
            ret[i] = new Object[]{s.name, s.uuid, s.screenWidth, s.screenHeight, s.guiScale};
            ++i;
        }
        return new Object[]{ret};
    }

    @Callback(direct=true)
    public Object[] requestResolutionEvents(Context context, Arguments args) {
        String user = args.optString(0, "").toLowerCase();
        int i = 0;
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (user.length() > 0 && !user.equals(player.getDisplayNameString().toLowerCase())) continue;
            OCServerSurface.instance().requestResolutionEvent(player, this.getUUID());
            ++i;
        }
        return new Object[]{i};
    }

    @Callback(direct=true)
    public Object[] setRenderResolution(Context context, Arguments args) {
        double y;
        double x;
        TerminalStatusPacket packet = new TerminalStatusPacket(TerminalStatusPacket.TerminalEvent.SET_RENDER_RESOLUTION, this.getUUID());
        String user = "";
        if (args.count() == 3) {
            user = args.checkString(0).toLowerCase();
            x = args.checkDouble(1);
            y = args.checkDouble(2);
        } else if (args.count() == 2) {
            x = args.checkDouble(0);
            y = args.checkDouble(1);
        } else {
            if (args.count() < 2) {
                return new Object[]{false, "not enough arguments specified"};
            }
            return new Object[]{false, "too many arguments specified"};
        }
        packet.x = (float)x;
        packet.y = (float)y;
        int i = 0;
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (user.length() > 0 && !user.equals(player.getDisplayNameString().toLowerCase())) continue;
            if (OCServerSurface.instance().isSubscribedTo(player.func_110124_au(), this.getUUID())) {
                ItemStack glassesStack = OpenGlasses.getGlassesStack((EntityPlayer)player);
                OpenGlassesHostsNBT.setRenderResolution(new Vec3d(x, y, 0.0), glassesStack, this.getUUID());
                NetworkRegistry.packetHandler.sendTo((IMessage)packet, player);
            }
            ++i;
        }
        return new Object[]{i};
    }

    @Callback(direct=true)
    public Object[] getWidgetCount(Context context, Arguments args) {
        return new Object[]{this.widgets.size()};
    }

    @Callback(direct=true)
    public Object[] removeWidget(Context context, Arguments args) {
        if (args.count() < 1 || !args.isInteger(0)) {
            return new Object[]{false, "argument widget id missing"};
        }
        int id = args.checkInteger(0);
        return new Object[]{this.widgets.remove(id)};
    }

    @Callback(direct=true)
    public Object[] removeAll(Context context, Arguments args) {
        this.widgets.clear();
        return new Object[]{true};
    }

    @Callback(direct=true)
    public Object[] addCube3D(Context context, Arguments args) {
        Cube3D w = new Cube3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addText3D(Context context, Arguments args) {
        Text3D w = new Text3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addText2D(Context context, Arguments args) {
        Text2D w = new Text2D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addItem2D(Context context, Arguments args) {
        Item2D w = new Item2D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addItem3D(Context context, Arguments args) {
        Item3D w = new Item3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addCustom2D(Context context, Arguments args) {
        Custom2D w = new Custom2D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addOBJModel3D(Context context, Arguments args) {
        OBJModel3D w = new OBJModel3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addOBJModel2D(Context context, Arguments args) {
        OBJModel2D w = new OBJModel2D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addCustom3D(Context context, Arguments args) {
        Custom3D w = new Custom3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] addBox2D(Context context, Arguments args) {
        Box2D w = new Box2D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=false)
    public Object[] getFonts(Context context, Arguments args) {
        ArrayList<String> fonts = new ArrayList<String>();
        fonts.add("this method only returns fonts that are available on the server side");
        fonts.add("client fonts probably differ");
        for (Font font : TrueTypeFont.getFonts()) {
            fonts.add(font.getFontName());
        }
        return new Object[]{fonts.toArray()};
    }

    @Callback(direct=true)
    public Object[] addEntityTracker3D(Context context, Arguments args) {
        EntityTracker3D w = new EntityTracker3D();
        return this.addWidget((Widget)w);
    }

    @Callback(direct=true)
    public Object[] setTerminalName(Context context, Arguments args) {
        String newName = args.optString(0, "");
        if (!this.terminalName.equals(newName)) {
            this.terminalName = newName;
            this.syncHostInfo();
        }
        return new Object[]{true};
    }

    @Callback(direct=true)
    public Object[] getTerminalName(Context context, Arguments args) {
        return new Object[]{this.getName()};
    }

    @Callback(direct=true)
    public Object[] setRenderPosition(Context context, Arguments args) {
        if (args.count() > 0 && args.checkString(0).toLowerCase().equals("absolute")) {
            if (!OpenGlasses.absoluteRenderingAllowed) {
                return new Object[]{false, "absolute render position is disabled in the mod config"};
            }
            if (!this.absoluteRenderPosition) {
                this.absoluteRenderPosition = true;
                this.syncHostInfo();
            }
            return new Object[]{true};
        }
        if (args.count() > 0 && args.checkString(0).toLowerCase().equals("relative")) {
            if (this.absoluteRenderPosition) {
                this.absoluteRenderPosition = false;
                this.syncHostInfo();
            }
            return new Object[]{true};
        }
        return new Object[]{false, "first argument has to be \"relative\" or \"absolute\""};
    }

    @Callback(direct=true)
    public Object[] getRenderPosition(Context context, Arguments args) {
        return new Object[]{this.renderAbsolute() ? "absolute" : "relative"};
    }

    @Callback(direct=true)
    public Object[] widgets(Context context, Arguments args) {
        HashMap<String, LuaObject> widgetRefs = new HashMap<String, LuaObject>();
        int i = 0;
        for (Map.Entry widget : this.widgets.list.entrySet()) {
            widgetRefs.put("widget" + i++, new LuaObject((Integer)widget.getKey(), (Widget)widget.getValue(), this.getUUID()));
        }
        return new Object[]{widgetRefs};
    }

    @Callback(direct=true)
    public Object[] newUniqueKey(Context context, Arguments args) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!OCServerSurface.instance().isSubscribedTo(player.func_110124_au(), this.getUUID())) continue;
            this.onGlassesPutOff(player);
        }
        OCServerSurface.components.remove(this.getUUID());
        this.uuid = UUID.randomUUID();
        OCServerSurface.components.put(this.getUUID(), this);
        return new Object[]{this.getUUID()};
    }

    @Callback
    public Object[] getUserPosition(Context context, Arguments args) {
        if (args.isString(0)) {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(args.checkString(0));
            if (player == null) {
                return new Object[]{false, "player not found"};
            }
            Object position = this.getUserPosition((EntityPlayer)player);
            if (position == null) {
                position = false;
            }
            return new Object[]{position};
        }
        HashSet<Object> positions = new HashSet<Object>();
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Object position = this.getUserPosition((EntityPlayer)player);
            if (!(position instanceof HashMap)) continue;
            ((HashMap)position).put("user", player.getDisplayNameString());
            positions.add(position);
        }
        return new Object[]{positions};
    }

    @Callback
    public Object[] getUserLookingAt(Context context, Arguments args) {
        if (!args.isString(0)) {
            return new Object[]{false, "first argument has to be a username"};
        }
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(args.checkString(0));
        if (player == null) {
            return new Object[]{false, "player not found"};
        }
        Object lookingAt = this.getUserLookingAt(player);
        if (lookingAt == null) {
            lookingAt = false;
        }
        return new Object[]{lookingAt};
    }

    public String getName() {
        return this.terminalName;
    }

    public boolean renderAbsolute() {
        return OpenGlasses.absoluteRenderingAllowed && this.absoluteRenderPosition;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Object[] addWidget(Widget widget) {
        int widgetId = this.widgets.add(widget);
        return new Object[]{new LuaObject(widgetId, widget, this.getUUID()).call(null, null)[0]};
    }

    public boolean removeWidget(int id) {
        return this.widgets.remove(id);
    }

    public void updateWidget(int id) {
        this.widgets.update(id);
    }

    public Widget getWidget(int id) {
        return this.widgets.get(id);
    }

    public void save(NBTTagCompound nbt) {
        this.setupNode();
        nbt = this.widgets.writeToNBT(nbt);
        nbt.func_74778_a("name", this.terminalName);
        nbt.func_186854_a("uuid", this.uuid);
        nbt.func_74757_a("absoluteRenderPosition", this.absoluteRenderPosition);
        if (this.node() != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            this.node().save(nodeTag);
            nbt.func_74782_a("oc:node", (NBTBase)nodeTag);
        }
    }

    public void load(NBTTagCompound nbt) {
        this.widgets.readFromNBT(nbt);
        this.terminalName = nbt.func_74779_i("name");
        boolean bl = this.absoluteRenderPosition = OpenGlasses.absoluteRenderingAllowed && nbt.func_74767_n("absoluteRenderPosition");
        if (nbt.func_186855_b("uuid")) {
            this.uuid = nbt.func_186857_a("uuid");
        }
        this.setupNode();
        if (this.node() != null && nbt.func_74764_b("oc:node")) {
            this.node().load(nbt.func_74775_l("oc:node"));
        }
    }

    public void update() {
        this.addToSurface();
    }

    public void remove() {
        this.widgets.clear();
        if (this.getHost() != null && !this.getHost().world().field_72995_K) {
            for (Map.Entry entry : OCServerSurface.instance().players.entrySet()) {
                EntityPlayerMP player;
                if (!((HashSet)entry.getValue()).contains(this.getUUID()) || !((player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a((UUID)entry.getKey())) instanceof EntityPlayerMP)) continue;
                this.syncWidgets(player);
            }
            this.addedToServerSurface = false;
        }
        if (this.node() != null) {
            this.node().remove();
        }
    }

    public HashSet<EntityPlayerMP> getConnectedPlayers() {
        HashSet<EntityPlayerMP> players = new HashSet<EntityPlayerMP>();
        for (UUID playerUUID : this.getPlayers()) {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerUUID);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public HashSet<UUID> getPlayers() {
        HashSet<UUID> players = new HashSet<UUID>();
        for (UUID player : OCServerSurface.instances.players.keySet()) {
            if (!OCServerSurface.instance().isSubscribedTo(player, this.getUUID())) continue;
            players.add(player);
        }
        return players;
    }

    public static HashMap<String, Object> vec3D_to_map(Vec3d vector) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("x", vector.field_72450_a);
        result.put("y", vector.field_72448_b);
        result.put("z", vector.field_72449_c);
        return result;
    }

    private Object getUserPosition(EntityPlayer player) {
        ItemStack glassesStack = OpenGlasses.getGlassesStack(player);
        if (glassesStack.func_190926_b()) {
            return null;
        }
        if (!UpgradeNavigation.hasUpgrade(glassesStack)) {
            return new Object[]{false, "glasses haven't navigation upgrade installed"};
        }
        if (this.renderAbsolute()) {
            return OpenGlassesHostComponent.vec3D_to_map(player.func_174791_d());
        }
        Vec3d hostPosition = this.getRenderPosition();
        return OpenGlassesHostComponent.vec3D_to_map(player.func_174791_d().func_178788_d(hostPosition));
    }

    private Object getUserLookingAt(EntityPlayerMP player) {
        ItemStack glassesStack = OpenGlasses.getGlassesStack((EntityPlayer)player);
        if (glassesStack.func_190926_b()) {
            return null;
        }
        if (!UpgradeNavigation.hasUpgrade(glassesStack)) {
            return new Object[]{false, "glasses haven't navigation upgrade installed"};
        }
        double range = UpgradeGeolyzer.getRange(glassesStack);
        if (range == 0.0) {
            return new Object[]{false, "glasses haven't geolyzer upgrade installed"};
        }
        RayTraceResult result = utilsCommon.rayTrace((Entity)player, (double)range, (float)0.0f);
        HashMap<String, Object> hitInfo = new HashMap<String, Object>();
        if (result != null && !result.field_72313_a.equals((Object)RayTraceResult.Type.MISS) && result.func_178782_a() != null) {
            Vec3d pos = new Vec3d((Vec3i)result.func_178782_a());
            if (!this.renderAbsolute()) {
                pos = pos.func_178788_d(this.getRenderPosition());
            }
            IBlockState blockState = player.func_130014_f_().func_180495_p(result.func_178782_a());
            hitInfo.put("type", "block");
            hitInfo.putAll(OpenGlassesHostComponent.vec3D_to_map(pos));
            hitInfo.put("name", blockState.func_177230_c().getRegistryName().toString());
            hitInfo.put("meta", blockState.func_177230_c().func_176201_c(blockState));
            return hitInfo;
        }
        hitInfo.put("type", "air");
        return hitInfo;
    }

    public void sync(EntityPlayerMP player) {
        this.syncHostInfo(player);
        this.syncWidgets(player);
    }

    private void syncHostInfo() {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            this.syncHostInfo(player);
        }
    }

    public void syncHostInfo(EntityPlayerMP player) {
        if (player != null) {
            NetworkRegistry.packetHandler.sendTo((IMessage)new HostInfoPacket(this), player);
        }
    }

    public void syncWidgets(EntityPlayerMP player) {
        OCServerSurface.instances.sendSync(this.getUUID(), (EntityPlayer)player, this.widgets.list);
    }

    public void syncWidgets() {
        for (EntityPlayerMP player : this.getConnectedPlayers()) {
            OCServerSurface.instances.sendSync(this.getUUID(), (EntityPlayer)player, this.widgets.list);
        }
    }
}

