/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.recipe;

import buildcraft.api.BCItems;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.ChangingObject;
import buildcraft.lib.recipe.IRecipeViewable;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.item.ItemPluggableFacade;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.silicon.plug.FacadeStateManager;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class FacadeAssemblyRecipes
extends AssemblyRecipe
implements IRecipeViewable.IRecipePowered {
    public static final FacadeAssemblyRecipes INSTANCE = new FacadeAssemblyRecipes();
    private static final int TIME_GAP = 500;
    private static final long MJ_COST;
    private static final ChangingObject<Long> MJ_COSTS;

    public static ItemStack createFacadeStack(FacadeBlockStateInfo info, boolean isHollow) {
        ItemStack stack = BCSiliconItems.plugFacade.createItemStack(FacadeInstance.createSingle(info, isHollow));
        stack.func_190920_e(6);
        return stack;
    }

    @Override
    public ChangingItemStack[] getRecipeInputs() {
        ChangingItemStack[] inputs = new ChangingItemStack[2];
        inputs[0] = new ChangingItemStack(FacadeAssemblyRecipes.baseRequirementStack());
        NonNullList list = NonNullList.func_191196_a();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            list.add((Object)info.requiredStack);
            list.add((Object)info.requiredStack);
        }
        inputs[1] = new ChangingItemStack((NonNullList<ItemStack>)list);
        inputs[1].setTimeGap(500);
        return inputs;
    }

    @Override
    public ChangingItemStack getRecipeOutputs() {
        NonNullList list = NonNullList.func_191196_a();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            list.add((Object)FacadeAssemblyRecipes.createFacadeStack(info, false));
            list.add((Object)FacadeAssemblyRecipes.createFacadeStack(info, true));
        }
        ChangingItemStack changing = new ChangingItemStack((NonNullList<ItemStack>)list);
        changing.setTimeGap(500);
        return changing;
    }

    @Override
    public ChangingObject<Long> getMjCost() {
        return MJ_COSTS;
    }

    @Override
    public Set<ItemStack> getOutputs(NonNullList<ItemStack> inputs) {
        if (!StackUtil.contains(FacadeAssemblyRecipes.baseRequirementStack(), inputs)) {
            return Collections.emptySet();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : inputs) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            List<FacadeBlockStateInfo> infos = FacadeStateManager.stackFacades.get(new ItemStackKey(stack));
            if (infos == null || infos.isEmpty()) continue;
            for (FacadeBlockStateInfo info : infos) {
                stacks.add(FacadeAssemblyRecipes.createFacadeStack(info, false));
                stacks.add(FacadeAssemblyRecipes.createFacadeStack(info, true));
            }
        }
        return ImmutableSet.copyOf(stacks);
    }

    private static ItemStack baseRequirementStack() {
        if (BCItems.Transport.PIPE_STRUCTURE == null) {
            return new ItemStack(Blocks.field_150463_bK);
        }
        return new ItemStack(BCItems.Transport.PIPE_STRUCTURE, 3);
    }

    @Override
    public Set<ItemStack> getOutputPreviews() {
        return Collections.emptySet();
    }

    @Override
    public Set<IngredientStack> getInputsFor(@Nonnull ItemStack output) {
        FacadePhasedState state = ItemPluggableFacade.getStates(output).getCurrentStateForStack();
        ItemStack stateRequirement = state.stateInfo.requiredStack;
        IngredientStack ingredientType = new IngredientStack(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stateRequirement}));
        IngredientStack ingredientBase = new IngredientStack(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{FacadeAssemblyRecipes.baseRequirementStack()}), 3);
        return ImmutableSet.of((Object)ingredientType, (Object)ingredientBase);
    }

    @Override
    public long getRequiredMicroJoulesFor(@Nonnull ItemStack output) {
        return MJ_COST;
    }

    static {
        INSTANCE.setRegistryName(new ResourceLocation("buildcrafttransport:facadeRecipes"));
        MJ_COST = 64L * MjAPI.MJ;
        MJ_COSTS = new ChangingObject<Long>(new Long[]{MJ_COST});
    }
}

