/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncObjectDoubleObjectToObject<A, C, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectDoubleObjectToObject<A, C, R> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;
    private final Class<C> argTypeC;
    private final Class<R> returnType;

    public NodeFuncObjectDoubleObjectToObject(String name, Class<A> argTypeA, Class<C> argTypeC, Class<R> returnType, IFuncObjectDoubleObjectToObject<A, C, R> function) {
        this(argTypeA, argTypeC, returnType, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", double, " + NodeTypes.getName(argTypeC) + " -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectDoubleObjectToObject(Class<A> argTypeA, Class<C> argTypeC, Class<R> returnType, IFuncObjectDoubleObjectToObject<A, C, R> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.argTypeC = argTypeC;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public NodeFuncObjectDoubleObjectToObject<A, C, R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<C> c = stack.popObject(this.argTypeC);
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b, c);
    }

    public FuncObjectDoubleObjectToObject create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeDouble argB, IExpressionNode.INodeObject<C> argC) {
        return new FuncObjectDoubleObjectToObject(argA, argB, argC);
    }

    @FunctionalInterface
    public static interface IFuncObjectDoubleObjectToObject<A, C, R> {
        public R apply(A var1, double var2, C var4);
    }

    public class FuncObjectDoubleObjectToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeDouble argB;
        public final IExpressionNode.INodeObject<C> argC;

        public FuncObjectDoubleObjectToObject(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeDouble argB, IExpressionNode.INodeObject<C> argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectDoubleObjectToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectDoubleObjectToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectDoubleObjectToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectDoubleObjectToObject(a, (IExpressionNode.INodeDouble)b, c), (a, b, c) -> new FuncObjectDoubleObjectToObject(a, (IExpressionNode.INodeDouble)b, c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectDoubleObjectToObject(a, (IExpressionNode.INodeDouble)b, c), (a, b, c) -> new NodeConstantObject(NodeFuncObjectDoubleObjectToObject.this.returnType, NodeFuncObjectDoubleObjectToObject.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectDoubleObjectToObject.this.canInline) {
                if (NodeFuncObjectDoubleObjectToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectDoubleObjectToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB, this.argC);
        }

        public String toString() {
            return NodeFuncObjectDoubleObjectToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectDoubleObjectToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB, this.argC);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectDoubleObjectToObject other = (FuncObjectDoubleObjectToObject)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB) && Objects.equals(this.argC, other.argC);
        }
    }
}

