/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.block.BlockFloodGate;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileFloodGate
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    private static final EnumFacing[] SEARCH_NORMAL = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] SEARCH_GASEOUS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final ResourceLocation ADVANCEMENT_FLOOD_SINGLE = new ResourceLocation("buildcraftfactory:flooding_the_world");
    private static final int[] REBUILD_DELAYS = new int[]{16, 32, 64, 128, 256};
    private final Tank tank = new Tank("tank", 2000, this);
    public final Set<EnumFacing> openSides = EnumSet.copyOf(BlockFloodGate.CONNECTED_MAP.keySet());
    public final Deque<BlockPos> queue = new ArrayDeque<BlockPos>();
    private final Map<BlockPos, List<BlockPos>> paths = new HashMap<BlockPos, List<BlockPos>>();
    private int delayIndex = 0;
    private int tick = 0;

    public TileFloodGate() {
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tank, EnumPipePart.VALUES);
        this.tankManager.add(this.tank);
    }

    private int getCurrentDelay() {
        return REBUILD_DELAYS[this.delayIndex];
    }

    private void buildQueue() {
        this.field_145850_b.field_72984_F.func_76320_a("prepare");
        this.queue.clear();
        this.paths.clear();
        FluidStack fluid = this.tank.getFluid();
        if (fluid == null || fluid.amount <= 0) {
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(this.field_174879_c);
        ArrayList<BlockPos> nextPosesToCheck = new ArrayList<BlockPos>();
        for (EnumFacing face : this.openSides) {
            BlockPos offset = this.field_174879_c.func_177972_a(face);
            nextPosesToCheck.add(offset);
            this.paths.put(offset, (List<BlockPos>)ImmutableList.of((Object)offset));
        }
        EnumFacing[] directions = fluid.getFluid().isGaseous(fluid) ? SEARCH_GASEOUS : SEARCH_NORMAL;
        this.field_145850_b.field_72984_F.func_76318_c("build");
        block1: while (!nextPosesToCheck.isEmpty()) {
            ArrayList nextPosesToCheckCopy = new ArrayList(nextPosesToCheck);
            nextPosesToCheck.clear();
            for (BlockPos toCheck : nextPosesToCheckCopy) {
                if (toCheck.func_177951_i((Vec3i)this.field_174879_c) > 4096.0 || !checked.add(toCheck) || !this.canSearch(toCheck)) continue;
                if (this.canFill(toCheck)) {
                    this.queue.push(toCheck);
                    if (this.queue.size() >= 4096) break block1;
                }
                List<BlockPos> checkPath = this.paths.get(toCheck);
                for (EnumFacing side : directions) {
                    BlockPos next = toCheck.func_177972_a(side);
                    if (checked.contains(next)) continue;
                    ImmutableList.Builder pathBuilder = ImmutableList.builder();
                    pathBuilder.addAll(checkPath);
                    pathBuilder.add((Object)next);
                    this.paths.put(next, (List<BlockPos>)pathBuilder.build());
                    nextPosesToCheck.add(next);
                }
            }
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private boolean canFill(BlockPos offsetPos) {
        if (this.field_145850_b.func_175623_d(offsetPos)) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, offsetPos);
        return fluid != null && FluidUtilBC.areFluidsEqual(fluid, this.tank.getFluidType()) && BlockUtil.getFluidWithoutFlowing(this.getLocalState(offsetPos)) == null;
    }

    private boolean canSearch(BlockPos offsetPos) {
        if (this.canFill(offsetPos)) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluid(this.field_145850_b, offsetPos);
        return FluidUtilBC.areFluidsEqual(fluid, this.tank.getFluidType());
    }

    private boolean canFillThrough(BlockPos pos) {
        if (this.field_145850_b.func_175623_d(pos)) {
            return false;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, pos);
        return FluidUtilBC.areFluidsEqual(fluid, this.tank.getFluidType());
    }

    public void func_73660_a() {
        FluidStack fluid;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() < 1000) {
            return;
        }
        ++this.tick;
        if (this.tick % 16 == 0 && !this.tank.isEmpty() && !this.queue.isEmpty() && (fluid = this.tank.drain(1000, false)) != null && fluid.amount >= 1000) {
            BlockPos currentPos = this.queue.removeLast();
            List<BlockPos> path = this.paths.get(currentPos);
            boolean canFill = true;
            if (path != null) {
                for (BlockPos p : path) {
                    if (p.equals((Object)currentPos) || this.canFillThrough(currentPos)) continue;
                    canFill = false;
                    break;
                }
            }
            if (canFill && this.canFill(currentPos)) {
                FakePlayer fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)this.field_145850_b, this.getOwner(), currentPos);
                if (FluidUtil.tryPlaceFluid((EntityPlayer)fakePlayer, (World)this.field_145850_b, (BlockPos)currentPos, (IFluidHandler)this.tank, (FluidStack)fluid)) {
                    AdvancementUtil.unlockAdvancement(this.getOwner().getId(), ADVANCEMENT_FLOOD_SINGLE);
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        this.field_145850_b.func_175685_c(currentPos.func_177972_a(side), (Block)BCFactoryBlocks.floodGate, false);
                    }
                    this.delayIndex = 0;
                    this.tick = 0;
                }
            } else {
                this.buildQueue();
            }
        }
        if (this.queue.isEmpty() && this.tick >= this.getCurrentDelay()) {
            this.delayIndex = Math.min(this.delayIndex + 1, REBUILD_DELAYS.length - 1);
            this.tick = 0;
            this.buildQueue();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        byte b = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.openSides.contains(face)) continue;
            b = (byte)(b | 1 << face.func_176745_a());
        }
        nbt.func_74774_a("openSides", b);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        block5: {
            NBTBase open;
            block4: {
                super.func_145839_a(nbt);
                open = nbt.func_74781_a("openSides");
                if (!(open instanceof NBTPrimitive)) break block4;
                byte sides = ((NBTPrimitive)open).func_150290_f();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if ((sides >> face.func_176745_a() & 1) == 1) {
                        this.openSides.add(face);
                        continue;
                    }
                    this.openSides.remove(face);
                }
                break block5;
            }
            if (!(open instanceof NBTTagByteArray)) break block5;
            byte[] bytes = ((NBTTagByteArray)open).func_150292_c();
            BitSet bitSet = BitSet.valueOf(bytes);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (bitSet.get(face.func_176745_a())) {
                    this.openSides.add(face);
                    continue;
                }
                this.openSides.remove(face);
            }
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            MessageUtil.writeEnumSet((ByteBuf)buffer, this.openSides, EnumFacing.class);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        EnumSet<EnumFacing> _new;
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA && !(_new = MessageUtil.readEnumSet((ByteBuf)buffer, EnumFacing.class)).equals(this.openSides)) {
            this.openSides.clear();
            this.openSides.addAll(_new);
            this.redrawBlock();
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("fluid = " + this.tank.getDebugString());
        left.add("open sides = " + this.openSides.stream().map(Enum::name).collect(Collectors.joining(", ")));
        left.add("delay = " + this.getCurrentDelay());
        left.add("tick = " + this.tick);
        left.add("queue size = " + this.queue.size());
    }
}

