/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.jei.factory;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.compat.module.jei.factory.CategoryDistiller;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrapperDistiller
implements IRecipeWrapper {
    public final IRefineryRecipeManager.IDistillationRecipe recipe;
    private final ImmutableList<FluidStack> in;
    private final ImmutableList<FluidStack> out;
    private final IDrawableAnimated animated;

    WrapperDistiller(IGuiHelper guiHelper, IRefineryRecipeManager.IDistillationRecipe recipe) {
        this.recipe = recipe;
        this.in = ImmutableList.of((Object)recipe.in());
        this.out = ImmutableList.of((Object)recipe.outGas(), (Object)recipe.outLiquid());
        IDrawableStatic overComplete = guiHelper.createDrawable(CategoryDistiller.distillerBackground, 212, 0, 36, 57);
        this.animated = guiHelper.createAnimatedDrawable(overComplete, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(FluidStack.class, this.in);
        ingredients.setOutputs(FluidStack.class, this.out);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.animated.draw(minecraft, 20, 4);
        minecraft.field_71466_p.func_78276_b(MjAPI.formatMj(this.recipe.powerRequired()) + " MJ", 58, 28, Color.CYAN.getRGB());
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

