/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.jei;

import buildcraft.api.BCBlocks;
import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.compat.module.jei.energy.combustionengine.CategoryCombustionEngine;
import buildcraft.compat.module.jei.energy.combustionengine.HandlerCombustionEngine;
import buildcraft.compat.module.jei.factory.CategoryCoolable;
import buildcraft.compat.module.jei.factory.CategoryDistiller;
import buildcraft.compat.module.jei.factory.CategoryHeatable;
import buildcraft.compat.module.jei.factory.HandlerCoolable;
import buildcraft.compat.module.jei.factory.HandlerDistiller;
import buildcraft.compat.module.jei.factory.HandlerHeatable;
import buildcraft.compat.module.jei.recipe.GuiHandlerBuildCraft;
import buildcraft.compat.module.jei.silicon.CategoryAssemblyTable;
import buildcraft.compat.module.jei.silicon.WrapperAssemblyTable;
import buildcraft.compat.module.jei.transferhandlers.AdvancedCraftingItemsTransferHandler;
import buildcraft.compat.module.jei.transferhandlers.AutoCraftItemsTransferHandler;
import buildcraft.core.BCCoreBlocks;
import buildcraft.lib.fluid.FuelRegistry;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.silicon.container.ContainerAssemblyTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public class BCPluginJEI
implements IModPlugin {
    public static IModRegistry registry;

    public void register(IModRegistry registry) {
        BCPluginJEI.registry = registry;
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiHandlerBuildCraft()});
        boolean factory = BCModules.FACTORY.isLoaded();
        boolean energy = BCModules.ENERGY.isLoaded();
        boolean silicon = BCModules.SILICON.isLoaded();
        if (factory) {
            registry.handleRecipes(IRefineryRecipeManager.ICoolableRecipe.class, (IRecipeWrapperFactory)new HandlerCoolable(), "buildcraft:category_coolable");
            registry.handleRecipes(IRefineryRecipeManager.IDistillationRecipe.class, (IRecipeWrapperFactory)new HandlerDistiller(), "buildcraft:category_distiller");
            registry.handleRecipes(IRefineryRecipeManager.IHeatableRecipe.class, (IRecipeWrapperFactory)new HandlerHeatable(), "buildcraft:category_heatable");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getCoolableRegistry().getAllRecipes()), "buildcraft:category_coolable");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getAllRecipes()), "buildcraft:category_distiller");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getHeatableRegistry().getAllRecipes()), "buildcraft:category_heatable");
            if (BCBlocks.Factory.DISTILLER != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(BCBlocks.Factory.DISTILLER), new String[]{"buildcraft:category_distiller"});
            }
            if (BCBlocks.Factory.HEAT_EXCHANGE != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(BCBlocks.Factory.HEAT_EXCHANGE), new String[]{"buildcraft:category_coolable"});
                registry.addRecipeCatalyst((Object)new ItemStack(BCBlocks.Factory.HEAT_EXCHANGE), new String[]{"buildcraft:category_heatable"});
            }
        }
        if (energy) {
            registry.handleRecipes(IFuel.class, (IRecipeWrapperFactory)new HandlerCombustionEngine(), "buildcraft-compat:engine.combustion");
            registry.addRecipes((Collection)ImmutableList.copyOf(FuelRegistry.INSTANCE.getFuels()), "buildcraft-compat:engine.combustion");
            if (BCCoreBlocks.engine != null) {
                if (BCCoreBlocks.engine.isRegistered(EnumEngineType.STONE)) {
                    registry.addRecipeCatalyst((Object)BCCoreBlocks.engine.getStack(EnumEngineType.STONE), new String[]{"minecraft.fuel"});
                }
                if (BCCoreBlocks.engine.isRegistered(EnumEngineType.IRON)) {
                    registry.addRecipeCatalyst((Object)BCCoreBlocks.engine.getStack(EnumEngineType.IRON), new String[]{"buildcraft-compat:engine.combustion"});
                }
            }
        }
        if (silicon) {
            registry.handleRecipes(AssemblyRecipeBasic.class, WrapperAssemblyTable::new, "buildcraft-compat:silicon.assembly");
            registry.addRecipes((Collection)ImmutableList.copyOf(AssemblyRecipeRegistry.REGISTRY.values()), "buildcraft-compat:silicon.assembly");
            if (BCBlocks.Silicon.ASSEMBLY_TABLE != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(BCBlocks.Silicon.ASSEMBLY_TABLE), new String[]{"buildcraft-compat:silicon.assembly"});
            }
            if (BCBlocks.Silicon.ADVANCED_CRAFTING_TABLE != null) {
                registry.addRecipeCatalyst((Object)new ItemStack(BCBlocks.Silicon.ADVANCED_CRAFTING_TABLE), new String[]{"minecraft.crafting"});
            }
        }
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new AutoCraftItemsTransferHandler(), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new AdvancedCraftingItemsTransferHandler(), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAssemblyTable.class, "buildcraft-compat:silicon.assembly", 36, 12, 0, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        boolean factory = Loader.isModLoaded((String)BCModules.FACTORY.getModId());
        boolean energy = Loader.isModLoaded((String)BCModules.ENERGY.getModId());
        boolean silicon = Loader.isModLoaded((String)BCModules.SILICON.getModId());
        ArrayList lst = Lists.newArrayList();
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        if (factory) {
            lst.add("factory");
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryHeatable(helper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryDistiller(helper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryCoolable(helper)});
        }
        if (energy) {
            lst.add("energy");
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryCombustionEngine(helper)});
        }
        if (silicon) {
            lst.add("silicon");
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryAssemblyTable(helper)});
        }
        BCLog.logger.info("Loaded JEI mods: " + Arrays.toString(lst.toArray()));
    }
}

