/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.crafttweaker;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.Refinery")
@ModOnly(value="buildcraftfactory")
public class Refinery {
    @ZenMethod
    public static void addHeatable(ILiquidStack in, ILiquidStack out, int heatFrom, int heatTo) {
        FluidStack flIn = CraftTweakerMC.getLiquidStack((ILiquidStack)in);
        if (flIn == null) {
            throw new IllegalArgumentException("Input was null!");
        }
        FluidStack flOut = CraftTweakerMC.getLiquidStack((ILiquidStack)out);
        if (flOut == null) {
            throw new IllegalArgumentException("Output was null!");
        }
        if (BuildcraftRecipeRegistry.refineryRecipes.getHeatableRegistry().getRecipeForInput(flIn) != null) {
            throw new IllegalArgumentException("The fluid " + flOut + " is already registered as a heatable fluid!");
        }
        if (heatFrom < -10 || heatFrom > 20) {
            throw new IllegalArgumentException("Heat From (" + heatFrom + ") was out of range [-10, +20] - buildcraft itself only uses 0,1,2,3.");
        }
        if (heatTo < -10 || heatTo > 20) {
            throw new IllegalArgumentException("Heat To (" + heatTo + ") was out of range [-10, +20] - buildcraft itself only uses 0,1,2,3.");
        }
        if (heatFrom >= heatTo) {
            throw new IllegalArgumentException("Heat From (" + heatFrom + ") is greater than or equal to Heat To (" + heatTo + "), which is incorrect for a heatable recipe (the output fluid should be hotter than the input)");
        }
        CraftTweakerAPI.apply((IAction)new AddHeatable(flIn, flOut, heatFrom, heatTo));
    }

    @ZenMethod
    public static void addCoolable(ILiquidStack in, ILiquidStack out, int heatFrom, int heatTo) {
        FluidStack flIn = CraftTweakerMC.getLiquidStack((ILiquidStack)in);
        if (flIn == null) {
            throw new IllegalArgumentException("Input was null!");
        }
        FluidStack flOut = CraftTweakerMC.getLiquidStack((ILiquidStack)out);
        if (flOut == null) {
            throw new IllegalArgumentException("Output was null!");
        }
        if (BuildcraftRecipeRegistry.refineryRecipes.getCoolableRegistry().getRecipeForInput(flIn) != null) {
            throw new IllegalArgumentException("The fluid " + flOut + " is already registered as a coolable fluid!");
        }
        if (heatFrom < -10 || heatFrom > 20) {
            throw new IllegalArgumentException("Heat From (" + heatFrom + ") was out of range [-10, +20] - buildcraft itself only uses 0,1,2,3.");
        }
        if (heatTo < -10 || heatTo > 20) {
            throw new IllegalArgumentException("Heat To (" + heatTo + ") was out of range [-10, +20] - buildcraft itself only uses 0,1,2,3.");
        }
        if (heatFrom <= heatTo) {
            throw new IllegalArgumentException("Heat From (" + heatFrom + ") is less than or equal to Heat To (" + heatTo + "), which is incorrect for a coolable recipe (the output fluid should be colder than the input)");
        }
        CraftTweakerAPI.apply((IAction)new AddCoolable(flIn, flOut, heatFrom, heatTo));
    }

    static final class AddCoolable
    extends AddHeatTransfer
    implements IAction {
        public AddCoolable(FluidStack input, FluidStack output, int heatFrom, int heatTo) {
            super(input, output, heatFrom, heatTo);
        }

        public void apply() {
            BuildcraftRecipeRegistry.refineryRecipes.addCoolableRecipe(this.input, this.output, this.heatFrom, this.heatTo);
        }

        public String describe() {
            return "Adding coolable fluid " + this.input;
        }
    }

    static final class AddHeatable
    extends AddHeatTransfer
    implements IAction {
        public AddHeatable(FluidStack input, FluidStack output, int heatFrom, int heatTo) {
            super(input, output, heatFrom, heatTo);
        }

        public void apply() {
            BuildcraftRecipeRegistry.refineryRecipes.addHeatableRecipe(this.input, this.output, this.heatFrom, this.heatTo);
        }

        public String describe() {
            return "Adding heatable fluid " + this.input;
        }
    }

    static abstract class AddHeatTransfer {
        final FluidStack input;
        final FluidStack output;
        final int heatFrom;
        final int heatTo;

        public AddHeatTransfer(FluidStack input, FluidStack output, int heatFrom, int heatTo) {
            this.input = input;
            this.output = output;
            this.heatFrom = heatFrom;
            this.heatTo = heatTo;
        }
    }
}

