/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.api.schematics.SchematicBlockFactory;
import buildcraft.api.schematics.SchematicBlockFactoryRegistry;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class SchematicBlockManager {
    public static ISchematicBlock getSchematicBlock(SchematicBlockContext context) {
        for (SchematicBlockFactory schematicBlockFactory : Lists.reverse(SchematicBlockFactoryRegistry.getFactories())) {
            if (!schematicBlockFactory.predicate.test(context)) continue;
            ISchematicBlock schematicBlock = (ISchematicBlock)schematicBlockFactory.supplier.get();
            schematicBlock.init(context);
            return schematicBlock;
        }
        throw new UnsupportedOperationException();
    }

    public static <S extends ISchematicBlock> S createCleanCopy(S schematicBlock) {
        return (S)((ISchematicBlock)SchematicBlockFactoryRegistry.getFactoryByInstance(schematicBlock).supplier.get());
    }

    @Nonnull
    public static <S extends ISchematicBlock> NBTTagCompound writeToNBT(S schematicBlock) {
        NBTTagCompound schematicBlockTag = new NBTTagCompound();
        schematicBlockTag.func_74778_a("name", SchematicBlockFactoryRegistry.getFactoryByInstance(schematicBlock).name.toString());
        schematicBlockTag.func_74782_a("data", (NBTBase)schematicBlock.serializeNBT());
        return schematicBlockTag;
    }

    @Nonnull
    public static ISchematicBlock readFromNBT(NBTTagCompound schematicBlockTag) throws InvalidInputDataException {
        ResourceLocation name = new ResourceLocation(schematicBlockTag.func_74779_i("name"));
        SchematicBlockFactory<?> factory = SchematicBlockFactoryRegistry.getFactoryByName(name);
        if (factory == null) {
            throw new InvalidInputDataException("Unknown schematic type " + name);
        }
        ISchematicBlock schematicBlock = (ISchematicBlock)factory.supplier.get();
        NBTTagCompound data = schematicBlockTag.func_74775_l("data");
        try {
            schematicBlock.deserializeNBT(data);
            return schematicBlock;
        }
        catch (InvalidInputDataException e) {
            throw new InvalidInputDataException("Failed to load the schematic from " + data, e);
        }
    }
}

