/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.OfBoth;
import buildcraft.api.mj.OfProvider;
import buildcraft.api.mj.OfReceiver;
import net.minecraftforge.energy.IEnergyStorage;

public class MjToRfAutoConvertor
implements IMjReadable {
    final IEnergyStorage rf;

    public static MjToRfAutoConvertor create(IEnergyStorage rf) {
        if (rf == null) {
            return null;
        }
        if (!MjAPI.isRfAutoConversionEnabled()) {
            return null;
        }
        if (rf.canReceive()) {
            if (rf.canExtract()) {
                return new OfBoth(rf);
            }
            return new OfReceiver(rf);
        }
        if (rf.canExtract()) {
            return new OfProvider(rf);
        }
        return new MjToRfAutoConvertor(rf);
    }

    public static IMjReceiver createReceiver(IEnergyStorage rf) {
        MjToRfAutoConvertor convertor = MjToRfAutoConvertor.create(rf);
        if (convertor instanceof IMjReceiver) {
            return (IMjReceiver)((Object)convertor);
        }
        return null;
    }

    public static IMjPassiveProvider createProvider(IEnergyStorage rf) {
        MjToRfAutoConvertor convertor = MjToRfAutoConvertor.create(rf);
        if (convertor instanceof IMjPassiveProvider) {
            return (IMjPassiveProvider)((Object)convertor);
        }
        return null;
    }

    MjToRfAutoConvertor(IEnergyStorage storage) {
        this.rf = storage;
    }

    @Override
    public boolean canConnect(IMjConnector other) {
        return true;
    }

    @Override
    public long getStored() {
        return (long)this.rf.getEnergyStored() * MjAPI.getRfConversion().mjPerRf;
    }

    @Override
    public long getCapacity() {
        return (long)this.rf.getMaxEnergyStored() * MjAPI.getRfConversion().mjPerRf;
    }

    long implGetPowerRequested() {
        return (long)(this.rf.getMaxEnergyStored() - this.rf.getEnergyStored()) * MjAPI.getRfConversion().mjPerRf;
    }

    long implReceivePower(long microJoules, boolean simulate) {
        if (!this.rf.canReceive()) {
            return microJoules;
        }
        long mjPerRf = MjAPI.getRfConversion().mjPerRf;
        int maxRf = (int)(microJoules / mjPerRf);
        if (maxRf <= 0) {
            return microJoules;
        }
        int received = this.rf.receiveEnergy(maxRf, simulate);
        return microJoules - (long)received * mjPerRf;
    }

    long implExtractPower(long min, long max, boolean simulate) {
        if (!this.rf.canExtract()) {
            return 0L;
        }
        long mjPerRf = MjAPI.getRfConversion().mjPerRf;
        int maxRf = (int)(max / mjPerRf);
        if (maxRf <= 0) {
            return 0L;
        }
        int extractedRF = this.rf.extractEnergy(maxRf, true);
        long extractedMJ = (long)extractedRF * mjPerRf;
        if (extractedMJ < min) {
            return 0L;
        }
        if (!simulate) {
            this.rf.extractEnergy(maxRf, simulate);
        }
        return extractedMJ;
    }
}

