/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class MjCapabilityHelper
implements ICapabilityProvider {
    @Nonnull
    private final IMjConnector connector;
    @Nullable
    private final IMjReceiver receiver;
    @Nullable
    private final IMjRedstoneReceiver rsReceiver;
    @Nullable
    private final IMjReadable readable;
    @Nullable
    private final IMjPassiveProvider provider;
    private final IEnergyStorage rfAutoConvert;

    public MjCapabilityHelper(@Nonnull IMjConnector mj) {
        this.connector = mj;
        this.receiver = mj instanceof IMjReceiver ? (IMjReceiver)mj : null;
        this.rsReceiver = mj instanceof IMjRedstoneReceiver ? (IMjRedstoneReceiver)mj : null;
        this.readable = mj instanceof IMjReadable ? (IMjReadable)mj : null;
        this.provider = mj instanceof IMjPassiveProvider ? (IMjPassiveProvider)mj : null;
        this.rfAutoConvert = MjAPI.isRfAutoConversionEnabled() ? new IEnergyStorage(){

            public int getEnergyStored() {
                IMjReadable read = MjCapabilityHelper.this.readable;
                if (read != null) {
                    long mjPerRf = MjAPI.getRfConversion().mjPerRf;
                    return (int)(read.getStored() / mjPerRf);
                }
                return 0;
            }

            public int getMaxEnergyStored() {
                IMjReadable read = MjCapabilityHelper.this.readable;
                if (read != null) {
                    long mjPerRf = MjAPI.getRfConversion().mjPerRf;
                    return (int)(read.getCapacity() / mjPerRf);
                }
                return 0;
            }

            public boolean canReceive() {
                return MjCapabilityHelper.this.receiver != null && MjCapabilityHelper.this.receiver.canReceive();
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                long excess3;
                if (maxReceive <= 0) {
                    return 0;
                }
                IMjReceiver recv = MjCapabilityHelper.this.receiver;
                if (recv == null || !recv.canReceive()) {
                    return 0;
                }
                long mjPerRf = MjAPI.getRfConversion().mjPerRf;
                long maxReceiveMj = (long)maxReceive * mjPerRf;
                long excess = recv.receivePower(maxReceiveMj, true);
                long acceptedMj = maxReceiveMj - excess;
                if (acceptedMj < mjPerRf) {
                    return 0;
                }
                long excessMj = acceptedMj % mjPerRf;
                long exactAcceptableMj = maxReceiveMj - excessMj;
                if (exactAcceptableMj <= 0L) {
                    return 0;
                }
                int rf = (int)(exactAcceptableMj / mjPerRf);
                if ((long)rf * mjPerRf != exactAcceptableMj) {
                    throw new IllegalStateException("Programmer made a mistake?? mjPerRf=" + mjPerRf + ", rf=" + rf + ", exactAcceptableMJ=" + exactAcceptableMj);
                }
                long excess2 = recv.receivePower(exactAcceptableMj, true);
                if (excess2 != 0L) {
                    return 0;
                }
                if (!simulate && (excess3 = recv.receivePower(exactAcceptableMj, simulate)) != excess2) {
                    throw new IllegalStateException("Bad impl: " + recv.getClass() + " of receivePower");
                }
                return rf;
            }

            public boolean canExtract() {
                return MjCapabilityHelper.this.provider != null;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                long mjPerRf = MjAPI.getRfConversion().mjPerRf;
                return 0;
            }
        } : null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_CONNECTOR) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.connector);
        }
        if (capability == MjAPI.CAP_RECEIVER) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)this.receiver);
        }
        if (capability == MjAPI.CAP_REDSTONE_RECEIVER) {
            return (T)MjAPI.CAP_REDSTONE_RECEIVER.cast((Object)this.rsReceiver);
        }
        if (capability == MjAPI.CAP_READABLE) {
            return (T)MjAPI.CAP_READABLE.cast((Object)this.readable);
        }
        if (capability == MjAPI.CAP_PASSIVE_PROVIDER) {
            return (T)MjAPI.CAP_PASSIVE_PROVIDER.cast((Object)this.provider);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.rfAutoConvert);
        }
        return null;
    }
}

