/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.surface;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.surface.WidgetCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientSurface {
    public static ClientSurface instances = new ClientSurface();
    public static final Vec3d vec3d000 = new Vec3d(0.0, 0.0, 0.0);
    public static final Vector3f vec3f000 = new Vector3f(0.0f, 0.0f, 0.0f);
    public int maxTrackingRange = 64;
    public static int viewDistance = 64;
    public boolean entityTrackerEnabled = true;
    public static ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
    private Vec3d renderResolution = null;
    private WidgetCollection widgets = new WidgetCollection();

    public Vec3d getRenderResolution(UUID instanceUUID) {
        return this.renderResolution;
    }

    public void setRenderResolution(Vec3d resolution, UUID instanceUUID) {
        this.renderResolution = resolution;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        if (!(evt instanceof RenderGameOverlayEvent.Post)) {
            return;
        }
        if (!this.shouldRenderStart(RenderType.GameOverlayLocated)) {
            return;
        }
        ClientSurface.preRender(RenderType.GameOverlayLocated, evt.getPartialTicks());
        this.renderWidgets(this.widgets.getWidgetsOverlay().values());
        ClientSurface.postRender(RenderType.GameOverlayLocated);
    }

    public static void renderSingleWidgetOverlay(IRenderableWidget widget, Long conditions) {
        ClientSurface.renderSingleWidgetOverlay(widget, conditions, vec3d000);
    }

    public static void renderSingleWidgetOverlay(IRenderableWidget widget, Long conditions, Vec3d location) {
        ClientSurface.preRender(RenderType.GameOverlayLocated, 0.0f);
        widget.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, location, conditions);
        ClientSurface.postRender(RenderType.GameOverlayLocated);
    }

    public static void renderSingleWidgetWorld(IRenderableWidget widget, Long conditions, Vec3d location, float partialTicks) {
        ClientSurface.preRender(RenderType.WorldLocated, partialTicks);
        widget.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, location, conditions);
        ClientSurface.postRender(RenderType.WorldLocated);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (!this.shouldRenderStart(RenderType.WorldLocated)) {
            return;
        }
        ClientSurface.preRender(RenderType.WorldLocated, event.getPartialTicks());
        this.renderWidgets(this.widgets.getWidgetsWorld().values());
        ClientSurface.postRender(RenderType.WorldLocated);
    }

    private void renderWidgets(Collection<IRenderableWidget> widgets) {
        this.renderWidgets(widgets, Long.MAX_VALUE);
    }

    private void renderWidgets(Collection<IRenderableWidget> widgets, long renderConditions) {
        String uuid = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString();
        for (IRenderableWidget renderable : widgets) {
            if (!renderable.shouldWidgetBeRendered((EntityPlayer)Minecraft.func_71410_x().field_71439_g) || !renderable.isWidgetOwner(uuid)) continue;
            ClientSurface.renderWidget(renderable, renderConditions);
        }
    }

    public static void preRender(RenderType renderType, float partialTicks) {
        GlStateManager.func_179094_E();
        switch (renderType) {
            case WorldLocated: {
                double[] playerLocation = ClientSurface.getEntityPlayerLocation(Minecraft.func_71410_x().func_175606_aa(), partialTicks);
                GlStateManager.func_179137_b((double)(-playerLocation[0]), (double)(-playerLocation[1]), (double)(-playerLocation[2]));
                GlStateManager.func_179132_a((boolean)true);
                break;
            }
            case GameOverlayLocated: {
                if (instances.getRenderResolution(null) != null) {
                    GlStateManager.func_179139_a((double)((double)resolution.func_78326_a() / ClientSurface.instances.getRenderResolution(null).field_72450_a), (double)((double)resolution.func_78328_b() / ClientSurface.instances.getRenderResolution(null).field_72448_b), (double)1.0);
                }
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    public static void postRender(RenderType renderType) {
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179097_i();
    }

    public static void renderWidget(IRenderableWidget widget, long conditionStates) {
        ClientSurface.renderWidget(widget, conditionStates, vec3d000);
    }

    public static void renderWidget(IRenderableWidget widget, long conditionStates, Vec3d renderOffset) {
        GlStateManager.func_179094_E();
        widget.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, renderOffset, conditionStates);
        GlStateManager.func_179121_F();
    }

    public static double[] getEntityPlayerLocation(Entity e, float partialTicks) {
        double x = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks;
        double y = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks;
        double z = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks;
        return new double[]{x, y, z};
    }

    public static RayTraceResult getBlockCoordsLookingAt(EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
            return Minecraft.func_71410_x().field_71476_x;
        }
        return null;
    }

    public boolean shouldRenderStart(RenderType renderEvent) {
        return this.getWidgetCount(null, renderEvent) > 0;
    }

    public void updateWidgets(UUID uuid, Set<Map.Entry<Integer, Widget>> widgets) {
        this.widgets.updateWidgets(widgets);
    }

    public void removeWidgets(UUID uuid, List<Integer> ids) {
        this.widgets.removeWidgets(ids);
    }

    public void removeAllWidgets(UUID uuid) {
        this.widgets.removeAllWidgets();
    }

    public int getWidgetCount(UUID uuid, RenderType renderEvent) {
        return this.widgets.getWidgetCount(renderEvent);
    }

    public void sendResolution(UUID instanceUUID) {
    }
}

