/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.network.messages;

import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetUpdatePacket
implements IMessage {
    public HashMap<Integer, Widget> widgetList;
    List<Integer> ids;
    Action type;
    UUID uuid = null;

    public WidgetUpdatePacket() {
    }

    public WidgetUpdatePacket(UUID uuid) {
        this.type = Action.RemoveAllWidgets;
        this.uuid = uuid;
    }

    public WidgetUpdatePacket(UUID uuid, HashMap<Integer, Widget> widgetList) {
        this.widgetList = widgetList;
        this.type = Action.AddWigets;
        this.uuid = uuid;
    }

    public WidgetUpdatePacket(UUID uuid, List<Integer> l) {
        this.ids = l;
        this.type = Action.RemoveWidgets;
        this.uuid = uuid;
    }

    public WidgetUpdatePacket(UUID uuid, int id) {
        this.ids = new ArrayList<Integer>();
        this.ids.add(id);
        this.type = Action.RemoveWidgets;
        this.uuid = uuid;
    }

    public WidgetUpdatePacket(UUID uuid, int id, @Nonnull Widget widget) {
        this.widgetList = new HashMap();
        this.widgetList.put(id, widget);
        this.type = Action.AddWigets;
        this.uuid = uuid;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.uuid = new UUID(buf.readLong(), buf.readLong());
        }
        this.type = Action.values()[buf.readInt()];
        switch (this.type) {
            case AddWigets: {
                this.widgetList = new HashMap();
                int size = buf.readInt();
                for (int i = 0; i < size; ++i) {
                    Widget w = Widget.create(buf.readInt());
                    w.read(buf);
                    this.widgetList.put(buf.readInt(), w);
                }
                break;
            }
            case RemoveWidgets: {
                this.ids = new ArrayList<Integer>();
                int size = buf.readInt();
                for (int i = 0; i < size; ++i) {
                    this.ids.add(buf.readInt());
                }
                break;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.uuid != null);
        if (this.uuid != null) {
            buf.writeLong(this.uuid.getMostSignificantBits());
            buf.writeLong(this.uuid.getLeastSignificantBits());
        }
        buf.writeInt(this.type.ordinal());
        switch (this.type) {
            case AddWigets: {
                buf.writeInt(this.widgetList.size());
                for (Map.Entry<Integer, Widget> w : this.widgetList.entrySet()) {
                    buf.writeInt(w.getValue().getType().ordinal());
                    w.getValue().write(buf);
                    buf.writeInt(w.getKey().intValue());
                }
                break;
            }
            case RemoveWidgets: {
                buf.writeInt(this.ids.size());
                for (Integer id : this.ids) {
                    buf.writeInt(id.intValue());
                }
                break;
            }
        }
    }

    public static class Handler
    implements IMessageHandler<WidgetUpdatePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final WidgetUpdatePacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    switch (message.type) {
                        case AddWigets: {
                            ClientSurface.instances.updateWidgets(message.uuid, message.widgetList.entrySet());
                            return;
                        }
                        case RemoveWidgets: {
                            ClientSurface.instances.removeWidgets(message.uuid, message.ids);
                            return;
                        }
                        case RemoveAllWidgets: {
                            ClientSurface.instances.removeAllWidgets(message.uuid);
                            return;
                        }
                    }
                }
            });
            return null;
        }
    }

    public static enum Action {
        AddWigets,
        RemoveWidgets,
        RemoveAllWidgets;

    }
}

