/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj;

import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.Vec3d;

public class Vertex {
    public static final int BRIGHTNESS_MAX = 0xF000F0;
    private String baseName;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int brightness = 0;
    private int color = 0xFFFFFF;
    private int alpha = 255;
    private int normal = 0;
    private double u = 0.0;
    private double v = 0.0;
    private Vertex initialState;

    public Vertex(double x, double y, double z, int rgba, int brightness, double u, double v, int normal, boolean isInitialState) {
        this.set(x, y, z);
        this.setRGBA(rgba);
        this.setBrightness(brightness);
        this.setUV(u, v);
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.normal = normal;
        this.baseName();
        if (!isInitialState) {
            this.initialState = new Vertex(x, y, z, rgba, brightness, u, v, normal, true);
        }
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, -1, 0xF000F0, 0.0, 0.0, 0, false);
    }

    public Vertex(Vertex vertex) {
        this(vertex.x, vertex.y, vertex.z, vertex.color << 8 | vertex.alpha, vertex.getBrightness(), vertex.u, vertex.v, 0, false);
        this.baseName = vertex.baseName;
    }

    public double getX() {
        return this.x;
    }

    public Vertex setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public Vertex setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public Vertex setZ(double z) {
        this.z = z;
        return this;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getColor() {
        return this.color;
    }

    public Vertex setColor(int color) {
        this.color = color & 0xFFFFFF;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Vertex setAlpha(int alpha) {
        this.alpha = alpha & 0xFF;
        return this;
    }

    public int getRGBA() {
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        return this.alpha << 24 | b << 16 | g << 8 | r;
    }

    public Vertex setRGBA(int rgba) {
        this.color = rgba >>> 8 & 0xFFFFFF;
        this.alpha = rgba & 0xFF;
        return this;
    }

    public int getBlockBrightness() {
        return this.brightness & 0xF0;
    }

    public int getSkyBrightness() {
        return this.brightness >> 16 & 0xF0;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public Vertex setBrightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public int getNormal() {
        return this.normal;
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public void setUV(double u, double v) {
        this.u = u;
        this.v = v;
    }

    public boolean isCorner() {
        return !(this.x != 1.0 && this.x != 0.0 || this.y != 1.0 && this.y != 0.0 || this.z != 1.0 && this.z != 0.0);
    }

    public String baseName() {
        if (this.baseName == null) {
            this.baseName = "";
            if (this.isCorner()) {
                this.baseName = (this.y == 1.0 ? "Top" : "Bottom") + (this.z == 1.0 ? "South" : "North") + (this.x == 1.0 ? "East" : "West");
            }
        }
        return this.baseName;
    }

    public String name() {
        return this.baseName() + " [" + this.x + ", " + this.y + ", " + this.z + "|" + this.u + ", " + this.v + "]";
    }

    public String toString() {
        return this.name() + " 0x" + Integer.toHexString(this.color) + " (a:" + this.alpha + ", bb:" + this.getBlockBrightness() + ", sb:" + this.getSkyBrightness() + ")";
    }

    public int[] getVertexData(VertexFormat vertexFormat, Vec3d offset) {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float z = (float)this.getZ();
        if (offset != null) {
            x = (float)((double)x + offset.field_72450_a);
            y = (float)((double)y + offset.field_72448_b);
            z = (float)((double)z + offset.field_72449_c);
        }
        int[] data = new int[vertexFormat.func_181719_f()];
        int index = 0;
        data[index++] = Float.floatToRawIntBits(x);
        data[index++] = Float.floatToRawIntBits(y);
        data[index++] = Float.floatToRawIntBits(z);
        if (vertexFormat.func_177346_d()) {
            data[index++] = this.getRGBA();
        }
        if (vertexFormat.func_177347_a(0)) {
            data[index++] = Float.floatToRawIntBits((float)this.getU());
            data[index++] = Float.floatToRawIntBits((float)this.getV());
        }
        if (vertexFormat.func_177347_a(1)) {
            data[index++] = this.getBrightness();
        }
        if (vertexFormat.func_177350_b()) {
            data[index++] = this.getNormal();
        }
        return data;
    }
}

