/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.ICustomShape;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class CustomShape
extends WidgetGLWorld
implements ICustomShape {
    private HashMap<Integer, ArrayList> vectors;
    private HashMap<Integer, ArrayList> vectorsCache;
    private ArrayList<ArrayList> triangleCache = new ArrayList();
    private boolean updateCache = true;
    public boolean gl_strips = false;
    public boolean smooth_shading = false;

    public CustomShape() {
        this.vectors = new HashMap();
    }

    @Override
    public int getVertexCount() {
        return this.vectors.size();
    }

    private void syncCache() {
        if (!this.updateCache) {
            return;
        }
        this.vectorsCache = new HashMap<Integer, ArrayList>(this.vectors);
        if (!this.gl_strips) {
            this.triangleCache = new ArrayList();
            ArrayList<ArrayList> triangle = new ArrayList<ArrayList>();
            for (ArrayList vector : this.vectorsCache.values()) {
                if (triangle.size() == 3) {
                    this.triangleCache.add(triangle);
                    triangle = new ArrayList();
                }
                triangle.add(vector);
            }
        }
        this.updateCache = false;
    }

    @Override
    public void setVertex(int n, float nx, float ny, float nz) {
        if (this.vectors.containsKey(n)) {
            this.vectors.get(n).set(0, Float.valueOf(nx));
            this.vectors.get(n).set(1, Float.valueOf(ny));
            this.vectors.get(n).set(2, Float.valueOf(nz));
            this.updateCache = true;
        } else {
            this.addVertex(nx, ny, nz);
        }
    }

    @Override
    public int addVertex(float nx, float ny, float nz) {
        ArrayList<Float> vector = new ArrayList<Float>();
        vector.add(Float.valueOf(nx));
        vector.add(Float.valueOf(ny));
        vector.add(Float.valueOf(nz));
        int index = this.getVertexIndex();
        this.vectors.put(index, vector);
        this.updateCache = true;
        return index;
    }

    private int getVertexIndex() {
        int index = 0;
        for (int vertIndex : new HashSet<Integer>(this.vectors.keySet())) {
            if (vertIndex <= index) continue;
            index = vertIndex;
        }
        return index + 1;
    }

    @Override
    public void removeVertex(int n) {
        if (this.vectors.containsKey(n)) {
            this.vectors.remove(n);
            this.updateCache = true;
        }
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeBoolean(this.gl_strips);
        HashMap<Integer, ArrayList> vectorBuffer = new HashMap<Integer, ArrayList>(this.vectors);
        buff.writeInt(this.vectors.size());
        for (Map.Entry<Integer, ArrayList> entry : vectorBuffer.entrySet()) {
            buff.writeInt(entry.getKey().intValue());
            buff.writeFloat(((Float)entry.getValue().get(0)).floatValue());
            buff.writeFloat(((Float)entry.getValue().get(1)).floatValue());
            buff.writeFloat(((Float)entry.getValue().get(2)).floatValue());
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.gl_strips = buff.readBoolean();
        this.vectors = new HashMap();
        int vectorCount = buff.readInt();
        for (int i = 0; i < vectorCount; ++i) {
            this.setVertex(buff.readInt(), buff.readFloat(), buff.readFloat(), buff.readFloat());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableCustom();
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderableCustom
    extends WidgetGLOverlay.RenderableGLWidget {
        public RenderableCustom() {
            super(CustomShape.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            CustomShape.this.syncCache();
            if (CustomShape.this.vectorsCache.size() < 3) {
                return;
            }
            this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            if (CustomShape.this.smooth_shading) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            if (CustomShape.this.gl_strips) {
                GlStateManager.func_187447_r((int)5);
                for (ArrayList vector : CustomShape.this.vectorsCache.values()) {
                    GlStateManager.func_187435_e((float)((Float)vector.get(0)).floatValue(), (float)((Float)vector.get(1)).floatValue(), (float)((Float)vector.get(2)).floatValue());
                }
            } else {
                GL11.glBegin((int)4);
                for (ArrayList tri : CustomShape.this.triangleCache) {
                    for (ArrayList vector : tri) {
                        GlStateManager.func_187435_e((float)((Float)vector.get(0)).floatValue(), (float)((Float)vector.get(1)).floatValue(), (float)((Float)vector.get(2)).floatValue());
                    }
                }
            }
            GlStateManager.func_187437_J();
            this.postRender();
        }
    }
}

