/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets;

import ben_mkiv.rendertoolkit.common.widgets.WidgetModifierConditionType;
import ben_mkiv.rendertoolkit.common.widgets.core.Easing;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class WidgetModifier {
    public HashMap<String, ArrayList> easings = new HashMap();
    public long conditions = 0L;

    public boolean shouldApplyModifier(long conditionStates) {
        return (this.conditions & conditionStates) == this.conditions;
    }

    public Object[] getConditions() {
        Object[] foo = new Object[64];
        int s = 0;
        for (short i = 0; i < 64; i = (short)(i + 1)) {
            if ((this.conditions >>> i & 1L) == 0L) continue;
            foo[s] = WidgetModifierConditionType.getName(i);
            s = (short)(s + 1);
        }
        return foo;
    }

    public void writeData(ByteBuf buff) {
        buff.writeLong(this.conditions);
        buff.writeInt(this.easings.size());
        for (Map.Entry<String, ArrayList> entry : this.easings.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)entry.getKey());
            Easing.writeEasing(buff, entry.getValue());
        }
    }

    public void readData(ByteBuf buff) {
        this.conditions = buff.readLong();
        int easingCount = buff.readInt();
        for (int i = 0; i < easingCount; ++i) {
            String listName = ByteBufUtils.readUTF8String((ByteBuf)buff);
            this.easings.remove(listName);
            this.easings.put(listName, Easing.readEasing(buff));
        }
    }

    public void configureCondition(short type, boolean state) {
        this.conditions = state ? (this.conditions |= 1L << type) : (this.conditions &= 1L << type ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void addEasing(String type, String typeIO, float duration, String list, float min, float max, String mode) {
        this.removeEasing(list.toLowerCase());
        this.easings.put(list.toLowerCase(), Easing.setEasing(Easing.EasingType.valueOf(type.toUpperCase()), Easing.EasingTypeIO.valueOf(typeIO.toUpperCase()), duration, min, max, Easing.EasingTypeMode.valueOf(mode.toUpperCase())));
    }

    public void removeEasing(String list) {
        this.easings.remove(list.toLowerCase());
    }

    public HashMap<String, ArrayList> getEasings() {
        return this.easings;
    }

    public void apply(long conditionStates) {
    }

    public void revoke(long conditionStates) {
    }

    public void update(float[] values) {
    }

    public WidgetModifierType getType() {
        return null;
    }

    public Object[] getValues() {
        return null;
    }

    public static enum WidgetModifierType {
        TRANSLATE,
        COLOR,
        SCALE,
        ROTATE,
        TEXTURE,
        AUTOTRANSLATE;

    }
}

