/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.thermalvision;

import ben_mkiv.rendertoolkit.client.OptifineHelper;
import ben_mkiv.rendertoolkit.client.shaders.VazkiiShaderHelper;
import ben_mkiv.rendertoolkit.client.thermalvision.ShaderHelper;
import ben_mkiv.rendertoolkit.renderToolkit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ARBShaderObjects;

public class ThermalEntityRender {
    int thermalColorShader = -1;
    private static double currentDistance = 0.0;
    private static boolean isDead = false;
    private static boolean overlayVisible = true;
    private static boolean isOptifineSpecialCase = false;
    protected static boolean fastRenderEnabled = false;
    public static final VazkiiShaderHelper.ShaderCallback callback = shader -> {
        if (isDead) {
            ThermalEntityRender.setShaderColor(shader, "red", 0.0f);
            ThermalEntityRender.setShaderColor(shader, "blue", 1.0f / (float)(currentDistance / 8.0));
        } else {
            ThermalEntityRender.setShaderColor(shader, "red", 1.0f / (float)(currentDistance / 8.0));
            ThermalEntityRender.setShaderColor(shader, "blue", 0.0f);
        }
        ThermalEntityRender.setShaderColor(shader, "green", 1.0f - (float)(8.0 / currentDistance));
        ThermalEntityRender.setShaderColor(shader, "alpha", 1.0f);
    };

    ThermalEntityRender() {
        VazkiiShaderHelper.initShader("", "/assets/rendertoolkit/shaders/program/thermal_color.fsh", shaderIndex -> {
            this.thermalColorShader = shaderIndex;
        });
    }

    private static void setShaderColor(int shader, String name, float val) {
        ARBShaderObjects.glUniform1fARB((int)OpenGlHelper.func_153194_a((int)shader, (CharSequence)name), (float)val);
    }

    @SubscribeEvent
    public void preRender(RenderLivingEvent.Pre<EntityLivingBase> event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getEntity().equals((Object)mc.field_71439_g)) {
            return;
        }
        boolean bl = isOptifineSpecialCase = renderToolkit.Optifine && OptifineHelper.isShaderActive();
        if (isOptifineSpecialCase && OptifineHelper.isShadowPass()) {
            return;
        }
        fastRenderEnabled = !isOptifineSpecialCase && renderToolkit.Optifine && OptifineHelper.isFastRenderEnabled();
        boolean bl2 = overlayVisible = mc.field_71474_y.field_74320_O == 0 && !mc.field_71474_y.field_74319_N;
        if (!overlayVisible) {
            return;
        }
        isDead = false;
        if (event.getEntity() instanceof EntityMob) {
            switch (event.getEntity().func_70668_bt()) {
                case UNDEFINED: 
                case ARTHROPOD: {
                    break;
                }
                case UNDEAD: 
                case ILLAGER: {
                    isDead = !event.getEntity().func_70027_ad();
                }
            }
        }
        currentDistance = event.getEntity().func_174791_d().func_72438_d(mc.field_71439_g.func_174791_d());
        if (isOptifineSpecialCase) {
            OptifineHelper.releaseShaderProgram();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        VazkiiShaderHelper.useShader(this.thermalColorShader, callback);
        ShaderHelper.thermalEntityRendererBlur.func_147706_e().func_177066_a("in").func_147610_a(true);
        if (isOptifineSpecialCase) {
            OptifineHelper.bindOptifineDepthBuffer();
        }
    }

    @SubscribeEvent
    public void postRender(RenderLivingEvent.Post<EntityLivingBase> event) {
        if (isOptifineSpecialCase && OptifineHelper.isShadowPass()) {
            return;
        }
        VazkiiShaderHelper.releaseShader();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        if (isOptifineSpecialCase) {
            OptifineHelper.bindOptifineFramebuffer();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderFogEvent(EntityViewRenderEvent.FogDensity event) {
        if (!overlayVisible) {
            return;
        }
        event.setDensity(0.03f);
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderFogEvent(EntityViewRenderEvent.FogColors event) {
        if (!overlayVisible) {
            return;
        }
        event.setRed(0.2f);
        event.setGreen(0.4f);
        event.setBlue(0.85f);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        ShaderHelper.renderFastRenderNotification();
        if (!overlayVisible) {
            return;
        }
        ShaderHelper.render((RenderGameOverlayEvent)evt);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147110_a().func_147610_a(true);
        if (isOptifineSpecialCase) {
            OptifineHelper.bindOptifineDepthBuffer();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        mc.field_71460_t.func_78478_c();
    }
}

