/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.guitoolkit.client.widget;

import ben_mkiv.rendertoolkit.common.widgets.component.face.Box2D;
import li.cil.oc.api.internal.TextBuffer;
import li.cil.oc.client.renderer.TextBufferRenderCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class TextBufferGUI {
    static Box2D background = new Box2D();
    public final int padding = 2;
    public float scaleToWidth = 1.0f;
    public float renderWidth;
    public float renderHeight;

    public abstract TextBuffer get();

    public TextBufferGUI() {
        TextBufferGUI.background.WidgetModifierList.addColor(0.0f, 0.0f, 0.0f, 1.0f);
        TextBufferGUI.background.WidgetModifierList.addColor(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.get() == null) {
            return;
        }
    }

    public void render(int x, int y, int width, double scale) {
        if (this.get() == null) {
            return;
        }
        this.renderWidth = this.getRenderWidth(Integer.MAX_VALUE);
        this.renderHeight = this.getRenderHeight(Math.round(this.renderWidth));
        background.setSize(this.renderWidth + 4.0f, this.renderHeight + 4.0f);
        this.scaleToWidth = this.getRenderScale(width);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        if ((double)Math.abs(this.scaleToWidth) > 1.01) {
            GL11.glScalef((float)this.scaleToWidth, (float)this.scaleToWidth, (float)1.0f);
        }
        background.getRenderable().render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, new Vec3d(0.0, 0.0, 0.0), 0L);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)2.0, (double)2.0, (double)0.0);
        this.get().renderText();
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
        GL11.glDisable((int)3042);
    }

    float getRenderScale(float width) {
        return width / this.renderWidth;
    }

    public int getRenderWidth(int maxWidth) {
        int w = Math.min(maxWidth, TextBufferRenderCache.renderer().charRenderWidth() * this.get().getWidth());
        return w;
    }

    public int getRenderHeight(int maxWidth) {
        int h = Math.round(this.getRenderScale(maxWidth) * (float)TextBufferRenderCache.renderer().charRenderHeight() * (float)this.get().getHeight());
        return h;
    }
}

