/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.guitoolkit.client.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SliderButton {
    private ResourceLocation texture = new ResourceLocation("opencomputers", "textures/gui/button_scroll.png");
    private int w;
    private int h;
    private int maxh;
    private int posx;
    private int posy;
    private int slidery;
    private boolean activated = false;
    private int maxsteps = 0;
    private int scroll;
    private boolean update = false;

    public SliderButton(int posx, int posy, int w, int h, int maxh) {
        this.w = w;
        this.h = h;
        this.maxh = maxh;
        this.posx = posx;
        this.posy = posy;
        this.slidery = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSlider(float zLevel, boolean highlight) {
        Tessellator tes = Tessellator.func_178181_a();
        double v0 = highlight ? 0.5 : 0.0;
        double v1 = v0 + 0.5;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        RenderHelper.func_74518_a();
        BufferBuilder vertexbuffer = tes.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(this.posx + this.w), (double)(this.posy + this.h + this.slidery), (double)zLevel).func_187315_a(1.0, v1).func_181675_d();
        vertexbuffer.func_181662_b((double)(this.posx + this.w), (double)(this.posy + this.slidery), (double)zLevel).func_187315_a(1.0, v0).func_181675_d();
        vertexbuffer.func_181662_b((double)this.posx, (double)(this.posy + this.slidery), (double)zLevel).func_187315_a(0.0, v0).func_181675_d();
        vertexbuffer.func_181662_b((double)this.posx, (double)(this.posy + this.h + this.slidery), (double)zLevel).func_187315_a(0.0, v1).func_181675_d();
        tes.func_78381_a();
        RenderHelper.func_74519_b();
    }

    public boolean isMouseHoverBox(int mx, int my) {
        return mx >= this.posx - 1 && mx < this.posx + this.w + 1 && my >= this.posy - 1 && my < this.posy + this.maxh + 1;
    }

    public boolean isMouseHoverButton(int mx, int my) {
        return mx >= this.posx - 1 && mx < this.posx + this.w + 1 && my >= this.posy + this.slidery - 1 && my < this.posy + this.slidery + this.h + 1;
    }

    public void scrollMouse(int my) {
        this.scrollTo((int)Math.round(((double)(my - this.posy + 1) - 6.5) * (double)(this.maxsteps - 1) / ((double)this.maxh - 13.0)));
    }

    public void scrollTo(int pos) {
        this.scroll = pos < 0 ? 0 : (pos > this.maxsteps ? this.maxsteps : pos);
        this.slidery = this.maxsteps < 1 ? 0 : (this.maxh - this.h - 2) * this.scroll / this.maxsteps;
        this.update = true;
    }

    public int getScroll() {
        return this.scroll;
    }

    public void scrollDown() {
        this.scrollTo(this.scroll + 1);
    }

    public void scrollUp() {
        this.scrollTo(this.scroll - 1);
    }

    public void setActive(boolean state) {
        this.activated = state;
    }

    public boolean isActive() {
        return this.activated;
    }

    public int getMaxsteps() {
        return this.maxsteps;
    }

    public void setMaxsteps(int maxsteps) {
        if (maxsteps < 0) {
            maxsteps = 0;
        }
        this.maxsteps = maxsteps;
    }

    public boolean hasUpdate() {
        return this.update;
    }

    public void doneUpdate() {
        this.update = false;
    }
}

