/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.commons0815.utils;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import li.cil.oc.api.Items;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUtil {
    public static ItemStack getOCItemStack(String name) {
        try {
            ItemStack stack = Items.get((String)name.toLowerCase()).createItemStack(1);
            return stack;
        }
        catch (Exception exception) {
            return ItemStack.field_190927_a;
        }
    }

    public static void dropInventory(IInventory inventory, Entity entity) {
        if (entity == null) {
            return;
        }
        ItemUtil.dropInventory(inventory, entity.field_70170_p, entity.func_180425_c());
    }

    public static void dropInventory(IInventory inventory, World world, BlockPos pos) {
        if (inventory == null) {
            return;
        }
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            drop.add(inventory.func_70301_a(i));
        }
        ItemUtil.dropItemList(drop, world, pos, true);
    }

    public static void dropItemList(ArrayList<ItemStack> items, World world, BlockPos pos, boolean motion) {
        for (ItemStack stack : items) {
            ItemUtil.dropItem(stack, world, pos, motion);
        }
    }

    public static void dropItemList(NonNullList<ItemStack> items, World world, BlockPos pos, boolean motion) {
        for (ItemStack stack : items) {
            ItemUtil.dropItem(stack, world, pos, motion);
        }
    }

    public static void dropItem(ItemStack stack, World world, BlockPos pos, boolean motion) {
        ItemUtil.dropItem(stack, world, pos, motion, 10);
    }

    public static void dropItem(ItemStack stack, World world, BlockPos pos, boolean motion, int pickupDelay) {
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77976_d() <= 0 || stack.func_190926_b()) {
            return;
        }
        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        entityitem.func_174867_a(pickupDelay);
        if (!motion) {
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)entityitem);
    }

    public static ItemStack suckItems(World world, int x, int y, int z, @Nonnull ItemStack filter, int num) {
        if (world.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        AxisAlignedBB box = new AxisAlignedBB(1.0, 1.0, 1.0, 16.0, 16.0, 16.0);
        box.func_72317_d((double)(x - 1), (double)(y - 1), (double)(z - 1));
        for (Entity ent : world.func_72872_a(EntityItem.class, box)) {
            if (!(ent instanceof EntityItem)) continue;
            ItemStack stack = ((EntityItem)ent).func_92059_d();
            if (!filter.equals(ItemStack.field_190927_a) && filter.func_77969_a(stack)) continue;
            ItemStack ret = stack.func_77946_l();
            ret.func_190920_e(Math.min(ret.func_77976_d(), num));
            stack.func_190918_g(ret.func_77976_d());
            if (stack.func_77976_d() < 1) {
                ent.func_70106_y();
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasDroppedItems(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        AxisAlignedBB box = new AxisAlignedBB(1.0, 1.0, 1.0, 16.0, 16.0, 16.0);
        box.func_72317_d((double)(x - 1), (double)(y - 1), (double)(z - 1));
        return !world.func_72872_a(EntityItem.class, box).isEmpty();
    }

    public static ItemStack sumItemStacks(ItemStack stackA, ItemStack stackB, boolean pull) {
        if (stackA == null || stackB == null) {
            return ItemStack.field_190927_a;
        }
        if (!stackA.func_77969_a(stackB)) {
            return ItemStack.field_190927_a;
        }
        ItemStack res = stackA.func_77946_l();
        int size = stackA.func_77976_d() + stackB.func_77976_d();
        size = Math.min(size, res.func_77976_d());
        res.func_190920_e(size);
        if (pull) {
            if (size >= stackA.func_77976_d()) {
                size -= stackA.func_77976_d();
                stackA.func_190920_e(0);
            } else {
                stackA.func_190918_g(size);
                size = 0;
            }
            if (size >= stackB.func_77976_d()) {
                size -= stackB.func_77976_d();
                stackB.func_190920_e(0);
            } else {
                stackB.func_190918_g(size);
                size = 0;
            }
        }
        return res;
    }
}

