/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.commons0815.utils;

import ben_mkiv.commons0815.utils.ItemUtil;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryUtil {
    public static int dropItemInventoryWorld(ItemStack stack, World world, BlockPos pos, EnumFacing access, int num) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof IInventory) {
            return InventoryUtil.putInventory(stack, (IInventory)entity, num, access);
        }
        return -1;
    }

    public static int suckItemInventoryWorld(IInventory target, int[] taccess, World world, BlockPos pos, EnumFacing access, int num) {
        return InventoryUtil.suckItemInventoryWorld(target, taccess, -1, world, pos, access, num);
    }

    public static int suckItemInventoryWorld(IInventory target, int[] taccess, int tfirst, World world, BlockPos pos, EnumFacing access, int num) {
        TileEntity entity = world.func_175625_s(pos);
        int moved = 0;
        if (entity instanceof IInventory) {
            for (int i = 0; i < taccess.length && moved < 1; ++i) {
                int num2;
                ItemStack filter = target.func_70301_a(taccess[i]);
                ItemStack mov = InventoryUtil.suckInventory(filter, (IInventory)entity, num2 = Math.min(num, InventoryUtil.spaceforItem(filter, target, taccess)), access);
                if (mov == null || mov.func_190916_E() <= 0) continue;
                moved = mov.func_190916_E();
                int[] slots = InventoryUtil.sortAccessible(target, taccess, mov);
                if (tfirst >= 0) {
                    slots = InventoryUtil.prioritizeAccessible(slots, tfirst);
                }
                InventoryUtil.putInventory(mov, target, 64, null, slots);
            }
            return moved;
        }
        return -1;
    }

    public static ItemStack suckInventory(ItemStack filter, IInventory inv, int maxnum, EnumFacing access) {
        int[] slots = InventoryUtil.getAccessible(inv, access);
        ItemStack pulled = null;
        for (int i = 0; i < inv.func_70302_i_() && maxnum > 0; ++i) {
            ItemStack slot = inv.func_70301_a(slots[i]);
            if (slot.func_190926_b() || filter != null && (filter == null || !filter.func_77969_a(slot)) || inv instanceof ISidedInventory && (!(inv instanceof ISidedInventory) || !((ISidedInventory)inv).func_180462_a(slots[i], slot, access))) continue;
            int stacksize = slot.func_190916_E();
            if (filter == null) {
                filter = slot.func_77946_l();
            }
            if (maxnum >= stacksize) {
                ItemStack stack = slot.func_77946_l();
                inv.func_70299_a(slots[i], null);
                pulled = pulled == null ? stack : ItemUtil.sumItemStacks(stack, pulled, false);
                maxnum -= stacksize;
                continue;
            }
            pulled = pulled == null ? slot.func_77979_a(maxnum) : ItemUtil.sumItemStacks(slot.func_77979_a(maxnum), pulled, false);
            maxnum = 0;
        }
        return pulled;
    }

    public static int putInventory(ItemStack stack, IInventory inv, int maxnum, EnumFacing access) {
        int[] slots = InventoryUtil.getAccessible(inv, access);
        slots = InventoryUtil.sortAccessible(inv, slots, stack);
        return InventoryUtil.putInventory(stack, inv, maxnum, access, slots);
    }

    public static int putInventory(ItemStack stack, IInventory inv, int maxnum, EnumFacing access, int[] slots) {
        int maxcount = maxnum;
        for (int i : slots) {
            ItemStack slot;
            if (inv instanceof ISidedInventory && !((ISidedInventory)inv).func_180462_a(slots[i], stack, access) || !inv.func_94041_b(slots[i], stack) || !(slot = inv.func_70301_a(slots[i])).func_190926_b() && !slot.func_190926_b() && slot.func_77969_a(stack)) continue;
            int stacksize = Math.min(stack.func_77976_d(), inv.func_70297_j_());
            int tstack = Math.min(stacksize, maxcount);
            if ((tstack = Math.min(tstack, stack.func_190916_E())) < 1) continue;
            if (!slot.func_190926_b()) {
                tstack = Math.min(tstack, stacksize - slot.func_190916_E());
                slot.func_190917_f(tstack);
                stack.func_190918_g(tstack);
            } else {
                ItemStack newstack = stack.func_77946_l();
                stack.func_190917_f(tstack);
                newstack.func_190918_g(tstack);
                inv.func_70299_a(slots[i], newstack);
            }
            maxcount -= tstack;
        }
        return maxnum - maxcount;
    }

    public static int[] sortAccessible(IInventory inv, int[] slots, ItemStack stack) {
        int i;
        int[] res = new int[slots.length];
        ArrayList<Integer> sort = new ArrayList<Integer>();
        for (i = 0; i < slots.length; ++i) {
            ItemStack slot = inv.func_70301_a(slots[i]);
            if (slot.func_190926_b() || !slot.func_77969_a(stack)) continue;
            sort.add(slots[i]);
        }
        for (i = 0; i < slots.length; ++i) {
            if (sort.contains(slots[i])) continue;
            sort.add(slots[i]);
        }
        for (i = 0; i < sort.size(); ++i) {
            if (i >= res.length) continue;
            res[i] = (Integer)sort.get(i);
        }
        return res;
    }

    public static int[] prioritizeAccessible(int[] slots, int slot) {
        int i;
        int[] res = new int[slots.length];
        ArrayList<Integer> sort = new ArrayList<Integer>();
        for (i = 0; i < slots.length; ++i) {
            if (slots[i] != slot) continue;
            for (int j = i; j < slots.length; ++j) {
                sort.add(slots[j]);
            }
        }
        for (i = 0; i < slots.length; ++i) {
            if (sort.contains(slots[i])) continue;
            sort.add(slots[i]);
        }
        for (i = 0; i < sort.size(); ++i) {
            if (i >= res.length) continue;
            res[i] = (Integer)sort.get(i);
        }
        return res;
    }

    public static int[] getAccessible(IInventory inv, EnumFacing access) {
        int[] sides = new int[inv.func_70302_i_()];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            sides[i] = i;
        }
        return sides;
    }

    public static int spaceforItem(ItemStack stack, IInventory inv, int[] access) {
        int space = 0;
        int maxstack = Math.min(stack == null ? 64 : stack.func_77976_d(), inv.func_70297_j_());
        for (int i = 0; i < access.length; ++i) {
            ItemStack slot = inv.func_70301_a(access[i]);
            if (slot == null) {
                space += maxstack;
                continue;
            }
            if (stack == null || !slot.func_77969_a(stack)) continue;
            space += Math.max(0, maxstack - slot.func_190916_E());
        }
        return space;
    }

    public static void addToPlayerInventory(ItemStack stack, EntityPlayer player) {
        if (stack != null) {
            if (player.field_71071_by.func_70441_a(stack)) {
                player.field_71071_by.func_70296_d();
                if (player.field_71070_bA != null) {
                    player.field_71070_bA.func_75142_b();
                }
            }
            if (stack.func_190916_E() > 0) {
                player.func_71019_a(stack, false);
            }
        }
    }
}

