/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.commons0815.utils;

import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtils {
    public static int transferEnergy(IEnergyStorage source, IEnergyStorage destination, int amount, boolean simulate) {
        int transfered = destination.receiveEnergy(amount = source.extractEnergy(Math.min(amount, source.getEnergyStored()), simulate), simulate);
        if (transfered < amount) {
            source.receiveEnergy(amount - transfered, simulate);
        }
        return transfered;
    }

    public static int transferEnergy(IEnergyStorage source, IEnergyStorage destination, boolean simulate) {
        return EnergyUtils.transferEnergy(source, destination, destination.getMaxEnergyStored() - destination.getEnergyStored(), simulate);
    }

    public static void setEnergyStored(IEnergyStorage storage, int energy) {
        int transfer = energy - storage.getEnergyStored();
        if (transfer > 0) {
            storage.receiveEnergy(transfer, false);
        } else if (transfer < 0) {
            storage.extractEnergy(-transfer, false);
        }
    }

    public static String formatValue(int value) {
        String suffix = "";
        double newValue = value;
        for (String s : new String[]{"k", "M", "G", "T"}) {
            if (newValue < 1000.0) break;
            suffix = s;
            newValue /= 1000.0;
        }
        return Math.round(newValue * 100.0) / 100L + suffix;
    }
}

