/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiSchematicSave;
import fi.dy.masa.litematica.mixin.IMixinItemBlockSpecial;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.scheduler.tasks.TaskDeleteArea;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblock;
import fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextInput;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class SchematicUtils {
    private static long areaMovedTime;

    public static boolean saveSchematic(boolean inMemoryOnly) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                String title = "litematica.gui.title.schematic_projects.save_new_version";
                SchematicProject project = DataManager.getSchematicProjectsManager().getCurrentProject();
                GuiTextInput gui = new GuiTextInput(512, title, project.getCurrentVersionName(), GuiUtils.getCurrentScreen(), (IStringConsumerFeedback)new SchematicVersionCreator());
                GuiBase.openGui((GuiScreen)gui);
            } else if (inMemoryOnly) {
                String title = "litematica.gui.title.create_in_memory_schematic";
                GuiTextInput gui = new GuiTextInput(512, title, area.getName(), GuiUtils.getCurrentScreen(), (IStringConsumer)new GuiSchematicSave.InMemorySchematicCreator(area));
                GuiBase.openGui((GuiScreen)gui);
            } else {
                GuiSchematicSave gui = new GuiSchematicSave();
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((GuiScreen)gui);
            }
            return true;
        }
        return false;
    }

    public static void unloadCurrentlySelectedSchematic() {
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null) {
            SchematicHolder.getInstance().removeSchematic(placement.getSchematic());
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
        }
    }

    public static boolean breakSchematicBlock(Minecraft mc) {
        return SchematicUtils.setTargetedSchematicBlockState(mc, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean placeSchematicBlock(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos pos = info.pos.func_177972_a(info.side);
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            if (DataManager.getRenderLayerRange().isPositionWithinRange(pos) && world != null && world.func_175623_d(pos)) {
                return SchematicUtils.setTargetedSchematicBlockState(pos, info.stateNew);
            }
        }
        return true;
    }

    public static boolean replaceSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            EnumFacing playerFacingH = mc.field_71439_g.func_174811_aO();
            EnumFacing direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((EnumFacing)info.side, (EnumFacing)playerFacingH, (BlockPos)info.pos, (Vec3d)info.hitVec);
            if (direction == info.side) {
                direction = direction.func_176734_d();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(info.pos, direction);
            return SchematicUtils.setSchematicBlockStates(info.pos, posEnd, info.stateNew);
        }
        return false;
    }

    public static boolean replaceAllIdenticalSchematicBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            return SchematicUtils.setAllIdenticalSchematicBlockStates(info.pos, info.stateOriginal, info.stateNew);
        }
        return false;
    }

    public static boolean breakSchematicBlocks(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 20.0);
        if (wrapper != null) {
            RayTraceResult trace = wrapper.getRayTraceResult();
            BlockPos pos = trace.func_178782_a();
            EnumFacing playerFacingH = mc.field_71439_g.func_174811_aO();
            EnumFacing direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((EnumFacing)trace.field_178784_b, (EnumFacing)playerFacingH, (BlockPos)pos, (Vec3d)trace.field_72307_f);
            if (direction == trace.field_178784_b) {
                direction = direction.func_176734_d();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(pos, direction);
            return SchematicUtils.setSchematicBlockStates(pos, posEnd, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public static boolean breakAllIdenticalSchematicBlocks(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 20.0);
        if (wrapper != null) {
            RayTraceResult trace = wrapper.getRayTraceResult();
            BlockPos pos = trace.func_178782_a();
            IBlockState stateOriginal = SchematicWorldHandler.getSchematicWorld().func_180495_p(pos);
            return SchematicUtils.setAllIdenticalSchematicBlockStates(pos, stateOriginal, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    public static boolean placeSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            EnumFacing playerFacingH = mc.field_71439_g.func_174811_aO();
            EnumFacing direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((EnumFacing)info.side, (EnumFacing)playerFacingH, (BlockPos)info.pos, (Vec3d)info.hitVec);
            BlockPos posStart = info.pos.func_177972_a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().func_180495_p(posStart).func_185904_a() == Material.field_151579_a) {
                BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(posStart, direction);
                return SchematicUtils.setSchematicBlockStates(posStart, posEnd, info.stateNew);
            }
        }
        return false;
    }

    public static boolean fillAirWithBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos posStart = info.pos.func_177972_a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().func_180495_p(posStart).func_185904_a() == Material.field_151579_a) {
                return SchematicUtils.setAllIdenticalSchematicBlockStates(posStart, Blocks.field_150350_a.func_176223_P(), info.stateNew);
            }
        }
        return false;
    }

    @Nullable
    private static ReplacementInfo getTargetInfo(Minecraft mc) {
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (!stack.func_190926_b() && (stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof ItemBlockSpecial) || stack.func_190926_b() && ToolMode.REBUILD.getPrimaryBlock() != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 20.0, true);
            if (world != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                RayTraceResult trace = traceWrapper.getRayTraceResult();
                EnumFacing side = trace.field_178784_b;
                Vec3d hitVec = trace.field_72307_f;
                int meta = stack.func_77973_b().func_77647_b(stack.func_77960_j());
                BlockPos pos = trace.func_178782_a();
                IBlockState stateOriginal = world.func_180495_p(pos);
                IBlockState stateNew = Blocks.field_150350_a.func_176223_P();
                if (stack.func_77973_b() instanceof ItemBlock) {
                    stateNew = ((ItemBlock)stack.func_77973_b()).func_179223_d().getStateForPlacement((World)world, pos.func_177972_a(side), side, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, meta, (EntityLivingBase)mc.field_71439_g, EnumHand.MAIN_HAND);
                } else if (stack.func_77973_b() instanceof ItemBlockSpecial) {
                    stateNew = ((IMixinItemBlockSpecial)stack.func_77973_b()).getBlock().getStateForPlacement((World)world, pos.func_177972_a(side), side, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, 0, (EntityLivingBase)mc.field_71439_g, EnumHand.MAIN_HAND);
                } else if (ToolMode.REBUILD.getPrimaryBlock() != null) {
                    stateNew = ToolMode.REBUILD.getPrimaryBlock();
                }
                return new ReplacementInfo(pos, side, hitVec, stateOriginal, stateNew);
            }
        }
        return null;
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, EnumFacing direction) {
        return SchematicUtils.getReplacementBoxEndPos(startPos, direction, 10000);
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, EnumFacing direction, int maxBlocks) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        LayerRange range = DataManager.getRenderLayerRange();
        IBlockState stateStart = world.func_180495_p(startPos);
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(startPos);
        while (maxBlocks-- > 0) {
            posMutable.func_189536_c(direction);
            if (range.isPositionWithinRange((BlockPos)posMutable) && world.func_72863_F().func_191062_e(posMutable.func_177958_n() >> 4, posMutable.func_177952_p() >> 4) && world.func_180495_p((BlockPos)posMutable) == stateStart) continue;
            posMutable.func_189536_c(direction.func_176734_d());
            break;
        }
        return posMutable.func_185334_h();
    }

    public static boolean setTargetedSchematicBlockState(Minecraft mc, IBlockState state) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 20.0, true);
        if (world != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            RayTraceResult trace = traceWrapper.getRayTraceResult();
            BlockPos pos = trace.func_178782_a();
            return SchematicUtils.setTargetedSchematicBlockState(pos, state);
        }
        return false;
    }

    private static boolean setTargetedSchematicBlockState(BlockPos pos, IBlockState state) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)pos)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    LitematicaSchematic schematic = placement.getSchematic();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                    BlockPos posSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(pos, schematic, regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posSchematic != null) {
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        IBlockState stateOriginal = container.get(posSchematic.func_177958_n(), posSchematic.func_177956_o(), posSchematic.func_177952_p());
                        SchematicMetadata metadata = schematic.getMetadata();
                        int totalBlocks = metadata.getTotalBlocks();
                        int increment = 0;
                        increment = stateOriginal.func_177230_c() != Blocks.field_150350_a ? (state.func_177230_c() != Blocks.field_150350_a ? 0 : -1) : (state.func_177230_c() != Blocks.field_150350_a ? 1 : 0);
                        container.set(posSchematic.func_177958_n(), posSchematic.func_177956_o(), posSchematic.func_177952_p(), state);
                        metadata.setTotalBlocks(totalBlocks += increment);
                        metadata.setTimeModifiedToNow();
                        metadata.setModifiedSinceSaved();
                        DataManager.getSchematicPlacementManager().markChunkForRebuild(new ChunkPos(cpos.func_177958_n(), cpos.func_177952_p()));
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setSchematicBlockStates(BlockPos posStart, BlockPos posEnd, IBlockState state) {
        if (posStart != null && posEnd != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)posStart)) continue;
                    String regionName = part.getSubRegionName();
                    SchematicPlacement schematicPlacement = part.getPlacement();
                    SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
                    LitematicaSchematic schematic = schematicPlacement.getSchematic();
                    LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                    BlockPos posStartSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posStart, schematic, regionName, schematicPlacement, placement, container);
                    BlockPos posEndSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posEnd, schematic, regionName, schematicPlacement, placement, container);
                    if (posStartSchematic != null && posEndSchematic != null) {
                        BlockPos posMin = PositionUtils.getMinCorner(posStartSchematic, posEndSchematic);
                        BlockPos posMax = PositionUtils.getMaxCorner(posStartSchematic, posEndSchematic);
                        int minX = Math.max(posMin.func_177958_n(), 0);
                        int minY = Math.max(posMin.func_177956_o(), 0);
                        int minZ = Math.max(posMin.func_177952_p(), 0);
                        int maxX = Math.min(posMax.func_177958_n(), container.getSize().func_177958_n() - 1);
                        int maxY = Math.min(posMax.func_177956_o(), container.getSize().func_177956_o() - 1);
                        int maxZ = Math.min(posMax.func_177952_p(), container.getSize().func_177952_p() - 1);
                        int totalBlocks = schematic.getMetadata().getTotalBlocks();
                        int increment = 0;
                        state = SchematicUtils.getUntransformedBlockState(state, schematicPlacement, regionName);
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                for (int x = minX; x <= maxX; ++x) {
                                    IBlockState stateOriginal = container.get(x, y, z);
                                    increment = stateOriginal.func_177230_c() != Blocks.field_150350_a ? (state.func_177230_c() != Blocks.field_150350_a ? 0 : -1) : (state.func_177230_c() != Blocks.field_150350_a ? 1 : 0);
                                    totalBlocks += increment;
                                    container.set(x, y, z, state);
                                }
                            }
                        }
                        SchematicMetadata metadata = schematic.getMetadata();
                        metadata.setTotalBlocks(totalBlocks);
                        metadata.setTimeModifiedToNow();
                        metadata.setModifiedSinceSaved();
                        DataManager.getSchematicPlacementManager().markAllPlacementsOfSchematicForRebuild(schematic);
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllIdenticalSchematicBlockStates(BlockPos posStart, IBlockState stateOriginal, IBlockState stateNew) {
        if (posStart != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)posStart)) continue;
                    if (SchematicUtils.replaceAllIdenticalBlocks(manager, part, stateOriginal, stateNew)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean replaceAllIdenticalBlocks(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, IBlockState stateOriginalIn, IBlockState stateNewIn) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematic.getMetadata().getTotalBlocks();
        int increment = 0;
        increment = stateOriginalIn.func_177230_c() != Blocks.field_150350_a ? (stateNewIn.func_177230_c() != Blocks.field_150350_a ? 0 : -1) : (stateNewIn.func_177230_c() != Blocks.field_150350_a ? 1 : 0);
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            BlockPos regionSize = schematic.getAreaSize(regionName);
            if (container == null || placement == null || regionSize == null) continue;
            Pair<Vec3i, Vec3i> pair = SchematicUtils.getLayerRangeClampedSubRegion(range, schematicPlacement, placement, (Vec3i)regionSize);
            if (pair == null) {
                return false;
            }
            Vec3i containerStart = (Vec3i)pair.getLeft();
            Vec3i containerEnd = (Vec3i)pair.getRight();
            Vec3i size = container.getSize();
            int startX = containerStart.func_177958_n();
            int startY = containerStart.func_177956_o();
            int startZ = containerStart.func_177952_p();
            int endX = containerEnd.func_177958_n();
            int endY = containerEnd.func_177956_o();
            int endZ = containerEnd.func_177952_p();
            if (startX < 0 || startY < 0 || startZ < 0 || endX >= size.func_177958_n() || endY >= size.func_177956_o() || endZ >= size.func_177952_p()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
                return false;
            }
            IBlockState stateOriginal = SchematicUtils.getUntransformedBlockState(stateOriginalIn, schematicPlacement, regionName);
            IBlockState stateNew = SchematicUtils.getUntransformedBlockState(stateNewIn, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        if (container.get(x, y, z) != stateOriginal) continue;
                        container.set(x, y, z, stateNew);
                        totalBlocks += increment;
                    }
                }
            }
        }
        SchematicMetadata metadata = schematic.getMetadata();
        metadata.setTotalBlocks(totalBlocks);
        metadata.setTimeModifiedToNow();
        metadata.setModifiedSinceSaved();
        return true;
    }

    public static void moveCurrentlySelectedWorldRegionToLookingDirection(int amount, EntityPlayer player, Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            BlockPos pos = area.getEffectiveOrigin().func_177967_a(EntityUtils.getClosestLookingDirection((Entity)player), amount);
            SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, mc);
        }
    }

    public static void moveCurrentlySelectedWorldRegionTo(BlockPos pos, Minecraft mc) {
        if (mc.field_71439_g == null || !mc.field_71439_g.field_71075_bZ.field_75098_d) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
            return;
        }
        TaskScheduler scheduler = TaskScheduler.getServerInstanceIfExistsOrClient();
        long currentTime = System.currentTimeMillis();
        if (currentTime - areaMovedTime < 400L || scheduler.hasTask(TaskSaveSchematic.class) || scheduler.hasTask(TaskDeleteArea.class) || scheduler.hasTask(TaskPasteSchematicSetblock.class) || scheduler.hasTask(TaskPasteSchematicDirect.class)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.move.pending_tasks", (Object[])new Object[0]);
            return;
        }
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LayerRange range = DataManager.getRenderLayerRange().copy();
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, "");
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, true);
            taskSave.disableCompletionMessage();
            areaMovedTime = System.currentTimeMillis();
            taskSave.setCompletionListener(() -> {
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, pos, "-", true, true);
                DataManager.getSchematicPlacementManager().addSchematicPlacement(placement, false);
                TaskDeleteArea taskDelete = new TaskDeleteArea(area.getAllSubRegionBoxes(), true);
                taskDelete.disableCompletionMessage();
                areaMovedTime = System.currentTimeMillis();
                taskDelete.setCompletionListener(() -> {
                    TaskBase taskPaste = mc.func_71356_B() ? new TaskPasteSchematicDirect(placement, range) : new TaskPasteSchematicSetblock(placement, range, false);
                    taskPaste.disableCompletionMessage();
                    areaMovedTime = System.currentTimeMillis();
                    taskPaste.setCompletionListener(() -> {
                        SchematicHolder.getInstance().removeSchematic(schematic);
                        area.moveEntireSelectionTo(pos, false);
                        areaMovedTime = System.currentTimeMillis();
                    });
                    scheduler.scheduleTask(taskPaste, 1);
                });
                scheduler.scheduleTask(taskDelete, 1);
            });
            scheduler.scheduleTask(taskSave, 1);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    public static void cloneSelectionArea(Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, mc.field_71439_g.func_70005_c_());
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, true);
            taskSave.disableCompletionMessage();
            taskSave.setCompletionListener(() -> {
                SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
                String name = schematic.getMetadata().getName();
                BlockPos origin = RayTraceUtils.getTargetedPosition((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, 6.0, false);
                if (origin == null) {
                    origin = new BlockPos((Entity)mc.field_71439_g);
                }
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, origin, name, true, true);
                manager.addSchematicPlacement(placement, false);
                manager.setSelectedSchematicPlacement(placement);
                if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                    DataManager.setToolMode(ToolMode.PASTE_SCHEMATIC);
                }
            });
            TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(taskSave, 10);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    @Nullable
    public static BlockPos getSchematicContainerPositionFromWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement, LitematicaBlockStateContainer container) {
        BlockPos boxMinRel = SchematicUtils.getReverseTransformedWorldPosition(worldPos, schematic, schematicPlacement, regionPlacement, (Vec3i)schematic.getAreaSize(regionName));
        if (boxMinRel == null) {
            return null;
        }
        int startX = boxMinRel.func_177958_n();
        int startY = boxMinRel.func_177956_o();
        int startZ = boxMinRel.func_177952_p();
        Vec3i size = container.getSize();
        return new BlockPos(MathHelper.func_76125_a((int)startX, (int)0, (int)(size.func_177958_n() - 1)), MathHelper.func_76125_a((int)startY, (int)0, (int)(size.func_177956_o() - 1)), MathHelper.func_76125_a((int)startZ, (int)0, (int)(size.func_177952_p() - 1)));
    }

    @Nullable
    private static BlockPos getReverseTransformedWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement, Vec3i regionSize) {
        BlockPos origin = schematicPlacement.getOrigin();
        BlockPos regionPos = regionPlacement.getPos();
        BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize(regionSize).func_177971_a((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos relPos = new BlockPos(worldPos.func_177958_n() - origin.func_177958_n() - regionPosTransformed.func_177958_n(), worldPos.func_177956_o() - origin.func_177956_o() - regionPosTransformed.func_177956_o(), worldPos.func_177952_p() - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, regionPlacement.getMirror(), regionPlacement.getRotation());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        relPos = relPos.func_177973_b((Vec3i)posMinRel.func_177973_b((Vec3i)regionPos));
        return relPos;
    }

    @Nullable
    public static Pair<Vec3i, Vec3i> getLayerRangeClampedSubRegion(LayerRange range, SchematicPlacement schematicPlacement, SubRegionPlacement placement, Vec3i regionSize) {
        int minX = range.getClampedValue(LayerRange.getWorldMinValueForAxis((EnumFacing.Axis)EnumFacing.Axis.X), EnumFacing.Axis.X);
        int minY = range.getClampedValue(LayerRange.getWorldMinValueForAxis((EnumFacing.Axis)EnumFacing.Axis.Y), EnumFacing.Axis.Y);
        int minZ = range.getClampedValue(LayerRange.getWorldMinValueForAxis((EnumFacing.Axis)EnumFacing.Axis.Z), EnumFacing.Axis.Z);
        int maxX = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((EnumFacing.Axis)EnumFacing.Axis.X), EnumFacing.Axis.X);
        int maxY = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((EnumFacing.Axis)EnumFacing.Axis.Y), EnumFacing.Axis.Y);
        int maxZ = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((EnumFacing.Axis)EnumFacing.Axis.Z), EnumFacing.Axis.Z);
        BlockPos posMinRange = new BlockPos(minX, minY, minZ);
        BlockPos posMaxRange = new BlockPos(maxX, maxY, maxZ);
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        BlockPos pos1 = SchematicUtils.getReverseTransformedWorldPosition(posMinRange, schematic, schematicPlacement, placement, regionSize);
        BlockPos pos2 = SchematicUtils.getReverseTransformedWorldPosition(posMaxRange, schematic, schematicPlacement, placement, regionSize);
        if (pos1 == null || pos2 == null) {
            return null;
        }
        BlockPos posMinReversed = PositionUtils.getMinCorner(pos1, pos2);
        BlockPos posMaxReversed = PositionUtils.getMaxCorner(pos1, pos2);
        int startX = Math.max(posMinReversed.func_177958_n(), 0);
        int startY = Math.max(posMinReversed.func_177956_o(), 0);
        int startZ = Math.max(posMinReversed.func_177952_p(), 0);
        int endX = Math.min(posMaxReversed.func_177958_n(), Math.abs(regionSize.func_177958_n()) - 1);
        int endY = Math.min(posMaxReversed.func_177956_o(), Math.abs(regionSize.func_177956_o()) - 1);
        int endZ = Math.min(posMaxReversed.func_177952_p(), Math.abs(regionSize.func_177952_p()) - 1);
        return Pair.of((Object)new Vec3i(startX, startY, startZ), (Object)new Vec3i(endX, endY, endZ));
    }

    public static IBlockState getUntransformedBlockState(IBlockState state, SchematicPlacement schematicPlacement, String subRegionName) {
        SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(subRegionName);
        if (placement != null) {
            Rotation rotationCombined = PositionUtils.getReverseRotation(schematicPlacement.getRotation().func_185830_a(placement.getRotation()));
            Mirror mirrorMain = schematicPlacement.getMirror();
            Mirror mirrorSub = placement.getMirror();
            if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
                Mirror mirror = mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
            }
            if (rotationCombined != Rotation.NONE) {
                state = state.func_185907_a(rotationCombined);
            }
            if (mirrorSub != Mirror.NONE) {
                state = state.func_185902_a(mirrorSub);
            }
            if (mirrorMain != Mirror.NONE) {
                state = state.func_185902_a(mirrorMain);
            }
        }
        return state;
    }

    public static class SchematicVersionCreator
    implements IStringConsumerFeedback {
        public boolean setString(String string) {
            return DataManager.getSchematicProjectsManager().commitNewVersion(string);
        }
    }

    private static class ReplacementInfo {
        public final BlockPos pos;
        public final EnumFacing side;
        public final Vec3d hitVec;
        public final IBlockState stateOriginal;
        public final IBlockState stateNew;

        public ReplacementInfo(BlockPos pos, EnumFacing side, Vec3d hitVec, IBlockState stateOriginal, IBlockState stateNew) {
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.stateOriginal = stateOriginal;
            this.stateNew = stateNew;
        }
    }
}

