/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.base.Predicate;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityUtils {
    public static final Predicate<Entity> NOT_PLAYER = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return !(entity instanceof EntityPlayer);
        }
    };

    public static boolean hasToolItem(EntityLivingBase entity) {
        return EntityUtils.hasToolItemInHand(entity, EnumHand.MAIN_HAND) || EntityUtils.hasToolItemInHand(entity, EnumHand.OFF_HAND);
    }

    public static boolean hasToolItemInHand(EntityLivingBase entity, EnumHand hand) {
        ItemStack toolItem = DataManager.getToolItem();
        if (toolItem.func_190926_b()) {
            return entity.func_184614_ca().func_190926_b();
        }
        ItemStack stackHand = entity.func_184586_b(hand);
        if (ItemStack.func_185132_d((ItemStack)toolItem, (ItemStack)stackHand)) {
            return !toolItem.func_77942_o() || ItemStack.func_77970_a((ItemStack)toolItem, (ItemStack)stackHand);
        }
        return false;
    }

    @Nullable
    public static EnumHand getUsedHandForItem(EntityPlayer player, ItemStack stack) {
        EnumHand hand = null;
        if (InventoryUtils.areStacksEqual((ItemStack)player.func_184614_ca(), (ItemStack)stack)) {
            hand = EnumHand.MAIN_HAND;
        } else if (player.func_184614_ca().func_190926_b() && InventoryUtils.areStacksEqual((ItemStack)player.func_184592_cb(), (ItemStack)stack)) {
            hand = EnumHand.OFF_HAND;
        }
        return hand;
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static EnumFacing getHorizontalLookingDirection(Entity entity) {
        return EnumFacing.func_176733_a((double)entity.field_70177_z);
    }

    public static EnumFacing getVerticalLookingDirection(Entity entity) {
        return entity.field_70125_A > 0.0f ? EnumFacing.DOWN : EnumFacing.UP;
    }

    public static EnumFacing getClosestLookingDirection(Entity entity) {
        if (entity.field_70125_A > 60.0f) {
            return EnumFacing.DOWN;
        }
        if (-entity.field_70125_A > 60.0f) {
            return EnumFacing.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    private static Entity createEntityFromNBTSingle(NBTTagCompound nbt, World world) {
        try {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
            if (entity != null) {
                entity.func_184221_a(UUID.randomUUID());
            }
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Entity createEntityAndPassengersFromNBT(NBTTagCompound nbt, World world) {
        Entity entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.func_150297_b("Passengers", 9)) {
            NBTTagList taglist = nbt.func_150295_c("Passengers", 10);
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                Entity passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.func_150305_b(i), world);
                if (passenger == null) continue;
                passenger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(Entity entity, World world) {
        if (world.func_72838_d(entity) && entity.func_184207_aI()) {
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70107_b(entity.field_70165_t, entity.field_70163_u + entity.func_70042_X() + passenger.func_70033_W(), entity.field_70161_v);
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static List<Entity> getEntitiesWithinSubRegion(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.func_177982_a(-1, -1, -1), schematicPlacement, placement).func_177971_a((Vec3i)regionPosRelTransformed).func_177971_a((Vec3i)origin);
        BlockPos regionPosAbs = regionPosRelTransformed.func_177971_a((Vec3i)origin);
        AxisAlignedBB bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.func_175674_a(null, bb, null);
    }

    public static boolean shouldPickBlock(EntityPlayer player) {
        return Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && EntityUtils.areSchematicBlocksCurrentlyRendered() && (!Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue() || !EntityUtils.hasToolItem((EntityLivingBase)player));
    }

    public static boolean isSchematicCurrentlyRendered() {
        return Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
    }

    public static boolean areSchematicBlocksCurrentlyRendered() {
        return EntityUtils.isSchematicCurrentlyRendered() && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
    }
}

