/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.litematica.schematic.container.LitematicaBitArray;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStatePaletteHashMap;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStatePaletteLinear;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LitematicaBlockStateContainer
implements ILitematicaBlockStatePaletteResizer {
    public static final IBlockState AIR_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
    protected LitematicaBitArray storage;
    protected ILitematicaBlockStatePalette palette;
    protected final int sizeX;
    protected final int sizeY;
    protected final int sizeZ;
    protected final int sizeLayer;
    protected int bits;

    public LitematicaBlockStateContainer(int sizeX, int sizeY, int sizeZ) {
        this(sizeX, sizeY, sizeZ, 2, null);
    }

    private LitematicaBlockStateContainer(int sizeX, int sizeY, int sizeZ, int bits, long[] backingLongArray) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeLayer = sizeX * sizeZ;
        this.setBits(bits, backingLongArray);
    }

    public Vec3i getSize() {
        return new Vec3i(this.sizeX, this.sizeY, this.sizeZ);
    }

    public IBlockState get(int x, int y, int z) {
        IBlockState state = this.palette.getBlockState(this.storage.getAt(this.getIndex(x, y, z)));
        return state == null ? AIR_BLOCK_STATE : state;
    }

    public void set(int x, int y, int z, IBlockState state) {
        int id = this.palette.idFor(state);
        this.storage.setAt(this.getIndex(x, y, z), id);
    }

    protected void set(int index, IBlockState state) {
        int id = this.palette.idFor(state);
        this.storage.setAt(index, id);
    }

    protected int getIndex(int x, int y, int z) {
        return y * this.sizeLayer + z * this.sizeX + x;
    }

    protected void setBits(int bitsIn, long[] backingLongArray) {
        if (bitsIn != this.bits) {
            this.bits = bitsIn;
            if (this.bits <= 4) {
                this.bits = Math.max(2, this.bits);
                this.palette = new LitematicaBlockStatePaletteLinear(this.bits, this);
            } else {
                this.palette = new LitematicaBlockStatePaletteHashMap(this.bits, this);
            }
            this.palette.idFor(AIR_BLOCK_STATE);
            this.storage = backingLongArray != null ? new LitematicaBitArray(this.bits, this.sizeX * this.sizeY * this.sizeZ, backingLongArray) : new LitematicaBitArray(this.bits, this.sizeX * this.sizeY * this.sizeZ);
        }
    }

    @Override
    public int onResize(int bits, IBlockState state) {
        LitematicaBitArray bitArray = this.storage;
        ILitematicaBlockStatePalette statePaletteOld = this.palette;
        this.setBits(bits, null);
        for (int id = 0; id < bitArray.size(); ++id) {
            IBlockState stateTmp = statePaletteOld.getBlockState(bitArray.getAt(id));
            if (stateTmp == null) continue;
            this.set(id, stateTmp);
        }
        return this.palette.idFor(state);
    }

    public long[] getBackingLongArray() {
        return this.storage.getBackingLongArray();
    }

    public ILitematicaBlockStatePalette getPalette() {
        return this.palette;
    }

    public static LitematicaBlockStateContainer createFrom(NBTTagList palette, long[] blockStates, BlockPos size) {
        int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(palette.func_74745_c() - 1));
        LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), bits, blockStates);
        container.palette.readFromNBT(palette);
        return container;
    }
}

