/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.NBTUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class SchematicaSchematic {
    public static final String FILE_EXTENSION = ".schematic";
    private LitematicaBlockStateContainer blocks;
    private Block[] palette;
    private Map<BlockPos, NBTTagCompound> tiles = new HashMap<BlockPos, NBTTagCompound>();
    private List<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
    private Vec3i size = Vec3i.field_177959_e;
    private String fileName;

    private SchematicaSchematic() {
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Map<BlockPos, NBTTagCompound> getTiles() {
        return this.tiles;
    }

    public List<LitematicaSchematic.EntityInfo> getEntities() {
        ArrayList<LitematicaSchematic.EntityInfo> entityList = new ArrayList<LitematicaSchematic.EntityInfo>();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound entityData = this.entities.get(i);
            Vec3d posVec = NBTUtils.readEntityPositionFromTag((NBTTagCompound)entityData);
            if (posVec == null || entityData.func_82582_d()) continue;
            entityList.add(new LitematicaSchematic.EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    public void placeSchematicToWorld(World world, BlockPos posStart, PlacementSettings placement, int setBlockStateFlags) {
        int width = this.size.func_177958_n();
        int height = this.size.func_177956_o();
        int length = this.size.func_177952_p();
        int numBlocks = width * height * length;
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size)) {
            int x;
            int z;
            int y;
            Block ignoredBlock = placement.func_186219_f();
            Rotation rotation = placement.func_186215_c();
            Mirror mirror = placement.func_186212_b();
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    for (x = 0; x < width; ++x) {
                        TileEntity te;
                        IBlockState state = this.blocks.get(x, y, z);
                        if (ignoredBlock != null && state.func_177230_c() == ignoredBlock) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        NBTTagCompound teNBT = this.tiles.get(pos);
                        pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
                        state = state.func_185902_a(mirror);
                        state = state.func_185907_a(rotation);
                        if (teNBT != null && (te = world.func_175625_s(pos)) != null) {
                            if (te instanceof IInventory) {
                                ((IInventory)te).func_174888_l();
                            }
                            world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 20);
                        }
                        if (!world.func_180501_a(pos, state, setBlockStateFlags) || teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                        teNBT.func_74768_a("x", pos.func_177958_n());
                        teNBT.func_74768_a("y", pos.func_177956_o());
                        teNBT.func_74768_a("z", pos.func_177952_p());
                        try {
                            te.func_145839_a(teNBT);
                            te.func_189668_a(mirror);
                            te.func_189667_a(rotation);
                            continue;
                        }
                        catch (Exception e) {
                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                        }
                    }
                }
            }
            if ((setBlockStateFlags & 1) != 0) {
                for (y = 0; y < height; ++y) {
                    for (z = 0; z < length; ++z) {
                        for (x = 0; x < width; ++x) {
                            TileEntity te;
                            BlockPos pos = new BlockPos(x, y, z);
                            NBTTagCompound teNBT = this.tiles.get(pos);
                            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
                            world.func_175722_b(pos, world.func_180495_p(pos).func_177230_c(), false);
                            if (teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                            te.func_70296_d();
                        }
                    }
                }
            }
            if (!placement.func_186221_e()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    public void placeSchematicDirectlyToChunks(World world, BlockPos posStart, PlacementSettings placement) {
        int width = this.size.func_177958_n();
        int height = this.size.func_177956_o();
        int length = this.size.func_177952_p();
        int numBlocks = width * height * length;
        BlockPos posEnd = posStart.func_177971_a(this.size).func_177982_a(-1, -1, -1);
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size) && PositionUtils.arePositionsWithinWorld(world, posStart, posEnd)) {
            BlockPos posMin = PositionUtils.getMinCorner(posStart, posEnd);
            BlockPos posMax = PositionUtils.getMaxCorner(posStart, posEnd);
            Block ignoredBlock = placement.func_186219_f();
            Rotation rotation = placement.func_186215_c();
            Mirror mirror = placement.func_186212_b();
            int cxStart = posMin.func_177958_n() >> 4;
            int czStart = posMin.func_177952_p() >> 4;
            int cxEnd = posMax.func_177958_n() >> 4;
            int czEnd = posMax.func_177952_p() >> 4;
            for (int cz = czStart; cz <= czEnd; ++cz) {
                for (int cx = cxStart; cx <= cxEnd; ++cx) {
                    int xMinChunk = Math.max(cx << 4, posMin.func_177958_n());
                    int zMinChunk = Math.max(cz << 4, posMin.func_177952_p());
                    int xMaxChunk = Math.min((cx << 4) + 15, posMax.func_177958_n());
                    int zMaxChunk = Math.min((cz << 4) + 15, posMax.func_177952_p());
                    Chunk chunk = world.func_72964_e(cx, cz);
                    int y = posMin.func_177956_o();
                    for (int ySrc = 0; ySrc < height; ++ySrc) {
                        int z = zMinChunk;
                        int zSrc = zMinChunk - posStart.func_177952_p();
                        while (z <= zMaxChunk) {
                            int x = xMinChunk;
                            int xSrc = xMinChunk - posStart.func_177958_n();
                            while (x <= xMaxChunk) {
                                IBlockState state = this.blocks.get(xSrc, ySrc, zSrc);
                                if (state.func_177230_c() != ignoredBlock) {
                                    TileEntity te;
                                    BlockPos pos = new BlockPos(x, y, z);
                                    NBTTagCompound teNBT = this.tiles.get(pos);
                                    if (teNBT != null && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null) {
                                        if (te instanceof IInventory) {
                                            ((IInventory)te).func_174888_l();
                                        }
                                        world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 20);
                                    }
                                    chunk.func_177436_a(pos, state);
                                    if (teNBT != null && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null) {
                                        teNBT.func_74768_a("x", pos.func_177958_n());
                                        teNBT.func_74768_a("y", pos.func_177956_o());
                                        teNBT.func_74768_a("z", pos.func_177952_p());
                                        try {
                                            te.func_145839_a(teNBT);
                                            te.func_189668_a(mirror);
                                            te.func_189667_a(rotation);
                                        }
                                        catch (Exception e) {
                                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                                        }
                                    }
                                }
                                ++x;
                                ++xSrc;
                            }
                            ++z;
                            ++zSrc;
                        }
                        ++y;
                    }
                }
            }
            if (!placement.func_186221_e()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    private void addEntitiesToWorld(World world, BlockPos posStart, PlacementSettings placement) {
        Mirror mirror = placement.func_186212_b();
        Rotation rotation = placement.func_186215_c();
        for (NBTTagCompound tag : this.entities) {
            Vec3d relativePos = NBTUtils.readEntityPositionFromTag((NBTTagCompound)tag);
            Vec3d transformedRelativePos = PositionUtils.getTransformedPosition(relativePos, mirror, rotation);
            Vec3d realPos = transformedRelativePos.func_72441_c((double)posStart.func_177958_n(), (double)posStart.func_177956_o(), (double)posStart.func_177952_p());
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(tag, world);
            if (entity == null) continue;
            float rotationYaw = entity.func_184217_a(mirror);
            entity.func_70012_b(realPos.field_72450_a, realPos.field_72448_b, realPos.field_72449_c, rotationYaw += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public Map<BlockPos, String> getDataStructureBlocks(BlockPos posStart, PlacementSettings placement) {
        HashMap<BlockPos, String> map = new HashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, NBTTagCompound> entry : this.tiles.entrySet()) {
            NBTTagCompound tag = entry.getValue();
            if (!tag.func_74779_i("id").equals("minecraft:structure_block") || TileEntityStructure.Mode.valueOf((String)tag.func_74779_i("mode")) != TileEntityStructure.Mode.DATA) continue;
            BlockPos pos = entry.getKey();
            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vec3i)posStart);
            map.put(pos, tag.func_74779_i("metadata"));
        }
        return map;
    }

    private void readBlocksFromWorld(World world, BlockPos posStart, BlockPos size) {
        int startX = posStart.func_177958_n();
        int startY = posStart.func_177956_o();
        int startZ = posStart.func_177952_p();
        int endX = startX + size.func_177958_n();
        int endY = startY + size.func_177956_o();
        int endZ = startZ + size.func_177952_p();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        this.blocks = new LitematicaBlockStateContainer(size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
        this.tiles.clear();
        this.size = size;
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                for (int x = startX; x < endX; ++x) {
                    int relX = x - startX;
                    int relY = y - startY;
                    int relZ = z - startZ;
                    posMutable.func_181079_c(x, y, z);
                    IBlockState state = world.func_180495_p((BlockPos)posMutable);
                    this.blocks.set(relX, relY, relZ, state);
                    TileEntity te = world.func_175625_s((BlockPos)posMutable);
                    if (te == null) continue;
                    try {
                        NBTTagCompound nbt = te.func_189515_b(new NBTTagCompound());
                        nbt.func_74768_a("x", relX);
                        nbt.func_74768_a("y", relY);
                        nbt.func_74768_a("z", relZ);
                        this.tiles.put(new BlockPos(relX, relY, relZ), nbt);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("SchematicaSchematic: Exception while trying to store TileEntity data for block '{}' at {}", (Object)state, (Object)posMutable.toString(), (Object)e);
                    }
                }
            }
        }
    }

    private void readEntitiesFromWorld(World world, BlockPos posStart, BlockPos size) {
        this.entities.clear();
        List entities = world.func_72839_b(null, new AxisAlignedBB(posStart, posStart.func_177971_a((Vec3i)size)));
        for (Entity entity : entities) {
            NBTTagCompound tag;
            if (!entity.func_70039_c(tag = new NBTTagCompound())) continue;
            Vec3d pos = new Vec3d(entity.field_70165_t - (double)posStart.func_177958_n(), entity.field_70163_u - (double)posStart.func_177956_o(), entity.field_70161_v - (double)posStart.func_177952_p());
            NBTUtils.writeEntityPositionToTag((Vec3d)pos, (NBTTagCompound)tag);
            this.entities.add(tag);
        }
    }

    public static SchematicaSchematic createFromWorld(World world, BlockPos posStart, BlockPos size, boolean ignoreEntities) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        schematic.readBlocksFromWorld(world, posStart, size);
        if (!ignoreEntities) {
            schematic.readEntitiesFromWorld(world, posStart, size);
        }
        return schematic;
    }

    @Nullable
    public static SchematicaSchematic createFromFile(File file) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        if (schematic.readFromFile(file)) {
            return schematic;
        }
        return null;
    }

    public boolean readFromNBT(NBTTagCompound nbt) {
        if (this.readBlocksFromNBT(nbt)) {
            this.readEntitiesFromNBT(nbt);
            this.readTileEntitiesFromNBT(nbt);
            return true;
        }
        Litematica.logger.error("SchematicaSchematic: Missing block data in the schematic '{}'", (Object)this.fileName);
        return false;
    }

    private boolean readPaletteFromNBT(NBTTagCompound nbt) {
        Block air = Blocks.field_150350_a;
        this.palette = new Block[4096];
        Arrays.fill(this.palette, air);
        if (nbt.func_150297_b("SchematicaMapping", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("SchematicaMapping");
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                short id = tag.func_74765_d(key);
                if (id >= this.palette.length) {
                    Litematica.logger.error("SchematicaSchematic: Invalid ID '{}' in SchematicaMapping for block '{}', max = 4095", (Object)id, (Object)key);
                    return false;
                }
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(key));
                if (block != null) {
                    this.palette[id] = block;
                    continue;
                }
                Litematica.logger.error("SchematicaSchematic: Missing/non-existing block '{}' in SchematicaMapping", (Object)key);
            }
        } else if (nbt.func_150297_b("BlockIDs", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("BlockIDs");
            Set keys = tag.func_150296_c();
            for (String idStr : keys) {
                int id;
                String key = tag.func_74779_i(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    Litematica.logger.error("SchematicaSchematic: Invalid ID '{}' (not a number) in MCEdit2 palette for block '{}'", (Object)idStr, (Object)key);
                    continue;
                }
                if (id >= this.palette.length) {
                    Litematica.logger.error("SchematicaSchematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = 4095", (Object)id, (Object)key);
                    return false;
                }
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(key));
                if (block != null) {
                    this.palette[id] = block;
                    continue;
                }
                Litematica.logger.error("SchematicaSchematic: Missing/non-existing block '{}' in MCEdit2 palette", (Object)key);
            }
        } else {
            for (ResourceLocation key : Block.field_149771_c.func_148742_b()) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)key);
                if (block == null) continue;
                int id = Block.func_149682_b((Block)block);
                if (id >= 0 && id < this.palette.length) {
                    this.palette[id] = block;
                    continue;
                }
                Litematica.logger.error("SchematicaSchematic: Invalid ID {} for block '{}' from the registry", (Object)id, (Object)key);
            }
        }
        return true;
    }

    private boolean readBlocksFromNBT(NBTTagCompound nbt) {
        if (!(nbt.func_150297_b("Blocks", 7) && nbt.func_150297_b("Data", 7) && nbt.func_150297_b("Width", 2) && nbt.func_150297_b("Height", 2) && nbt.func_150297_b("Length", 2))) {
            return false;
        }
        short sizeX = nbt.func_74765_d("Width");
        short sizeY = nbt.func_74765_d("Height");
        short sizeZ = nbt.func_74765_d("Length");
        byte[] blockIdsByte = nbt.func_74770_j("Blocks");
        byte[] metaArr = nbt.func_74770_j("Data");
        int numBlocks = blockIdsByte.length;
        int layerSize = sizeX * sizeZ;
        if (numBlocks != sizeX * sizeY * sizeZ) {
            Litematica.logger.error("SchematicaSchematic: Mismatched block array size compared to the width/height/length, blocks: {}, W x H x L: {} x {} x {}", (Object)numBlocks, (Object)sizeX, (Object)sizeY, (Object)sizeZ);
            return false;
        }
        if (numBlocks != metaArr.length) {
            Litematica.logger.error("SchematicaSchematic: Mismatched block ID and metadata array sizes, blocks: {}, meta: {}", (Object)numBlocks, (Object)metaArr.length);
            return false;
        }
        if (!this.readPaletteFromNBT(nbt)) {
            Litematica.logger.error("SchematicaSchematic: Failed to read the block palette");
            return false;
        }
        this.size = new Vec3i((int)sizeX, (int)sizeY, (int)sizeZ);
        this.blocks = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
        if (nbt.func_150297_b("AddBlocks", 7)) {
            int z;
            int y;
            int x;
            Block block;
            int byteId;
            byte addValue;
            int expectedAddLength;
            byte[] add = nbt.func_74770_j("AddBlocks");
            if (add.length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
                Litematica.logger.error("SchematicaSchematic: Add array size mismatch, blocks: {}, add: {}, expected add: {}", (Object)numBlocks, (Object)add.length, (Object)expectedAddLength);
                return false;
            }
            int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
            int bi = 0;
            int ai = 0;
            while (bi < loopMax) {
                addValue = add[ai];
                byteId = blockIdsByte[bi] & 0xFF;
                block = this.palette[(addValue & 0xF0) << 4 | byteId];
                x = bi % sizeX;
                y = bi / layerSize;
                z = bi % layerSize / sizeX;
                this.blocks.set(x, y, z, block.func_176203_a((int)metaArr[bi]));
                x = (bi + 1) % sizeX;
                y = (bi + 1) / layerSize;
                z = (bi + 1) % layerSize / sizeX;
                byteId = blockIdsByte[bi + 1] & 0xFF;
                block = this.palette[(addValue & 0xF) << 8 | byteId];
                this.blocks.set(x, y, z, block.func_176203_a((int)metaArr[bi + 1]));
                bi += 2;
                ++ai;
            }
            if (numBlocks % 2 != 0) {
                addValue = add[ai];
                byteId = blockIdsByte[bi] & 0xFF;
                block = this.palette[(addValue & 0xF0) << 4 | byteId];
                x = bi % sizeX;
                y = bi / layerSize;
                z = bi % layerSize / sizeX;
                this.blocks.set(x, y, z, block.func_176203_a((int)metaArr[bi]));
            }
        } else {
            if (nbt.func_150297_b("Add", 7)) {
                Litematica.logger.error("SchematicaSchematic: Old Schematica format detected, not currently implemented...");
                return false;
            }
            for (int i = 0; i < numBlocks; ++i) {
                Block block = this.palette[blockIdsByte[i] & 0xFF];
                int x = i % sizeX;
                int y = i / layerSize;
                int z = i % layerSize / sizeX;
                this.blocks.set(x, y, z, block.func_176203_a((int)metaArr[i]));
            }
        }
        return true;
    }

    private void readEntitiesFromNBT(NBTTagCompound nbt) {
        this.entities.clear();
        NBTTagList tagList = nbt.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.entities.add(tagList.func_150305_b(i));
        }
    }

    private void readTileEntitiesFromNBT(NBTTagCompound nbt) {
        this.tiles.clear();
        NBTTagList tagList = nbt.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            this.tiles.put(pos, tag);
        }
    }

    public boolean readFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            this.fileName = file.getName();
            try {
                FileInputStream is = new FileInputStream(file);
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
                is.close();
                return this.readFromNBT(nbt);
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Failed to read Schematic data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return false;
    }

    private void createPalette() {
        if (this.palette == null) {
            this.palette = new Block[4096];
            ILitematicaBlockStatePalette litematicaPalette = this.blocks.getPalette();
            int numBlocks = litematicaPalette.getPaletteSize();
            for (int i = 0; i < numBlocks; ++i) {
                IBlockState state = litematicaPalette.getBlockState(i);
                Block block = state.func_177230_c();
                int id = Block.func_149682_b((Block)block);
                if (id >= this.palette.length) {
                    throw new IllegalArgumentException(String.format("Block id %d for block '%s' is out of range, max allowed = %d!", id, state, this.palette.length - 1));
                }
                this.palette[id] = block;
            }
        }
    }

    private void writePaletteToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.palette.length; ++i) {
            ResourceLocation rl;
            Block block = this.palette[i];
            if (block == null || (rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)) == null) continue;
            tag.func_74777_a(rl.toString(), (short)(i & 0xFFF));
        }
        nbt.func_74782_a("SchematicaMapping", (NBTBase)tag);
    }

    private void writeBlocksToNBT(NBTTagCompound nbt) {
        int z;
        int y;
        int x;
        nbt.func_74777_a("Width", (short)this.size.func_177958_n());
        nbt.func_74777_a("Height", (short)this.size.func_177956_o());
        nbt.func_74777_a("Length", (short)this.size.func_177952_p());
        nbt.func_74778_a("Materials", "Alpha");
        int numBlocks = this.size.func_177958_n() * this.size.func_177956_o() * this.size.func_177952_p();
        int loopMax = (int)Math.floor((double)numBlocks / 2.0);
        int addSize = (int)Math.ceil((double)numBlocks / 2.0);
        byte[] blockIdsArr = new byte[numBlocks];
        byte[] metaArr = new byte[numBlocks];
        byte[] addArr = new byte[addSize];
        int sizeX = this.size.func_177958_n();
        int sizeZ = this.size.func_177952_p();
        int layerSize = sizeX * sizeZ;
        int numAdd = 0;
        int bi = 0;
        for (int ai = 0; ai < loopMax; ++ai) {
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            IBlockState state1 = this.blocks.get(x, y, z);
            x = (bi + 1) % sizeX;
            y = (bi + 1) / layerSize;
            z = (bi + 1) % layerSize / sizeX;
            IBlockState state2 = this.blocks.get(x, y, z);
            int id1 = Block.func_149682_b((Block)state1.func_177230_c());
            int id2 = Block.func_149682_b((Block)state2.func_177230_c());
            int add = id1 >>> 4 & 0xF0 | id2 >>> 8 & 0xF;
            blockIdsArr[bi] = (byte)(id1 & 0xFF);
            blockIdsArr[bi + 1] = (byte)(id2 & 0xFF);
            if (add != 0) {
                addArr[ai] = (byte)add;
                ++numAdd;
            }
            metaArr[bi] = (byte)state1.func_177230_c().func_176201_c(state1);
            metaArr[bi + 1] = (byte)state2.func_177230_c().func_176201_c(state2);
            bi += 2;
        }
        if (numBlocks % 2 != 0) {
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            IBlockState state = this.blocks.get(x, y, z);
            int id = Block.func_149682_b((Block)state.func_177230_c());
            int add = id >>> 4 & 0xF0;
            blockIdsArr[bi] = (byte)(id & 0xFF);
            if (add != 0) {
                addArr[ai] = (byte)add;
                ++numAdd;
            }
            metaArr[bi] = (byte)state.func_177230_c().func_176201_c(state);
        }
        nbt.func_74773_a("Blocks", blockIdsArr);
        nbt.func_74773_a("Data", metaArr);
        if (numAdd > 0) {
            nbt.func_74773_a("AddBlocks", addArr);
        }
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.createPalette();
        this.writeBlocksToNBT(nbt);
        this.writePaletteToNBT(nbt);
        NBTTagList tagListTiles = new NBTTagList();
        NBTTagList tagListEntities = new NBTTagList();
        for (NBTTagCompound tag : this.entities) {
            tagListEntities.func_74742_a((NBTBase)tag);
        }
        for (NBTTagCompound tag : this.tiles.values()) {
            tagListTiles.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("TileEntities", (NBTBase)tagListTiles);
        nbt.func_74782_a("Entities", (NBTBase)tagListEntities);
        return nbt;
    }

    public boolean writeToFile(File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        String fileName = fileNameIn;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        File fileSchematic = new File(dir, fileName);
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && fileSchematic.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.exists", (Object[])new Object[]{fileSchematic.getAbsolutePath()}));
                return false;
            }
            FileOutputStream os = new FileOutputStream(fileSchematic);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()}));
            return false;
        }
    }
}

