/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.mixin.IMixinDataFixer;
import fi.dy.masa.litematica.mixin.IMixinNBTTagLongArray;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.NBTUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.tuple.Pair;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int SCHEMATIC_VERSION = 4;
    public static final int MINECRAFT_DATA_VERSION = ((IMixinDataFixer)Minecraft.func_71410_x().func_184126_aj()).getVersion();
    private final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    private final Map<String, Map<BlockPos, NBTTagCompound>> tileEntities = new HashMap<String, Map<BlockPos, NBTTagCompound>>();
    private final Map<String, Map<BlockPos, NextTickListEntry>> pendingBlockTicks = new HashMap<String, Map<BlockPos, NextTickListEntry>>();
    private final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    private final Map<String, BlockPos> subRegionPositions = new HashMap<String, BlockPos>();
    private final Map<String, BlockPos> subRegionSizes = new HashMap<String, BlockPos>();
    private final SchematicMetadata metadata = new SchematicMetadata();
    private int totalBlocksReadFromWorld;
    @Nullable
    private final File schematicFile;

    private LitematicaSchematic(@Nullable File file) {
        this.schematicFile = file;
    }

    @Nullable
    public File getFile() {
        return this.schematicFile;
    }

    public Vec3i getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public BlockPos getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, BlockPos> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, BlockPos> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            BlockPos pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public BlockPos getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.func_177971_a((Vec3i)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(World world, AreaSelection area, boolean ignoreEntities, String author, IStringConsumer feedback) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            feedback.setString(StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]));
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        long time = System.currentTimeMillis();
        BlockPos origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes);
        if (!ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vec3i)PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        return schematic;
    }

    public static LitematicaSchematic createEmptySchematic(AreaSelection area, String author) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        schematic.setSubRegionPositions(boxes, area.getEffectiveOrigin());
        schematic.setSubRegionSizes(boxes);
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vec3i)PositionUtils.getEnclosingAreaSize(boxes));
        for (Box box : boxes) {
            String regionName = box.getName();
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.func_177958_n());
            int sizeY = Math.abs(size.func_177956_o());
            int sizeZ = Math.abs(size.func_177952_p());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            schematic.blockContainers.put(regionName, container);
            schematic.tileEntities.put(regionName, new HashMap());
            schematic.entities.put(regionName, new ArrayList());
            schematic.pendingBlockTicks.put(regionName, new HashMap());
        }
        return schematic;
    }

    public void takeEntityDataFromSchematicaSchematic(SchematicaSchematic schematic, String subRegionName) {
        this.tileEntities.put(subRegionName, schematic.getTiles());
        this.entities.put(subRegionName, schematic.getEntities());
    }

    public boolean placeToWorld(World world, SchematicPlacement schematicPlacement, LayerRange range, boolean notifyNeighbors) {
        WorldUtils.setShouldPreventOnBlockAdded(true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, NBTTagCompound> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<BlockPos, NextTickListEntry> scheduledTicks = this.pendingBlockTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledTicks, range, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList, range);
        }
        WorldUtils.setShouldPreventOnBlockAdded(false);
        return true;
    }

    private boolean placeBlocksToWorld(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, NBTTagCompound> tileMap, @Nullable Map<BlockPos, NextTickListEntry> scheduledTicks, LayerRange range, boolean notifyNeighbors) {
        int x;
        int z;
        int y;
        BlockPos posEndRelSub = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize);
        BlockPos posEndRel = posEndRelSub.func_177971_a((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedBlockPos(posEndRelSub, placement.getMirror(), placement.getRotation()).func_177971_a((Vec3i)regionPosTransformed).func_177971_a((Vec3i)origin);
        BlockPos regionPosAbs = regionPosTransformed.func_177971_a((Vec3i)origin);
        if (!PositionUtils.arePositionsWithinWorld(world, regionPosAbs, posEndAbs) || !range.intersectsBox(regionPosAbs, posEndAbs)) {
            return false;
        }
        Pair<Vec3i, Vec3i> pair = SchematicUtils.getLayerRangeClampedSubRegion(range, schematicPlacement, placement, (Vec3i)regionSize);
        if (pair == null) {
            return false;
        }
        IBlockState barrier = Blocks.field_180401_cv.func_176223_P();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        ReplaceBehavior replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        Vec3i containerStart = (Vec3i)pair.getLeft();
        Vec3i containerEnd = (Vec3i)pair.getRight();
        int startX = containerStart.func_177958_n();
        int startY = containerStart.func_177956_o();
        int startZ = containerStart.func_177952_p();
        int endX = containerEnd.func_177958_n();
        int endY = containerEnd.func_177956_o();
        int endZ = containerEnd.func_177952_p();
        for (y = startY; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                for (x = startX; x <= endX; ++x) {
                    TileEntity te;
                    IBlockState state = container.get(x, y, z);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    posMutable.func_181079_c(x, y, z);
                    NBTTagCompound teNBT = tileMap.get(posMutable);
                    posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                    BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.func_177971_a((Vec3i)regionPosTransformed).func_177971_a((Vec3i)origin);
                    IBlockState stateOld = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
                    if (replace == ReplaceBehavior.NONE && stateOld.func_185904_a() != Material.field_151579_a || replace == ReplaceBehavior.WITH_NON_AIR && state.func_185904_a() == Material.field_151579_a) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.func_185902_a(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.func_185902_a(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.func_185907_a(rotationCombined);
                    }
                    if (stateOld == state) continue;
                    TileEntity teOld = world.func_175625_s(pos);
                    if (teOld != null) {
                        if (teOld instanceof IInventory) {
                            ((IInventory)teOld).func_174888_l();
                        }
                        world.func_180501_a(pos, barrier, 20);
                    }
                    if (!world.func_180501_a(pos, state, 18) || teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                    teNBT = teNBT.func_74737_b();
                    teNBT.func_74768_a("x", pos.func_177958_n());
                    teNBT.func_74768_a("y", pos.func_177956_o());
                    teNBT.func_74768_a("z", pos.func_177952_p());
                    try {
                        te.func_145839_a(teNBT);
                        if (mirrorMain != Mirror.NONE) {
                            te.func_189668_a(mirrorMain);
                        }
                        if (mirrorSub != Mirror.NONE) {
                            te.func_189668_a(mirrorSub);
                        }
                        if (rotationCombined == Rotation.NONE) continue;
                        te.func_189667_a(rotationCombined);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = containerStart.func_177956_o(); y < containerEnd.func_177956_o(); ++y) {
                for (z = containerStart.func_177952_p(); z < containerEnd.func_177952_p(); ++z) {
                    for (x = containerStart.func_177958_n(); x < containerEnd.func_177958_n(); ++x) {
                        posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                        BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement).func_177971_a((Vec3i)origin);
                        world.func_175722_b(pos, world.func_180495_p(pos).func_177230_c(), false);
                    }
                }
            }
        }
        if (scheduledTicks != null && !scheduledTicks.isEmpty()) {
            for (Map.Entry<BlockPos, NextTickListEntry> entry : scheduledTicks.entrySet()) {
                BlockPos pos = entry.getKey().func_177971_a((Vec3i)regionPosAbs);
                NextTickListEntry tick = entry.getValue();
                world.func_180497_b(pos, world.func_180495_p(pos).func_177230_c(), (int)tick.field_77180_e, tick.field_82754_f);
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList, LayerRange range) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.func_177958_n() + origin.func_177958_n();
        int offY = regionPosRelTransformed.func_177956_o() + origin.func_177956_o();
        int offZ = regionPosRelTransformed.func_177952_p() + origin.func_177952_p();
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity;
            Vec3d pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            if (!range.isPositionWithinRange((int)Math.floor(pos.field_72450_a), (int)Math.floor(pos.field_72448_b), (int)Math.floor(pos.field_72449_c)) || (entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world)) == null) continue;
            double x = pos.field_72450_a + (double)offX;
            double y = pos.field_72448_b + (double)offY;
            double z = pos.field_72449_c + (double)offZ;
            this.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public boolean placeToWorldWithinChunk(World world, ChunkPos chunkPos, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : regionsTouchingChunk) {
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, NBTTagCompound> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksWithinChunk(world, chunkPos, regionName, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorldWithinChunk(world, chunkPos, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        return true;
    }

    private void placeBlocksWithinChunk(World world, ChunkPos chunkPos, String regionName, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, NBTTagCompound> tileMap, boolean notifyNeighbors) {
        int x;
        int z;
        int y;
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (bounds == null) {
            return;
        }
        BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).func_177971_a((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos boxMinRel = new BlockPos(bounds.minX - origin.func_177958_n() - regionPosTransformed.func_177958_n(), 0, bounds.minZ - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        BlockPos boxMaxRel = new BlockPos(bounds.maxX - origin.func_177958_n() - regionPosTransformed.func_177958_n(), 0, bounds.maxZ - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.func_177973_b((Vec3i)posMinRel.func_177973_b((Vec3i)regionPos));
        boxMaxRel = boxMaxRel.func_177973_b((Vec3i)posMinRel.func_177973_b((Vec3i)regionPos));
        BlockPos posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        BlockPos posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        int startX = posMin.func_177958_n();
        int startZ = posMin.func_177952_p();
        int endX = posMax.func_177958_n();
        int endZ = posMax.func_177952_p();
        boolean startY = false;
        int endY = Math.abs(regionSize.func_177956_o()) - 1;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().func_177958_n() || endZ >= container.getSize().func_177952_p()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().func_177958_n(), container.getSize().func_177952_p());
            return;
        }
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        IBlockState barrier = Blocks.field_180401_cv.func_176223_P();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (y = 0; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                for (x = startX; x <= endX; ++x) {
                    TileEntity te;
                    IBlockState state = container.get(x, y, z);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    posMutable.func_181079_c(x, y, z);
                    NBTTagCompound teNBT = tileMap.get(posMutable);
                    posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                    BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.func_177971_a((Vec3i)regionPosTransformed).func_177971_a((Vec3i)origin);
                    if (mirrorMain != Mirror.NONE) {
                        state = state.func_185902_a(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.func_185902_a(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.func_185907_a(rotationCombined);
                    }
                    if (teNBT != null && (te = world.func_175625_s(pos)) != null) {
                        if (te instanceof IInventory) {
                            ((IInventory)te).func_174888_l();
                        }
                        world.func_180501_a(pos, barrier, 20);
                    }
                    if (!world.func_180501_a(pos, state, 18) || teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                    teNBT = teNBT.func_74737_b();
                    teNBT.func_74768_a("x", pos.func_177958_n());
                    teNBT.func_74768_a("y", pos.func_177956_o());
                    teNBT.func_74768_a("z", pos.func_177952_p());
                    try {
                        te.func_145839_a(teNBT);
                        if (mirrorMain != Mirror.NONE) {
                            te.func_189668_a(mirrorMain);
                        }
                        if (mirrorSub != Mirror.NONE) {
                            te.func_189668_a(mirrorSub);
                        }
                        if (rotationCombined == Rotation.NONE) continue;
                        te.func_189667_a(rotationCombined);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = startX; y <= endY; ++y) {
                for (z = 0; z <= endZ; ++z) {
                    for (x = startZ; x <= endX; ++x) {
                        posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                        BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement).func_177971_a((Vec3i)origin);
                        world.func_175722_b(pos, world.func_180495_p(pos).func_177230_c(), false);
                    }
                }
            }
        }
    }

    private void placeEntitiesToWorldWithinChunk(World world, ChunkPos chunkPos, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.func_177958_n() + origin.func_177958_n();
        int offY = regionPosRelTransformed.func_177956_o() + origin.func_177956_o();
        int offZ = regionPosRelTransformed.func_177952_p() + origin.func_177952_p();
        double minX = chunkPos.field_77276_a << 4;
        double minZ = chunkPos.field_77275_b << 4;
        double maxX = (chunkPos.field_77276_a << 4) + 16;
        double maxZ = (chunkPos.field_77275_b << 4) + 16;
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vec3d pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_72450_a + (double)offX;
            double y = pos.field_72448_b + (double)offY;
            double z = pos.field_72449_c + (double)offZ;
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            this.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void rotateEntity(Entity entity, double x, double y, double z, Rotation rotationCombined, Mirror mirrorMain, Mirror mirrorSub) {
        float rotationYaw = entity.field_70177_z;
        if (mirrorMain != Mirror.NONE) {
            rotationYaw = entity.func_184217_a(mirrorMain);
        }
        if (mirrorSub != Mirror.NONE) {
            rotationYaw = entity.func_184217_a(mirrorSub);
        }
        if (rotationCombined != Rotation.NONE) {
            rotationYaw += entity.field_70177_z - entity.func_184229_a(rotationCombined);
        }
        entity.func_70012_b(x, y, z, rotationYaw, entity.field_70125_A);
        entity.field_70126_B = rotationYaw;
        entity.field_70127_C = entity.field_70125_A;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            livingBase.field_70759_as = rotationYaw;
            livingBase.field_70758_at = rotationYaw;
            livingBase.field_70761_aq = rotationYaw;
            livingBase.field_70760_ar = rotationYaw;
        }
    }

    private void takeEntitiesFromWorld(World world, List<Box> boxes, BlockPos origin) {
        for (Box box : boxes) {
            AxisAlignedBB bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            BlockPos regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.func_175674_a(null, bb, null);
            for (Entity entity : entities) {
                NBTTagCompound tag;
                if (!entity.func_70039_c(tag = new NBTTagCompound())) continue;
                Vec3d posVec = new Vec3d(entity.field_70165_t - (double)regionPosAbs.func_177958_n(), entity.field_70163_u - (double)regionPosAbs.func_177956_o(), entity.field_70161_v - (double)regionPosAbs.func_177952_p());
                NBTUtils.writeEntityPositionToTag((Vec3d)posVec, (NBTTagCompound)tag);
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(World world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, BlockPos origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            AxisAlignedBB bb = PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.func_175674_a(null, bb, null);
            BlockPos regionPosAbs = box.getPos1();
            for (Entity entity : entities) {
                NBTTagCompound tag;
                UUID uuid = entity.func_110124_au();
                if (existingEntities.contains(uuid) || !entity.func_70039_c(tag = new NBTTagCompound())) continue;
                Vec3d posVec = new Vec3d(entity.field_70165_t - (double)regionPosAbs.func_177958_n(), entity.field_70163_u - (double)regionPosAbs.func_177956_o(), entity.field_70161_v - (double)regionPosAbs.func_177952_p());
                NBTUtils.writeEntityPositionToTag((Vec3d)posVec, (NBTTagCompound)tag);
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(World world, List<Box> boxes) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Box box : boxes) {
            IntBoundingBox structureBB;
            List pendingTicks;
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.func_177958_n());
            int sizeY = Math.abs(size.func_177956_o());
            int sizeZ = Math.abs(size.func_177952_p());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<BlockPos, NBTTagCompound> tileEntityMap = new HashMap<BlockPos, NBTTagCompound>();
            HashMap<BlockPos, NextTickListEntry> tickMap = new HashMap<BlockPos, NextTickListEntry>();
            BlockPos minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.func_177958_n();
            int startY = minCorner.func_177956_o();
            int startZ = minCorner.func_177952_p();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        TileEntity te;
                        posMutable.func_181079_c(x + startX, y + startY, z + startZ);
                        IBlockState state = world.func_180495_p((BlockPos)posMutable).func_185899_b((IBlockAccess)world, (BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (state.func_177230_c() != Blocks.field_150350_a) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.func_177230_c().hasTileEntity(state) || (te = world.func_175625_s((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        NBTTagCompound tag = te.func_189515_b(new NBTTagCompound());
                        NBTUtils.writeBlockPosToTag((Vec3i)pos, (NBTTagCompound)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof WorldServer && (pendingTicks = ((WorldServer)world).func_175712_a((structureBB = IntBoundingBox.createProper((int)startX, (int)startY, (int)startZ, (int)(startX + sizeX), (int)(startY + sizeY), (int)(startZ + sizeZ))).toVanillaBox(), false)) != null) {
                int listSize = pendingTicks.size();
                long currentTime = world.func_82737_E();
                for (int i = 0; i < listSize; ++i) {
                    NextTickListEntry entry = (NextTickListEntry)pendingTicks.get(i);
                    if (entry.field_180282_a.func_177956_o() < startY || entry.field_180282_a.func_177956_o() >= structureBB.maxY) continue;
                    BlockPos posRelative = new BlockPos(entry.field_180282_a.func_177958_n() - minCorner.func_177958_n(), entry.field_180282_a.func_177956_o() - minCorner.func_177956_o(), entry.field_180282_a.func_177952_p() - minCorner.func_177952_p());
                    NextTickListEntry newEntry = new NextTickListEntry(posRelative, entry.func_151351_a());
                    newEntry.func_82753_a(entry.field_82754_f);
                    newEntry.func_77176_a(entry.field_77180_e - currentTime);
                    tickMap.put(posRelative, newEntry);
                }
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), tickMap);
        }
    }

    public void takeBlocksFromWorldWithinChunk(World world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Map.Entry volumeEntry : volumes.entrySet()) {
            IntBoundingBox structureBB;
            List pendingTicks;
            String regionName = (String)volumeEntry.getKey();
            IntBoundingBox bb = (IntBoundingBox)volumeEntry.getValue();
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null) {
                Litematica.logger.error("null Box for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, NBTTagCompound> tileEntityMap = this.tileEntities.get(regionName);
            Map<BlockPos, NextTickListEntry> tickMap = this.pendingBlockTicks.get(regionName);
            if (container == null || tileEntityMap == null || tickMap == null) {
                Litematica.logger.error("null map(s) for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            BlockPos minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int offsetX = minCorner.func_177958_n();
            int offsetY = minCorner.func_177956_o();
            int offsetZ = minCorner.func_177952_p();
            int startX = bb.minX - minCorner.func_177958_n();
            int startY = bb.minY - minCorner.func_177956_o();
            int startZ = bb.minZ - minCorner.func_177952_p();
            int endX = startX + (bb.maxX - bb.minX);
            int endY = startY + (bb.maxY - bb.minY);
            int endZ = startZ + (bb.maxZ - bb.minZ);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        TileEntity te;
                        posMutable.func_181079_c(x + offsetX, y + offsetY, z + offsetZ);
                        IBlockState state = world.func_180495_p((BlockPos)posMutable).func_185899_b((IBlockAccess)world, (BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (state.func_177230_c() != Blocks.field_150350_a) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.func_177230_c().hasTileEntity(state) || (te = world.func_175625_s((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        NBTTagCompound tag = te.func_189515_b(new NBTTagCompound());
                        NBTUtils.writeBlockPosToTag((Vec3i)pos, (NBTTagCompound)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (!(world instanceof WorldServer) || (pendingTicks = ((WorldServer)world).func_175712_a((structureBB = IntBoundingBox.createProper((int)(offsetX + startX), (int)(offsetY + startY), (int)(offsetZ + startZ), (int)(offsetX + endX + 1), (int)(offsetY + endY + 1), (int)(offsetZ + endZ + 1))).toVanillaBox(), false)) == null) continue;
            int listSize = pendingTicks.size();
            long currentTime = world.func_82737_E();
            for (int i = 0; i < listSize; ++i) {
                NextTickListEntry entry = (NextTickListEntry)pendingTicks.get(i);
                if (entry.field_180282_a.func_177956_o() < offsetY || entry.field_180282_a.func_177956_o() >= structureBB.maxY) continue;
                BlockPos posRelative = new BlockPos(entry.field_180282_a.func_177958_n() - minCorner.func_177958_n(), entry.field_180282_a.func_177956_o() - minCorner.func_177956_o(), entry.field_180282_a.func_177952_p() - minCorner.func_177952_p());
                NextTickListEntry newEntry = new NextTickListEntry(posRelative, entry.func_151351_a());
                newEntry.func_82753_a(entry.field_82754_f);
                newEntry.func_77176_a(entry.field_77180_e - currentTime);
                tickMap.put(posRelative, newEntry);
            }
        }
    }

    private void setSubRegionPositions(List<Box> boxes, BlockPos areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().func_177973_b((Vec3i)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Version", 4);
        nbt.func_74768_a("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.func_74782_a("Metadata", (NBTBase)this.metadata.writeToNBT());
        nbt.func_74782_a("Regions", (NBTBase)this.writeSubRegionsToNBT());
        return nbt;
    }

    private NBTTagCompound writeSubRegionsToNBT() {
        NBTTagCompound wrapper = new NBTTagCompound();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<BlockPos, NBTTagCompound> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map<BlockPos, NextTickListEntry> pendingTicks = this.pendingBlockTicks.get(regionName);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("BlockStatePalette", (NBTBase)blockContainer.getPalette().writeToNBT());
                tag.func_74782_a("BlockStates", (NBTBase)new NBTTagLongArray(blockContainer.getBackingLongArray()));
                tag.func_74782_a("TileEntities", (NBTBase)this.writeTileEntitiesToNBT(tileMap));
                if (pendingTicks != null) {
                    tag.func_74782_a("PendingBlockTicks", (NBTBase)this.writeBlockTicksToNBT(pendingTicks));
                }
                if (entityList != null) {
                    tag.func_74782_a("Entities", (NBTBase)this.writeEntitiesToNBT(entityList));
                }
                BlockPos pos = this.subRegionPositions.get(regionName);
                tag.func_74782_a("Position", (NBTBase)NBTUtils.createBlockPosTag((Vec3i)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.func_74782_a("Size", (NBTBase)NBTUtils.createBlockPosTag((Vec3i)pos));
                wrapper.func_74782_a(regionName, (NBTBase)tag);
            }
        }
        return wrapper;
    }

    private NBTTagList writeEntitiesToNBT(List<EntityInfo> entityList) {
        NBTTagList tagList = new NBTTagList();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.func_74742_a((NBTBase)info.nbt);
            }
        }
        return tagList;
    }

    private NBTTagList writeBlockTicksToNBT(Map<BlockPos, NextTickListEntry> tickMap) {
        NBTTagList tagList = new NBTTagList();
        if (!tickMap.isEmpty()) {
            for (NextTickListEntry entry : tickMap.values()) {
                ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)entry.func_151351_a());
                if (rl == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Block", rl.toString());
                tag.func_74768_a("Priority", entry.field_82754_f);
                tag.func_74768_a("Time", (int)entry.field_77180_e);
                tag.func_74768_a("x", entry.field_180282_a.func_177958_n());
                tag.func_74768_a("y", entry.field_180282_a.func_177956_o());
                tag.func_74768_a("z", entry.field_180282_a.func_177952_p());
                tagList.func_74742_a((NBTBase)tag);
            }
        }
        return tagList;
    }

    private NBTTagList writeTileEntitiesToNBT(Map<BlockPos, NBTTagCompound> tileMap) {
        NBTTagList tagList = new NBTTagList();
        if (!tileMap.isEmpty()) {
            for (NBTTagCompound tag : tileMap.values()) {
                tagList.func_74742_a((NBTBase)tag);
            }
        }
        return tagList;
    }

    private boolean readFromNBT(NBTTagCompound nbt) {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        this.metadata.clearModifiedSinceSaved();
        if (nbt.func_150297_b("Version", 3)) {
            int version = nbt.func_74762_e("Version");
            if (version >= 1 && version <= 4) {
                this.metadata.readFromNBT(nbt.func_74775_l("Metadata"));
                this.readSubRegionsFromNBT(nbt.func_74775_l("Regions"), version);
                return true;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.unsupported_schematic_version", (Object[])new Object[]{version});
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.no_schematic_version_information", (Object[])new Object[0]);
        }
        return false;
    }

    private void readSubRegionsFromNBT(NBTTagCompound tag, int version) {
        for (String regionName : tag.func_150296_c()) {
            NBTBase nbtBase;
            if (tag.func_74781_a(regionName).func_74732_a() != 10) continue;
            NBTTagCompound regionTag = tag.func_74775_l(regionName);
            BlockPos regionPos = NBTUtils.readBlockPos((NBTTagCompound)regionTag.func_74775_l("Position"));
            BlockPos regionSize = NBTUtils.readBlockPos((NBTTagCompound)regionTag.func_74775_l("Size"));
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                this.tileEntities.put(regionName, this.readTileEntitiesFromNBT(regionTag.func_150295_c("TileEntities", 10)));
                this.entities.put(regionName, this.readEntitiesFromNBT(regionTag.func_150295_c("Entities", 10)));
            } else if (version == 1) {
                this.tileEntities.put(regionName, this.readTileEntitiesFromNBT_v1(regionTag.func_150295_c("TileEntities", 10)));
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.func_150295_c("Entities", 10)));
            }
            if (version >= 3) {
                this.pendingBlockTicks.put(regionName, this.readBlockTicksFromNBT(regionTag.func_150295_c("PendingBlockTicks", 10)));
            }
            if ((nbtBase = regionTag.func_74781_a("BlockStates")) == null || nbtBase.func_74732_a() != 12) continue;
            NBTTagList palette = regionTag.func_150295_c("BlockStatePalette", 10);
            long[] blockStateArr = ((IMixinNBTTagLongArray)nbtBase).getArray();
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).func_177971_a((Vec3i)regionPos);
            BlockPos posMin = PositionUtils.getMinCorner(regionPos, posEndRel);
            BlockPos posMax = PositionUtils.getMaxCorner(regionPos, posEndRel);
            BlockPos size = posMax.func_177973_b((Vec3i)posMin).func_177982_a(1, 1, 1);
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            this.blockContainers.put(regionName, container);
        }
    }

    private List<EntityInfo> readEntitiesFromNBT(NBTTagList tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound entityData = tagList.func_150305_b(i);
            Vec3d posVec = NBTUtils.readEntityPositionFromTag((NBTTagCompound)entityData);
            if (posVec == null || entityData.func_82582_d()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, NBTTagCompound> readTileEntitiesFromNBT(NBTTagList tagList) {
        HashMap<BlockPos, NBTTagCompound> tileMap = new HashMap<BlockPos, NBTTagCompound>();
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            BlockPos pos = NBTUtils.readBlockPos((NBTTagCompound)tag);
            if (pos == null || tag.func_82582_d()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private Map<BlockPos, NextTickListEntry> readBlockTicksFromNBT(NBTTagList tagList) {
        HashMap<BlockPos, NextTickListEntry> tickMap = new HashMap<BlockPos, NextTickListEntry>();
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            Block block;
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (!tag.func_150297_b("Block", 8) || !tag.func_150297_b("Time", 99) || (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("Block")))) == null || block == Blocks.field_150350_a) continue;
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            NextTickListEntry entry = new NextTickListEntry(pos, block);
            entry.func_82753_a(tag.func_74762_e("Priority"));
            entry.func_77176_a((long)tag.func_74762_e("Time"));
            tickMap.put(pos, entry);
        }
        return tickMap;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(NBTTagList tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            Vec3d posVec = NBTUtils.readVec3d((NBTTagCompound)tag);
            NBTTagCompound entityData = tag.func_74775_l("EntityData");
            if (posVec == null || entityData.func_82582_d()) continue;
            NBTUtils.writeEntityPositionToTag((Vec3d)posVec, (NBTTagCompound)entityData);
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, NBTTagCompound> readTileEntitiesFromNBT_v1(NBTTagList tagList) {
        HashMap<BlockPos, NBTTagCompound> tileMap = new HashMap<BlockPos, NBTTagCompound>();
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            NBTTagCompound tileNbt = tag.func_74775_l("TileNBT");
            BlockPos pos = NBTUtils.readBlockPos((NBTTagCompound)tag);
            if (pos == null || tileNbt.func_82582_d()) continue;
            NBTUtils.writeBlockPosToTag((Vec3i)pos, (NBTTagCompound)tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(File dir, String fileNameIn, boolean override) {
        String fileName = fileNameIn;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        File fileSchematic = new File(dir, fileName);
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()});
                return false;
            }
            if (!override && fileSchematic.exists()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exists", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
                return false;
            }
            FileOutputStream os = new FileOutputStream(fileSchematic);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)e.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }

    public boolean readFromFile() {
        if (this.schematicFile == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.no_file", (Object[])new Object[0]);
            return false;
        }
        File file = this.schematicFile;
        if (!file.exists() || !file.canRead()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.cant_read", (Object[])new Object[]{file.getAbsolutePath()});
            return false;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
            return nbt != null && this.readFromNBT(nbt);
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()});
            return false;
        }
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName) {
        File file;
        LitematicaSchematic schematic;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        return (schematic = new LitematicaSchematic(file = new File(dir, fileName))).readFromFile() ? schematic : null;
    }

    public static class EntityInfo {
        public final Vec3d posVec;
        public final NBTTagCompound nbt;

        public EntityInfo(Vec3d posVec, NBTTagCompound nbt) {
            this.posVec = posVec;
            this.nbt = nbt;
        }
    }
}

