/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TaskPasteSchematicSetblock
extends TaskBase
implements IInfoHudRenderer {
    private final ArrayListMultimap<ChunkPos, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    private final List<IntBoundingBox> boxesInCurrentChunk = new ArrayList<IntBoundingBox>();
    private final List<ChunkPos> chunks = new ArrayList<ChunkPos>();
    private final PositionUtils.ChunkPosComparator comparator;
    private final int maxCommandsPerTick;
    private final boolean changedBlockOnly;
    private final ReplaceBehavior replace;
    private int sentCommandsThisTick;
    private int sentCommandsTotal;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int currentIndex;
    private int boxVolume;
    private boolean boxInProgress;

    public TaskPasteSchematicSetblock(SchematicPlacement placement, LayerRange range, boolean changedBlocksOnly) {
        this.changedBlockOnly = changedBlocksOnly;
        this.maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
        Set<ChunkPos> touchedChunks = placement.getTouchedChunks();
        for (ChunkPos pos : touchedChunks) {
            int count = 0;
            for (IntBoundingBox box : placement.getBoxesWithinChunk(pos.field_77276_a, pos.field_77275_b).values()) {
                if ((box = range.getClampedBox(box)) == null) continue;
                this.boxesInChunks.put((Object)pos, (Object)box);
                ++count;
            }
            if (count <= 0) continue;
            this.chunks.add(pos);
        }
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    @Override
    public boolean canExecute() {
        return !this.boxesInChunks.isEmpty() && this.mc.field_71441_e != null && this.mc.field_71439_g != null;
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        WorldClient worldClient = this.mc.field_71441_e;
        this.sentCommandsThisTick = 0;
        int processed = 0;
        int chunkAttempts = 0;
        if (this.sentCommandsTotal == 0) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback false");
        }
        block0: while (!this.chunks.isEmpty()) {
            ChunkPos pos = this.chunks.get(0);
            if (!this.canProcessChunk(pos, (World)worldSchematic, worldClient)) {
                if (this.boxInProgress || chunkAttempts > 0) {
                    return false;
                }
                this.sortChunkList();
                ++chunkAttempts;
                continue;
            }
            while (!this.boxesInCurrentChunk.isEmpty()) {
                IntBoundingBox box = this.boxesInCurrentChunk.get(0);
                if (this.processBox(pos, box, worldSchematic, worldClient, this.mc.field_71439_g)) {
                    this.boxesInCurrentChunk.remove(0);
                    if (!this.boxesInCurrentChunk.isEmpty()) continue;
                    this.boxesInChunks.removeAll((Object)pos);
                    this.chunks.remove(0);
                    ++processed;
                    if (this.chunks.isEmpty()) {
                        this.finished = true;
                        return true;
                    }
                    this.sortChunkList();
                    continue block0;
                }
                if (processed > 0) {
                    this.updateInfoHudLines();
                }
                return false;
            }
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    private void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.field_71439_g != null) {
                this.comparator.setReferencePosition(new BlockPos((Entity)this.mc.field_71439_g));
                Collections.sort(this.chunks, this.comparator);
            }
            this.boxesInCurrentChunk.clear();
            this.boxesInCurrentChunk.addAll(this.boxesInChunks.get((Object)this.chunks.get(0)));
        }
    }

    protected boolean canProcessChunk(ChunkPos pos, World worldSchematic, WorldClient worldClient) {
        if (!worldSchematic.func_72863_F().func_191062_e(pos.field_77276_a, pos.field_77275_b) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected boolean processBox(ChunkPos pos, IntBoundingBox box, WorldSchematic worldSchematic, WorldClient worldClient, EntityPlayerSP player) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        Chunk chunkSchematic = worldSchematic.func_72863_F().func_186026_b(pos.field_77276_a, pos.field_77275_b);
        Chunk chunkClient = worldClient.func_72863_F().func_186026_b(pos.field_77276_a, pos.field_77275_b);
        if (!this.boxInProgress) {
            this.currentX = box.minX;
            this.currentY = box.minY;
            this.currentZ = box.minZ;
            this.boxVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1);
            this.currentIndex = 0;
            this.boxInProgress = true;
        }
        while (this.currentIndex < this.boxVolume) {
            posMutable.func_181079_c(this.currentX, this.currentY, this.currentZ);
            if (++this.currentY > box.maxY) {
                this.currentY = box.minY;
                if (++this.currentX > box.maxX) {
                    this.currentX = box.minX;
                    ++this.currentZ;
                }
            }
            ++this.currentIndex;
            IBlockState stateSchematicOrig = chunkSchematic.func_177435_g((BlockPos)posMutable);
            IBlockState stateClient = chunkClient.func_177435_g((BlockPos)posMutable);
            if (stateSchematicOrig.func_177230_c() == Blocks.field_150350_a && stateClient.func_177230_c() == Blocks.field_150350_a) continue;
            IBlockState stateSchematic = stateSchematicOrig.func_177230_c().func_176203_a(stateSchematicOrig.func_177230_c().func_176201_c(stateSchematicOrig));
            if (this.changedBlockOnly && stateClient == stateSchematic || this.replace == ReplaceBehavior.NONE && stateClient.func_185904_a() != Material.field_151579_a || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematicOrig.func_185904_a() == Material.field_151579_a) continue;
            this.sendSetBlockCommand(posMutable.func_177958_n(), posMutable.func_177956_o(), posMutable.func_177952_p(), stateSchematicOrig, player);
            if (++this.sentCommandsThisTick < this.maxCommandsPerTick) continue;
            break;
        }
        if (this.currentIndex >= this.boxVolume) {
            this.summonEntities(box, worldSchematic, player);
            this.boxInProgress = false;
            return true;
        }
        return false;
    }

    private void summonEntities(IntBoundingBox box, WorldSchematic worldSchematic, EntityPlayerSP player) {
        AxisAlignedBB bb = new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        List entities = worldSchematic.func_72839_b(null, bb);
        for (Entity entity : entities) {
            ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
            if (rl == null) continue;
            String entityName = rl.toString();
            String strCommand = String.format(Locale.ROOT, "/summon %s %f %f %f", entityName, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            player.func_71165_d(strCommand);
        }
    }

    private void sendSetBlockCommand(int x, int y, int z, IBlockState state, EntityPlayerSP player) {
        Block block = state.func_177230_c();
        ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        if (rl == null) {
            return;
        }
        String blockName = rl.toString();
        String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        String strCommand = String.format("/%s %d %d %d %s %d", cmdName, x, y, z, blockName, block.func_176201_c(state));
        player.func_71165_d(strCommand);
        ++this.sentCommandsTotal;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentCommandsTotal});
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.field_71439_g != null) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    private void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            ChunkPos pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.field_77276_a, pos.field_77275_b, pos.field_77276_a << 4, pos.field_77275_b << 4));
        }
        this.infoHudLines = hudLines;
    }
}

