/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ImmutableCollection;
import fi.dy.masa.litematica.materials.IMaterialList;
import fi.dy.masa.litematica.scheduler.tasks.TaskCountBlocksBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TaskCountBlocksPlacement
extends TaskCountBlocksBase {
    protected final SchematicPlacement schematicPlacement;
    protected final WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();

    public TaskCountBlocksPlacement(SchematicPlacement schematicPlacement, IMaterialList materialList) {
        super(materialList, "litematica.gui.label.task_name.material_list");
        this.schematicPlacement = schematicPlacement;
        ImmutableCollection boxes = schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).values();
        this.addBoxesPerChunks((Collection<Box>)boxes);
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.worldSchematic != null;
    }

    @Override
    protected void countAtPosition(BlockPos pos) {
        IBlockState stateSchematic = this.worldSchematic.func_180495_p(pos).func_185899_b((IBlockAccess)this.worldSchematic, pos);
        if (stateSchematic.func_177230_c() != Blocks.field_150350_a) {
            IBlockState stateClient = this.worldClient.func_180495_p(pos).func_185899_b((IBlockAccess)this.worldClient, pos);
            this.countsTotal.addTo((Object)stateSchematic, 1);
            if (stateClient.func_177230_c() == Blocks.field_150350_a) {
                this.countsMissing.addTo((Object)stateSchematic, 1);
            } else if (stateClient != stateSchematic) {
                this.countsMissing.addTo((Object)stateSchematic, 1);
                this.countsMismatch.addTo((Object)stateSchematic, 1);
            }
        }
    }
}

